<?php
/**
 * Graceful Nova Theme Posts Slider with Dynamic Background from Image Color
 */

function graceful_nova_render_post_slider() {
$recent_posts = get_posts(
	array(
		'numberposts' => 4,
		'post_status' => 'publish',
	)
);

if ( empty( $recent_posts ) ) {
	return;
}
?>

<div class="nova-slider-container <?php echo esc_attr( graceful_nova_blog_options( 'nova_slider_width' ) ) === 'wrapped' ? ' wrapped-content': ''; ?> clear-fix">
	<div style="position: relative;">
		<div class="nova-slide-nav">
		<span class="nova-prev">‹</span>
		<span class="nova-next">›</span>
	</div>
	<div class="owl-carousel nova-slider-carousel">
		<?php foreach ( $recent_posts as $index => $post ) : ?>
			<?php
			setup_postdata( $post );
			$image_url  = get_the_post_thumbnail_url( $post, 'large' );
			$categories = get_the_category( $post->ID );
			$category   = ! empty( $categories ) ? $categories[0]->name : __( 'Uncategorized', 'graceful-nova-blog' );
			?>
			<div class="nova-slide">
				<div class="nova-slide-left">
					<div class="nova-slide-left-content">
						<small><?php echo esc_html( $category ); ?></small>
						<div class="nova-spacer">
							<hr/>
						</div>
						<h2>
							<a href="<?php echo esc_url( get_permalink( $post ) ); ?>">
								<?php echo esc_html( get_the_title( $post ) ); ?>
							</a>
						</h2>
						<p><?php echo esc_html( wp_trim_words( get_the_excerpt( $post ), 20 ) ); ?></p>
						<a class="nova-read-button" href="<?php echo esc_url( get_permalink( $post ) ); ?>">
							<?php esc_html_e( 'Read More', 'graceful-nova-blog' ); ?>
						</a>
					</div>
				</div>
				<div class="nova-slide-right">
					<?php if ( $image_url ) : ?>
						<img class="nova-slide-image" src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( get_the_title( $post ) ); ?>" crossorigin="anonymous">
					<?php endif; ?>
				</div>
			</div>

		<?php endforeach; ?>
		<?php wp_reset_postdata(); ?>
	</div>
	</div>
</div>

<?php
}
graceful_nova_render_post_slider();