<?php
/**
 * Template part for Latest Posts below Header
 *
 * @package Graceful Nova
 */
?>

<section class="nova-posts-section">
  <div class="nova-posts-wrapper">
    <div class="nova-posts-grid">
      <?php
      $latest = new WP_Query([
        'posts_per_page' => 4,
        'post_status'    => 'publish',
      ]);

      if ( $latest->have_posts() ) :
        while ( $latest->have_posts() ) :
          $latest->the_post(); ?>
          
          <article <?php post_class('nova-posts-card'); ?>>
            <a class="nova-posts-thumb" href="<?php the_permalink(); ?>">
              <?php if ( has_post_thumbnail() ) :
                the_post_thumbnail('large', [
                  'loading'  => 'lazy',
                  'decoding' => 'async',
                ]);
              else : ?>
                <span class="nova-posts-thumb--placeholder"></span>
              <?php endif; ?>
            </a>

            <div class="nova-posts-kicker">
              <?php
                $cats = get_the_category();
                if ( ! empty( $cats ) ) {
                  $cat_names = array_map(
                    static fn( $c ) => $c->name,
                    $cats
                  );
                  echo esc_html( implode( esc_html__( ' · ', 'graceful-nova-blog' ), $cat_names ) );
                }
              ?>
            </div>

            <h2 class="nova-posts-title">
              <a href="<?php the_permalink(); ?>">
                <?php echo esc_html( get_the_title() ); ?>
              </a>
            </h2>
          </article>

        <?php endwhile;
        wp_reset_postdata();
      endif; ?>
    </div>
  </div>
</section>
