/*
** Nova Post Slider =====
*/
jQuery(document).ready(function($) {
	var $slider = $('.nova-slider-carousel');
	$slider.owlCarousel({
		items: 1,
		loop: true,
		autoplay: true,
		nav: false,
		dots: false,
		animateOut: 'fadeOut',
		animateIn: 'fadeIn',
	});

	$('.nova-prev').click(function() {
		$slider.trigger('prev.owl.carousel');
	});
	$('.nova-next').click(function() {
		$slider.trigger('next.owl.carousel');
	});
});

/*
** ColorThief =====
*/
document.addEventListener('DOMContentLoaded', function () {
	const colorThief = new ColorThief();

	document.querySelectorAll('.nova-slide').forEach(function (slide) {
		const img = slide.querySelector('.nova-slide-image');
		const left = slide.querySelector('.nova-slide-left');

		if (img && img.complete) {
			applyColor(img, left);
		} else if (img) {
			img.addEventListener('load', function () {
				applyColor(img, left);
			});
		}
	});

	function applyColor(img, target) {
		try {
			let [r, g, b] = colorThief.getColor(img);
			const brightness = (r * 299 + g * 587 + b * 114) / 1000;

			if (brightness < 160) {
				[r, g, b] = [r, g, b].map(c => Math.min(255, c + 80));
			}

			target.style.backgroundColor = `rgb(${r}, ${g}, ${b})`;
		} catch (e) {
			console.warn('Color extraction failed:', e);
		}
	}
});