<?php
/**
 * Luxe Posts Carousel
 *
 * Outputs an Owl Carousel slider of latest posts with Customizer controls. 
 *
 * @package Graceful Luxe Blog
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function graceful_luxe_display_latest_posts_slider() {
	$post_count   = get_theme_mod( 'luxe_slider_post_count', 5 );
	$show_date    = get_theme_mod( 'luxe_slider_show_date', true );
	$show_author  = get_theme_mod( 'luxe_slider_show_author', true );

	$args = array(
		'post_type'      => 'post',
		'posts_per_page' => absint( $post_count ),
		'post_status'    => 'publish',
	);

	$query = new WP_Query( $args );

	if ( ! $query->have_posts() ) {
		return;
	}
	?>
	<div class="luxe-latest-posts-slider">
		<div class="owl-carousel">
			<?php while ( $query->have_posts() ) : $query->the_post(); 
				$categories = get_the_category();
				$category   = ( ! empty( $categories ) ) ? $categories[0]->name : '';
				?>
				<div class="luxe-slider-item">
					<a href="<?php echo esc_url( get_permalink() ); ?>">
						<?php if ( has_post_thumbnail() ) : ?>
							<?php the_post_thumbnail( 'full', array( 'class' => 'luxe-slider-image' ) ); ?>
						<?php endif; ?>

						<span class="luxe-category-label"><?php echo esc_html( $category ); ?></span>

						<div class="luxe-slider-overlay">
							<h3 class="luxe-post-title"><?php echo esc_html( get_the_title() ); ?></h3>
							<div class="luxe-post-meta">
								<?php if ( $show_author ) : ?>
								    <span class="luxe-post-author">
								        <?php
								        echo sprintf(
								        	/* translators: %s: Post author name */
								            esc_html__( 'By %s', 'graceful-luxe-blog' ),
								            esc_html( get_the_author() )
								        );
								        ?>
								    </span>
								<?php endif; ?>


								<?php if ( $show_date ) : ?>
									<span class="luxe-post-date"><?php echo esc_html( get_the_date() ); ?></span>
								<?php endif; ?>
							</div>
						</div>
					</a>
				</div>
			<?php endwhile; ?>
		</div>
	</div>

	<?php
	wp_reset_postdata();
}

if ( get_theme_mod( 'luxe_slider_enable', true ) ) {
    graceful_luxe_display_latest_posts_slider();
}