<?php
/**
 * Template part for displaying Posts in One Column (featured + grid).
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Graceful Luxe Blog
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$graceful_category_tags_allowed = array(
    'a' => array(
        'href' => array(),
        'rel'  => array(),
    ),
    'div' => array(
        'class' => array(),
    ),
);
?>

<div class="content-wrap">

	<?php if ( is_search() ) : ?>
		<h1>
			<?php
			printf(
				/* translators: %s: search query */
				esc_html__( 'Search Results for: %s', 'graceful-luxe-blog' ),
				'<span>' . esc_html( get_search_query() ) . '</span>'
			);
			?>
		</h1>
	<?php endif; ?>

	<?php if ( is_category() ) : ?>
		<h1 class="graceful-luxe-category-title">
			<?php echo esc_html( single_cat_title( '', false ) ); ?>
		</h1>
	<?php endif; ?>

	<?php if ( have_posts() ) : ?>
		<div class="graceful-luxe-post-list">
			<?php while ( have_posts() ) : the_post(); ?>
				<article id="post-<?php the_ID(); ?>" <?php post_class( 'graceful-luxe-post-item' ); ?>>

					<a class="graceful-luxe-post-thumb"
					   href="<?php echo esc_url( get_permalink() ); ?>"
					   aria-label="<?php echo esc_attr( get_the_title() ); ?>">
						<?php
						if ( has_post_thumbnail() ) {
							the_post_thumbnail(
								'medium_large',
								array(
									'loading'  => 'lazy',
									'decoding' => 'async',
								)
							);
						} else {
							echo '<div class="graceful-luxe-thumb-placeholder"></div>';
						}
						?>
					</a>

					<?php if ( graceful_options( 'post_page_show_categories' ) ) : ?>
						<div class="graceful-luxe-post-categories">
							<?php
							$categories = get_the_category();
							if ( ! empty( $categories ) ) {
								foreach ( $categories as $category_item ) {
									$url  = get_category_link( $category_item->term_id );
									$name = $category_item->name;
									echo '<a href="' . esc_url( $url ) . '" class="graceful-luxe-category-label">' . esc_html( $name ) . '</a>';
								}
							}
							?>
						</div>
					<?php endif; ?>

					<header class="graceful-luxe-post-header">
						<h2 class="graceful-luxe-post-title">
							<a href="<?php echo esc_url( get_permalink() ); ?>">
								<?php echo esc_html( get_the_title() ); ?>
							</a>
						</h2>

						<div class="graceful-luxe-post-meta">
							<span class="graceful-luxe-post-date"><?php echo esc_html( get_the_date() ); ?></span>
							<span class="graceful-luxe-meta-sep">•</span>

							<?php if ( graceful_options( 'post_page_show_author' ) ) : ?>
								<span class="graceful-luxe-post-author">
									<?php
									/* translators: %s: post author HTML link */
									printf(
										/* translators: %s: author posts link with HTML */
										esc_html__( 'By %s', 'graceful-luxe-blog' ),
										wp_kses_post( get_the_author_posts_link() )
									);
									?>
								</span>
							<?php endif; ?>
						</div>
					</header>

				</article>
			<?php endwhile; ?>
		</div>

	<?php else : ?>
		<div class="no-result-found">
			<h3><?php esc_html_e( 'Nothing Found!', 'graceful-luxe-blog' ); ?></h3>
			<p><?php esc_html_e( 'Sorry, nothing matched your search terms. Please try different keywords.', 'graceful-luxe-blog' ); ?></p>
			<div class="graceful-widget widget_search">
				<?php get_search_form(); ?>
			</div>
		</div>
	<?php endif; ?>

	<?php get_template_part( 'template-parts/sections/site', 'pagination' ); ?>

</div><!-- content-wrap -->
