/**
 * Luxe Carousel JavaScript
 * 
 * Handles Owl Carousel initialization and configuration
 * 
 * Note: This script depends on jQuery and Owl Carousel being loaded by the parent theme.
 * 
 * @package Graceful Luxe Blog
 * @since 1.0.0
 */

jQuery(document).ready(function($) {
    $('.luxe-latest-posts-slider .owl-carousel').owlCarousel({
      center: true,
      items: 2,
      loop: true,
      autoplay: true,
      autoplayTimeout: 5000,
      margin: 10,
      dots: true,
      responsive: {
        0: {
          items: 1
        },
        768: {
          items: 2
        }
      }
    });
});