<?php
/**
 * Template part for displaying Posts in One Column
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Graceful
 */

$graceful_category_tags_allowed = array(
    'a' => array(
        'href' => array(),
        'rel' 		=> array()
    ),
    'div' => array(
        'class' => array()
    )
);
?>
<div class="content-wrap">
	<?php if ( is_search() ) : ?>
	<h1>
		<?php
		printf(
			/* translators: %s: search query */
			esc_html__( 'Search Results for: %s', 'graceful-halo-blog' ),
			'<span>' . esc_html( get_search_query() ) . '</span>'
		);
		?>
	</h1>
	<?php endif; ?>
	<ul class="content-column">
		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
			<li>
				<article id="post-<?php the_ID(); ?>" <?php post_class('content-post'); ?>>
					<div class="post-card">
						<div class="post-card-inner">
							<div class="site-images">
								<?php if ( has_post_thumbnail() ) { ?>
								<a href="<?php echo esc_url( get_permalink() ); ?>">
									<?php the_post_thumbnail('graceful-full-thumbnail'); ?>
								</a>
								<?php } ?>
							</div>

							<div class="post-content">
								<header class="post-header">
									
										<?php
										$graceful_category_list = get_the_category_list( '' );

										if ( graceful_options( 'post_page_show_categories' ) && $graceful_category_list ) :
											?>
											<div class="post-categories">
												<?php echo wp_kses( $graceful_category_list, $graceful_category_tags_allowed ); ?>
											</div>
										<?php endif; ?>

										<h2 class="post-title">
											<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
										</h2>
									
								</header>

								<?php if ( graceful_options( 'post_page_post_description' ) !== 'none' ) : ?>
									<div class="post-page-content">
										<?php
										if ( graceful_options( 'post_page_post_description' ) === 'content' ) {
											the_content('');
										} elseif ( graceful_options( 'post_page_post_description' ) === 'excerpt' ) {
											$excerpt_length = graceful_halo_blog_options( 'blog_grid_excerpt_length' );
												echo esc_html( graceful_excerpt( $excerpt_length ) );
										}
										?>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</article>
			</li>

		<?php endwhile; else: ?>
			<div class="no-result-found">
				<h3><?php esc_html_e( 'Nothing Found!', 'graceful-halo-blog' ); ?></h3>
				<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'graceful-halo-blog' ); ?></p>
				<div class="graceful-widget widget_search">
					<?php get_search_form(); ?>
				</div>
			</div>
		<?php endif; //have_posts ?>
	</ul>
	<?php get_template_part( 'template-parts/sections/site', 'pagination' ); ?>
</div><!-- content-wrap -->