<?php
/**
 * Graceful Glow Blog functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Graceful Glow Blog
 */

// ----------------------------------------------------------------------------------
//	Register Front-End Styles And Scripts
// ----------------------------------------------------------------------------------

function graceful_glow_blog_enqueue_child_styles() {
 
    wp_enqueue_style( 'graceful-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'graceful-glow-blog-style', get_stylesheet_directory_uri() . '/style.css', array( 'graceful-style' ), wp_get_theme()->get('Version') );
    
    // Enqueue Glow Slider styles
    wp_enqueue_style( 'glow-slider-style', get_stylesheet_directory_uri() . '/template-parts/sections/glow-slider/glow-slider.css', array(), wp_get_theme()->get('Version') );
    
    // Enqueue Glow Slider script (depends on jQuery and Owl Carousel from parent theme)
    wp_enqueue_script( 'glow-slider-script', get_stylesheet_directory_uri() . '/template-parts/sections/glow-slider/glow-slider.js', array( 'jquery' ), wp_get_theme()->get('Version'), true );
}
add_action( 'wp_enqueue_scripts', 'graceful_glow_blog_enqueue_child_styles' );



// ----------------------------------------------------------------------------------
//  Include Glow Slider
// ----------------------------------------------------------------------------------
require_once get_stylesheet_directory() . '/template-parts/sections/glow-slider/glow-slider.php';

// ----------------------------------------------------------------------------------
//  Include Featured Category
// ----------------------------------------------------------------------------------
require_once get_stylesheet_directory() . '/template-parts/sections/featured-category/featured-category.php';

// Load after Theme Setup
function graceful_glow_blog_theme_setup() {

    // ----------------------------------------------------------------------------------
    //  Customize Register for Top Navigation
    // ----------------------------------------------------------------------------------
    function graceful_glow_blog_customize_register( $wp_customize ) {

        $wp_customize->add_panel(
            'layout_settings',
            array(
                'priority'   => 20,
                'capability' => 'edit_theme_options',
                'title'      => __( 'Top Navigaion', 'graceful-glow-blog' ),
            )
        );

        /** Top Navigation */
        // add Top Navigation section
        $wp_customize->add_section( 'graceful_top_navigation' , array(
            'title'      => esc_html__( 'Top Navigation', 'graceful-glow-blog' ),
            'priority'   => 23,
            'capability' => 'edit_theme_options'
        ) );

        // Top Navigation
        $wp_customize->add_setting( 'graceful_glow_blog_options[top_navigation_show]', array(
            'default'    => graceful_glow_blog_options('top_navigation_show'),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_glow_blog_options[top_navigation_show]', array(
            'label'     => esc_html__( 'Enable Top Navigation', 'graceful-glow-blog' ),
            'section'   => 'graceful_top_navigation',
            'type'      => 'checkbox',
            'priority'  => 1
        ) );

        // Top Navigation Background Color
        $wp_customize->add_setting( 'graceful_glow_blog_options[top_navigation_bg]', array(
            'default'    => graceful_glow_blog_options('top_navigation_bg'),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color'
        ) );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'graceful_glow_blog_options[top_navigation_bg]', array(
            'label'     => esc_html__( 'Top Navigation Background Color', 'graceful-glow-blog' ),
            'section'   => 'graceful_top_navigation',
            'priority'  => 3
        ) ) );

        /** Featured Boxes */
        // Featured Boxes section
        $wp_customize->add_section( 'graceful_glow_blog_featured_boxes' , array(
            'title'      => esc_html__( 'Featured Boxes Section', 'graceful-glow-blog' ),
            'priority'   => 26,
            'capability' => 'edit_theme_options'
        ) );

        // Featured Boxes Enable
        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_show]', array(
            'default'    => graceful_glow_blog_options( 'featured_boxes_show' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_checkboxes'
        ) );
        $wp_customize->add_control( 'graceful_glow_blog_options[featured_boxes_show]', array(
            'label'     => esc_html__( 'Enable Featured Boxes', 'graceful-glow-blog' ),
            'section'   => 'graceful_glow_blog_featured_boxes',
            'type'      => 'checkbox',
            'priority'  => 1
        ) );

        // Featured Boxes 1
        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_title_1]', array(
            'default'    => graceful_glow_blog_options( 'featured_boxes_title_1' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_text_field'
        ) );
        $wp_customize->add_control( 'graceful_glow_blog_options[featured_boxes_title_1]', array(
            'label'     => esc_html__( 'Title 1', 'graceful-glow-blog' ),
            'section'   => 'graceful_glow_blog_featured_boxes',
            'type'      => 'text',
            'priority'  => 9
        ) );

        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_url_1]', array(
            'default'    => graceful_glow_blog_options( 'featured_boxes_url_1' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'esc_url_raw'
        ) );
        $wp_customize->add_control( 'graceful_glow_blog_options[featured_boxes_url_1]', array(
            'label'     => esc_html__( 'URL 1', 'graceful-glow-blog' ),
            'section'   => 'graceful_glow_blog_featured_boxes',
            'type'      => 'text',
            'priority'  => 11
        ) );

        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_image_1]', array(
            'default'   => '',
            'type'      => 'option',
            'transport' => 'refresh',
            'sanitize_callback' => 'graceful_sanitize_number_absint'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_glow_blog_options[featured_boxes_image_1]', array(
                'label'         => esc_html__( 'Image 1', 'graceful-glow-blog' ),
                'section'       => 'graceful_glow_blog_featured_boxes',
                'flex_width'    => false,
                'flex_height'   => false,
                'width'         => 600,
                'height'        => 340,
                'priority'      => 13
            )
        ) );

        // Featured Boxes 2
        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_title_2]', array(
            'default'    => graceful_glow_blog_options( 'featured_boxes_title_2' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_text_field'
        ) );
        $wp_customize->add_control( 'graceful_glow_blog_options[featured_boxes_title_2]', array(
            'label'     => esc_html__( 'Title 2', 'graceful-glow-blog' ),
            'section'   => 'graceful_glow_blog_featured_boxes',
            'type'      => 'text',
            'priority'  => 15
        ) );

        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_url_2]', array(
            'default'    => graceful_glow_blog_options( 'featured_boxes_url_2' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'esc_url_raw'
        ) );
        $wp_customize->add_control( 'graceful_glow_blog_options[featured_boxes_url_2]', array(
            'label'     => esc_html__( 'URL 2', 'graceful-glow-blog' ),
            'section'   => 'graceful_glow_blog_featured_boxes',
            'type'      => 'text',
            'priority'  => 17
        ) );

        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_image_2]', array(
            'default'   => '',
            'type'      => 'option',
            'transport' => 'refresh',
            'sanitize_callback' => 'graceful_sanitize_number_absint'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_glow_blog_options[featured_boxes_image_2]', array(
                'label'         => esc_html__( 'Image 2', 'graceful-glow-blog' ),
                'section'       => 'graceful_glow_blog_featured_boxes',
                'flex_width'    => false,
                'flex_height'   => false,
                'width'         => 600,
                'height'        => 340,
                'priority'      => 19
            )
        ) );

        // Featured Boxes 3
        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_title_3]', array(
            'default'    => graceful_glow_blog_options( 'featured_boxes_title_3' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_text_field'
        ) );
        $wp_customize->add_control( 'graceful_glow_blog_options[featured_boxes_title_3]', array(
            'label'     => esc_html__( 'Title 3', 'graceful-glow-blog' ),
            'section'   => 'graceful_glow_blog_featured_boxes',
            'type'      => 'text',
            'priority'  => 21
        ) );

        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_url_3]', array(
            'default'    => graceful_glow_blog_options( 'featured_boxes_url_3' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'esc_url_raw'
        ) );
        $wp_customize->add_control( 'graceful_glow_blog_options[featured_boxes_url_3]', array(
            'label'     => esc_html__( 'URL 3', 'graceful-glow-blog' ),
            'section'   => 'graceful_glow_blog_featured_boxes',
            'type'      => 'text',
            'priority'  => 23
        ) );

        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_image_3]', array(
            'default'   => '',
            'type'      => 'option',
            'transport' => 'refresh',
            'sanitize_callback' => 'graceful_sanitize_number_absint'
        ) );
        $wp_customize->add_control(
            new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_glow_blog_options[featured_boxes_image_3]', array(
                'label'         => esc_html__( 'Image 3', 'graceful-glow-blog' ),
                'section'       => 'graceful_glow_blog_featured_boxes',
                'flex_width'    => false,
                'flex_height'   => false,
                'width'         => 600,
                'height'        => 340,
                'priority'      => 25
            )
        ) );

        // Featured Boxes Layout Width
        $boxed_width_featured_boxes = array(
            'full' => esc_html__( 'Full', 'graceful-glow-blog' ),
            'wrapped' => esc_html__( 'Boxed', 'graceful-glow-blog' ),
        );

        $wp_customize->add_setting( 'graceful_glow_blog_options[featured_boxes_width]', array(
            'default'    => graceful_glow_blog_options( 'featured_boxes_width' ),
            'type'       => 'option',
            'transport'  => 'refresh',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'graceful_sanitize_select'
        ) );
        $wp_customize->add_control( 'graceful_glow_blog_options[featured_boxes_width]', array(
            'label'         => esc_html__( 'Featured Boxes Width', 'graceful-glow-blog' ),
            'section'       => 'graceful_basic',
            'type'          => 'select',
            'choices'       => $boxed_width_featured_boxes,
            'priority'      => 28
        ) );

        // Sanitize number absint
        function graceful_sanitize_number_absint( $number, $setting ) {

            // ensure $number is an absolute integer
            $number = absint( $number );

            // return default if not integer
            return ( $number ? $number : $setting->default );

        }

        // ----------------------------------------------------------------------------------
        //  Glow Slider Settings
        // ----------------------------------------------------------------------------------
        $wp_customize->add_section( 'glow_slider_settings', array(
            'title'      => esc_html__( 'Glow Slider', 'graceful-glow-blog' ),
            'priority'   => 23,
            'capability' => 'edit_theme_options',
        ) );

        // Enable Glow Slider
        $wp_customize->add_setting( 'glow_slider_enabled', array(
            'default'           => true,
            'sanitize_callback' => 'wp_validate_boolean',
        ) );
        $wp_customize->add_control( 'glow_slider_enabled', array(
            'label'    => esc_html__( 'Enable Glow Slider', 'graceful-glow-blog' ),
            'section'  => 'glow_slider_settings',
            'type'     => 'checkbox',
            'priority' => 1,
        ) );

        // Number of posts
        $wp_customize->add_setting( 'glow_slider_post_count', array(
            'default'           => 3,
            'sanitize_callback' => 'absint',
        ) );
        $wp_customize->add_control( 'glow_slider_post_count', array(
            'label'       => esc_html__( 'Number of Posts', 'graceful-glow-blog' ),
            'description' => esc_html__( 'Number of posts to display in slider (1-5)', 'graceful-glow-blog' ),
            'section'     => 'glow_slider_settings',
            'type'        => 'number',
            'priority'    => 2,
            'input_attrs' => array(
                'min'  => 1,
                'max'  => 5,
                'step' => 1,
            ),
        ) );

        // Show Category
        $wp_customize->add_setting( 'glow_slider_show_category', array(
            'default'           => true,
            'sanitize_callback' => 'wp_validate_boolean',
        ) );
        $wp_customize->add_control( 'glow_slider_show_category', array(
            'label'    => esc_html__( 'Show Category Badge', 'graceful-glow-blog' ),
            'section'  => 'glow_slider_settings',
            'type'     => 'checkbox',
            'priority' => 3,
        ) );

        // Show Reading Time
        $wp_customize->add_setting( 'glow_slider_show_reading_time', array(
            'default'           => true,
            'sanitize_callback' => 'wp_validate_boolean',
        ) );
        $wp_customize->add_control( 'glow_slider_show_reading_time', array(
            'label'    => esc_html__( 'Show Reading Time', 'graceful-glow-blog' ),
            'section'  => 'glow_slider_settings',
            'type'     => 'checkbox',
            'priority' => 4,
        ) );

        // Show Read More Button
        $wp_customize->add_setting( 'glow_slider_show_button', array(
            'default'           => true,
            'sanitize_callback' => 'wp_validate_boolean',
        ) );
        $wp_customize->add_control( 'glow_slider_show_button', array(
            'label'    => esc_html__( 'Show Read More Button', 'graceful-glow-blog' ),
            'section'  => 'glow_slider_settings',
            'type'     => 'checkbox',
            'priority' => 5,
        ) );

        // Button Text
        $wp_customize->add_setting( 'glow_slider_button_text', array(
            'default'           => esc_html__( 'Read More', 'graceful-glow-blog' ),
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control( 'glow_slider_button_text', array(
            'label'    => esc_html__( 'Button Text', 'graceful-glow-blog' ),
            'section'  => 'glow_slider_settings',
            'type'     => 'text',
            'priority' => 6,
        ) );

        // Show Navigation Arrows
        $wp_customize->add_setting( 'glow_slider_show_arrows', array(
            'default'           => true,
            'sanitize_callback' => 'wp_validate_boolean',
        ) );
        $wp_customize->add_control( 'glow_slider_show_arrows', array(
            'label'    => esc_html__( 'Show Navigation Arrows', 'graceful-glow-blog' ),
            'section'  => 'glow_slider_settings',
            'type'     => 'checkbox',
            'priority' => 7,
        ) );

        // Show Dots Navigation
        $wp_customize->add_setting( 'glow_slider_show_dots', array(
            'default'           => true,
            'sanitize_callback' => 'wp_validate_boolean',
        ) );
        $wp_customize->add_control( 'glow_slider_show_dots', array(
            'label'    => esc_html__( 'Show Dots Navigation', 'graceful-glow-blog' ),
            'section'  => 'glow_slider_settings',
            'type'     => 'checkbox',
            'priority' => 8,
        ) );

        // Background Color
        $wp_customize->add_setting( 'glow_slider_background_color', array(
            'default'           => '#e5ded0',
            'sanitize_callback' => 'sanitize_hex_color',
        ) );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'glow_slider_background_color', array(
            'label'    => esc_html__( 'Background Color', 'graceful-glow-blog' ),
            'section'  => 'glow_slider_settings',
            'priority' => 9,
        ) ) );

        // ----------------------------------------------------------------------------------
        //  Featured Category Settings
        // ----------------------------------------------------------------------------------
        $wp_customize->add_section( 'featured_category_settings', array(
            'title'      => esc_html__( 'Featured Category Section', 'graceful-glow-blog' ),
            'priority'   => 27,
            'capability' => 'edit_theme_options',
        ) );

        // Enable Featured Category
        $wp_customize->add_setting( 'featured_category_enabled', array(
            'default'           => false,
            'sanitize_callback' => 'wp_validate_boolean',
        ) );
        $wp_customize->add_control( 'featured_category_enabled', array(
            'label'    => esc_html__( 'Enable Featured Category', 'graceful-glow-blog' ),
            'section'  => 'featured_category_settings',
            'type'     => 'checkbox',
            'priority' => 1,
        ) );

        // Section Title
        $wp_customize->add_setting( 'featured_category_title', array(
            'default'           => esc_html__( 'Featured Posts', 'graceful-glow-blog' ),
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control( 'featured_category_title', array(
            'label'    => esc_html__( 'Section Title', 'graceful-glow-blog' ),
            'section'  => 'featured_category_settings',
            'type'     => 'text',
            'priority' => 2,
        ) );

        // Select Category
        $categories = get_categories( array( 'hide_empty' => false ) );
        $category_choices = array( 0 => esc_html__( '-- Select Category --', 'graceful-glow-blog' ) );
        foreach ( $categories as $category ) {
            $category_choices[ $category->term_id ] = $category->name;
        }

        $wp_customize->add_setting( 'featured_category_select', array(
            'default'           => 0,
            'sanitize_callback' => 'absint',
        ) );
        $wp_customize->add_control( 'featured_category_select', array(
            'label'    => esc_html__( 'Select Category', 'graceful-glow-blog' ),
            'description' => esc_html__( 'Choose a category to display 3 latest posts with images. Tip: To feature specific posts, create a category like "Featured" and assign your chosen posts to it.', 'graceful-glow-blog' ),
            'section'  => 'featured_category_settings',
            'type'     => 'select',
            'choices'  => $category_choices,
            'priority' => 3,
        ) );

        // Badge Color
        $wp_customize->add_setting( 'featured_category_badge_color', array(
            'default'           => '#f59e0b',
            'sanitize_callback' => 'sanitize_hex_color',
        ) );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'featured_category_badge_color', array(
            'label'    => esc_html__( 'Category Badge Color', 'graceful-glow-blog' ),
            'section'  => 'featured_category_settings',
            'priority' => 4,
        ) ) );

    }
    add_action( 'customize_register', 'graceful_glow_blog_customize_register', 99 );


    register_nav_menus(
        array(
            'top'  => esc_html__( 'Top Menu', 'graceful-glow-blog' ),
        )
    );

    function graceful_top_menu_fallback() {
        if ( current_user_can( 'edit_theme_options' ) ) {
            ?>
            <ul id="top-menu">
                <li>
                    <a href="<?php echo esc_url( home_url( '/wp-admin/nav-menus.php') ) ?>">
                        <?php esc_html_e( 'Set-up Top Menu', 'graceful-glow-blog' ) ?>
                    </a>
                </li>
            </ul>
            <?php
        }
    }

    function graceful_glow_blog_options( $controls ) {

        $graceful_glow_blog_defaults = array(
            'top_navigation_show' => true,
            'top_navigation_bg' => '#e5ded0',
            'blog_grid_excerpt_length' => '50',
            // Featured Boxes Defaults
            'featured_boxes_show' => false,
            'featured_boxes_window' => true,
            'featured_boxes_width' => 'wrapped',
            'featured_boxes_title_1' => '',
            'featured_boxes_url_1' => '',
            'featured_boxes_image_1' => '',
            'featured_boxes_title_2' => '',
            'featured_boxes_url_2' => '',
            'featured_boxes_image_2' => '',
            'featured_boxes_title_3' => '',
            'featured_boxes_url_3' => '',
            'featured_boxes_image_3' => '',
        );

        // merge defaults and options
        $graceful_glow_blog_defaults = wp_parse_args( get_option( 'graceful_glow_blog_options' ), $graceful_glow_blog_defaults );

        // return control
        return $graceful_glow_blog_defaults[ $controls ];

    }

}
add_action( 'after_setup_theme', 'graceful_glow_blog_theme_setup' );

// ----------------------------------------------------------------------------------
//  New Fonts
// ----------------------------------------------------------------------------------
function graceful_glow_blog_enqueue_assets()
{
    // Include the file.
    require_once get_theme_file_path('webfont-loader/wptt-webfont-loader.php');
    // Load the webfont.
    wp_enqueue_style(
        'minimalist-stories-fonts',
        wptt_get_webfont_url('https://fonts.googleapis.com/css2?family=Lato:wght@400;700&display=auto'),
        array(),
        '1.0'
    );
}
add_action('wp_enqueue_scripts', 'graceful_glow_blog_enqueue_assets');


// ----------------------------------------------------------------------------------
//  New Thumbnail Size
// ----------------------------------------------------------------------------------
if ( function_exists( 'add_image_size' ) ) {
    // new column thumbnail size
    add_image_size( 'graceful-post-column-thumbnail', 364, 242, true );
}
