<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package GovPress
 */
?>

<?php if ( get_theme_mod( 'theme_layout', 'sidebar-right' ) != 'single-column' ) : ?>

	<div id="secondary" class="widget-area" role="complementary">
		<?php do_action( 'before_sidebar' ); ?>
		<?php if ( ! dynamic_sidebar( 'primary' ) ) : ?>

			<aside id="search" class="widget widget_search">
				<h1 class="widget-title"><?php _e( 'Search', 'govpress' ); ?></h1>
				<?php get_search_form(); ?>
			</aside>

			<aside id="archives" class="widget">
				<h1 class="widget-title"><?php _e( 'Archives', 'govpress' ); ?></h1>
				<ul>
					<?php wp_get_archives( array( 'type' => 'monthly' ) ); ?>
				</ul>
			</aside>

			<aside id="meta" class="widget">
				<h1 class="widget-title"><?php _e( 'Meta', 'govpress' ); ?></h1>
				<ul>
					<?php wp_register(); ?>
					<li><?php wp_loginout(); ?></li>
					<?php wp_meta(); ?>
				</ul>
			</aside>

		<?php endif; // end sidebar widget area ?>
	</div><!-- #secondary -->

<?php endif; ?>