<?php
/**
 * Builds our admin page.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'goshiki_create_menu' ) ) {
	add_action( 'admin_menu', 'goshiki_create_menu' );
	/**
	 * Adds our "Goshiki" dashboard menu item
	 *
	 */
	function goshiki_create_menu() {
		$goshiki_page = add_theme_page( 'Goshiki', 'Goshiki', apply_filters( 'goshiki_dashboard_page_capability', 'edit_theme_options' ), 'goshiki-options', 'goshiki_settings_page' );
		add_action( "admin_print_styles-$goshiki_page", 'goshiki_options_styles' );
	}
}

if ( ! function_exists( 'goshiki_options_styles' ) ) {
	/**
	 * Adds any necessary scripts to the Goshiki dashboard page
	 *
	 */
	function goshiki_options_styles() {
		wp_enqueue_style( 'goshiki-options', get_template_directory_uri() . '/css/admin/admin-style.css', array(), GOSHIKI_VERSION );
	}
}

if ( ! function_exists( 'goshiki_settings_page' ) ) {
	/**
	 * Builds the content of our Goshiki dashboard page
	 *
	 */
	function goshiki_settings_page() {
		?>
		<div class="wrap">
			<div class="metabox-holder">
				<div class="goshiki-masthead clearfix">
					<div class="goshiki-container">
						<div class="goshiki-title">
							<a href="<?php echo esc_url(GOSHIKI_THEME_URL); ?>" target="_blank"><?php esc_html_e( 'Goshiki', 'goshiki' ); ?></a> <span class="goshiki-version"><?php echo GOSHIKI_VERSION; ?></span>
						</div>
						<div class="goshiki-masthead-links">
							<?php if ( ! defined( 'GOSHIKI_PREMIUM_VERSION' ) ) : ?>
								<a class="goshiki-masthead-links-bold" href="<?php echo esc_url(GOSHIKI_THEME_URL); ?>" target="_blank"><?php esc_html_e( 'Premium', 'goshiki' );?></a>
							<?php endif; ?>
							<a href="<?php echo esc_url(GOSHIKI_WPKOI_AUTHOR_URL); ?>" target="_blank"><?php esc_html_e( 'WPKoi', 'goshiki' ); ?></a>
                            <a href="<?php echo esc_url(GOSHIKI_DOCUMENTATION); ?>" target="_blank"><?php esc_html_e( 'Documentation', 'goshiki' ); ?></a>
						</div>
					</div>
				</div>

				<?php
				/**
				 * goshiki_dashboard_after_header hook.
				 *
				 */
				 do_action( 'goshiki_dashboard_after_header' );
				 ?>

				<div class="goshiki-container">
					<div class="postbox-container clearfix" style="float: none;">
						<div class="grid-container grid-parent">

							<?php
							/**
							 * goshiki_dashboard_inside_container hook.
							 *
							 */
							 do_action( 'goshiki_dashboard_inside_container' );
							 ?>

							<div class="form-metabox grid-70" style="padding-left: 0;">
								<h2 style="height:0;margin:0;"><!-- admin notices below this element --></h2>
								<form method="post" action="options.php">
									<?php settings_fields( 'goshiki-settings-group' ); ?>
									<?php do_settings_sections( 'goshiki-settings-group' ); ?>
									<div class="customize-button hide-on-desktop">
										<?php
										printf( '<a id="goshiki_customize_button" class="button button-primary" href="%1$s">%2$s</a>',
											esc_url( admin_url( 'customize.php' ) ),
											esc_html__( 'Customize', 'goshiki' )
										);
										?>
									</div>

									<?php
									/**
									 * goshiki_inside_options_form hook.
									 *
									 */
									 do_action( 'goshiki_inside_options_form' );
									 ?>
								</form>

								<?php
								$modules = array(
									'Backgrounds' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Blog' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Colors' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Disable Elements' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Demo Import' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Hooks' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Import / Export' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Menu Plus' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Page Header' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Secondary Nav' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Spacing' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Typography' => array(
											'url' => GOSHIKI_THEME_URL,
									),
									'Elementor Addon' => array(
											'url' => GOSHIKI_THEME_URL,
									)
								);

								if ( ! defined( 'GOSHIKI_PREMIUM_VERSION' ) ) : ?>
									<div class="postbox goshiki-metabox">
										<h3 class="hndle"><?php esc_html_e( 'Premium Modules', 'goshiki' ); ?></h3>
										<div class="inside" style="margin:0;padding:0;">
											<div class="premium-addons">
												<?php foreach( $modules as $module => $info ) { ?>
												<div class="add-on activated goshiki-clear addon-container grid-parent">
													<div class="addon-name column-addon-name" style="">
														<a href="<?php echo esc_url( $info[ 'url' ] ); ?>" target="_blank"><?php echo esc_html( $module ); ?></a>
													</div>
													<div class="addon-action addon-addon-action" style="text-align:right;">
														<a href="<?php echo esc_url( $info[ 'url' ] ); ?>" target="_blank"><?php esc_html_e( 'Learn more', 'goshiki' ); ?></a>
													</div>
												</div>
												<div class="goshiki-clear"></div>
												<?php } ?>
											</div>
										</div>
									</div>
								<?php
								endif;

								/**
								 * goshiki_options_items hook.
								 *
								 */
								do_action( 'goshiki_options_items' );
								?>
							</div>

							<div class="goshiki-right-sidebar grid-30" style="padding-right: 0;">
								<div class="customize-button hide-on-mobile">
									<?php
									printf( '<a id="goshiki_customize_button" class="button button-primary" href="%1$s">%2$s</a>',
										esc_url( admin_url( 'customize.php' ) ),
										esc_html__( 'Customize', 'goshiki' )
									);
									?>
								</div>

								<?php
								/**
								 * goshiki_admin_right_panel hook.
								 *
								 */
								 do_action( 'goshiki_admin_right_panel' );

								  ?>
                                
                                <div class="wpkoi-doc">
                                	<h3><?php esc_html_e( 'Goshiki documentation', 'goshiki' ); ?></h3>
                                	<p><?php esc_html_e( 'If You`ve stuck, the documentation may help on WPKoi.com', 'goshiki' ); ?></p>
                                    <a href="<?php echo esc_url(GOSHIKI_DOCUMENTATION); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Goshiki documentation', 'goshiki' ); ?></a>
                                </div>
                                
                                <div class="wpkoi-social">
                                	<h3><?php esc_html_e( 'WPKoi on Facebook', 'goshiki' ); ?></h3>
                                	<p><?php esc_html_e( 'If You want to get useful info about WordPress and the theme, follow WPKoi on Facebook.', 'goshiki' ); ?></p>
                                    <a href="<?php echo esc_url(GOSHIKI_WPKOI_SOCIAL_URL); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Go to Facebook', 'goshiki' ); ?></a>
                                </div>
                                
                                <div class="wpkoi-review">
                                	<h3><?php esc_html_e( 'Help with You review', 'goshiki' ); ?></h3>
                                	<p><?php esc_html_e( 'If You like Goshiki theme, show it to the world with Your review. Your feedback helps a lot.', 'goshiki' ); ?></p>
                                    <a href="<?php echo esc_url(GOSHIKI_WORDPRESS_REVIEW); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Add my review', 'goshiki' ); ?></a>
                                </div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'goshiki_admin_errors' ) ) {
	add_action( 'admin_notices', 'goshiki_admin_errors' );
	/**
	 * Add our admin notices
	 *
	 */
	function goshiki_admin_errors() {
		$screen = get_current_screen();

		if ( 'appearance_page_goshiki-options' !== $screen->base ) {
			return;
		}

		if ( isset( $_GET['settings-updated'] ) && 'true' == $_GET['settings-updated'] ) {
			 add_settings_error( 'goshiki-notices', 'true', esc_html__( 'Settings saved.', 'goshiki' ), 'updated' );
		}

		if ( isset( $_GET['status'] ) && 'imported' == $_GET['status'] ) {
			 add_settings_error( 'goshiki-notices', 'imported', esc_html__( 'Import successful.', 'goshiki' ), 'updated' );
		}

		if ( isset( $_GET['status'] ) && 'reset' == $_GET['status'] ) {
			 add_settings_error( 'goshiki-notices', 'reset', esc_html__( 'Settings removed.', 'goshiki' ), 'updated' );
		}

		settings_errors( 'goshiki-notices' );
	}
}
