<?php
/**
 * The template for displaying single posts.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php goshiki_article_schema( 'CreativeWork' ); ?>>
	<div class="inside-article">
		<?php
		/**
		 * goshiki_before_content hook.
		 *
		 *
		 * @hooked goshiki_featured_page_header_inside_single - 10
		 */
		do_action( 'goshiki_before_content' );
		?>

		<header class="entry-header">
			<?php
			/**
			 * goshiki_before_entry_title hook.
			 *
			 */
			do_action( 'goshiki_before_entry_title' );

			if ( goshiki_show_title() ) {
				the_title( '<h1 class="entry-title" itemprop="headline">', '</h1>' );
			}

			/**
			 * goshiki_after_entry_title hook.
			 *
			 *
			 * @hooked goshiki_post_meta - 10
			 */
			do_action( 'goshiki_after_entry_title' );
			?>
		</header><!-- .entry-header -->

		<?php
		/**
		 * goshiki_after_entry_header hook.
		 *
		 *
		 * @hooked goshiki_post_image - 10
		 */
		do_action( 'goshiki_after_entry_header' );
		?>

		<div class="entry-content" itemprop="text">
			<?php
			the_content();

			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'goshiki' ),
				'after'  => '</div>',
			) );
			?>
		</div><!-- .entry-content -->

		<?php
		/**
		 * goshiki_after_entry_content hook.
		 *
		 *
		 * @hooked goshiki_footer_meta - 10
		 */
		do_action( 'goshiki_after_entry_content' );

		/**
		 * goshiki_after_content hook.
		 *
		 */
		do_action( 'goshiki_after_content' );
		?>
	</div><!-- .inside-article -->
</article><!-- #post-## -->
