<?php
add_action("init","goldy_soler_hook",12);
function goldy_soler_hook(){
                             
	remove_action('goldy_our_portfolio_loop', 'goldy_mex_our_portfolio_loop', 5);

	add_action('goldy_our_portfolio_loop', 'goldy_soler_our_portfolio_loop', 5);
	function goldy_soler_our_portfolio_loop($info_item) {
	?>
		<div class="portfolio-item-wrapper">
			<div class="portfolio-item">
				<div class="portfolio-image-wrapper">
					<?php if (!empty($info_item['image'])) { ?>
						<img src="<?php echo esc_url($info_item['image']); ?>" alt="<?php echo esc_attr($info_item['title']); ?>" class="portfolio-image">
					<?php } else { ?>
						<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/no-thumb.jpg" alt="No Thumbnail" class="portfolio-image"> 
					<?php } ?>
				</div>
				<div class="portfolio-content">
					<h3 class="portfolio-title"><?php echo esc_html($info_item['title']); ?></h3>
					<div class="portfolio-description">
						<p><?php echo wp_kses_post($info_item['text']); ?></p>
					</div>
					<?php if (!empty($info_item['link_url'])) { ?>
						<div class="portfolio-button">
							<a href="<?php echo esc_url($info_item['link_url']); ?>" class="portfolio-read-more">
								<?php _e('Read More', 'goldy-soler'); ?> <i class="fa fa-arrow-right"></i>
							</a>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	<?php
	}
			


// Remove old testimonial loop
remove_action('goldy_our_testimonial_loop', 'goldy_mex_our_testimonial_loop', 5);

// Add new testimonial loop
add_action('goldy_our_testimonial_loop', 'goldy_prime_our_testimonial_loop', 5);

function goldy_prime_our_testimonial_loop($info_item) {
?>
    <div class="testimonial-card">
        <div class="testimonial-content">
            <div class="testimonial-text">
                <p><?php echo wp_kses_post($info_item['text']); ?></p>
            </div>
            <div class="testimonial-author">
                <div class="author-info">
                    <div class="author-image">
                        <?php if (!empty($info_item['image'])): ?>
                            <img src="<?php echo esc_url($info_item['image']); ?>" alt="Testimonial Image">
                        <?php else: ?>
                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/no-thumb.jpg" alt="Default Image">
                        <?php endif; ?>
                    </div>
                    <div class="author-details">
                        <h3><?php echo esc_html($info_item['title']); ?></h3>
                        <h4><?php echo esc_attr($info_item['subtitle']); ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="testimonial-quote">
            <i class="fa fa-quote-left"></i>
        </div>
    </div>
<?php
}

}