<?php
/**
 * goldy-mining functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package goldy-mining
 */

if ( ! defined( '_GOLDY_MINING_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_GOLDY_MINING_VERSION', '1.0.3' );
}

if ( ! function_exists( 'goldy_mining_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function goldy_mining_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on goldy-mining, use a find and replace
		 * to change 'goldy-mining' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'goldy-mining', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'goldy_mining_menu-1' => esc_html__( 'Primary', 'goldy-mining' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'goldy_mining_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'goldy_mining_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $goldy_mining_content_width
 */
function goldy_mining_content_width() {
	$GLOBALS['goldy_mining_content_width'] = apply_filters( 'goldy_mining_content_width', 640 );
}
add_action( 'after_setup_theme', 'goldy_mining_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function goldy_mining_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'goldy-mining' ),
			'id'            => 'goldy_mining_sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-mining' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer1', 'goldy-mining' ),
			'id'            => 'goldy_mining_footer1',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-mining' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer2', 'goldy-mining' ),
			'id'            => 'goldy_mining_footer2',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-mining' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer3', 'goldy-mining' ),
			'id'            => 'goldy_mining_footer3',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-mining' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer4', 'goldy-mining' ),
			'id'            => 'goldy_mining_footer4',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-mining' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer5', 'goldy-mining' ),
			'id'            => 'goldy_mining_footer5',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-mining' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'goldy_mining_widgets_init' );


function goldy_mining_wpdocs_setup_theme() {
    add_theme_support( 'post-thumbnails' );
    set_post_thumbnail_size( 600, 350, true );
}
add_action( 'after_setup_theme', 'goldy_mining_wpdocs_setup_theme' );



// Add custom meta box
add_action("add_meta_boxes", "goldy_mining_add_sidebar_meta_box");
function goldy_mining_add_sidebar_meta_box()
{
	$post_types = get_post_type();
    add_meta_box("goldy-mining-meta-box", "Custom Meta Box","goldy_mining_sidebar_meta_box_markup", $post_types, "normal", "high", null);
}
function goldy_mining_sidebar_meta_box_markup($object){
	?>
	<table class="admin_sidebar_select">
		<tr><td><label><h2 class="custom_meta"><?php echo esc_html__( 'Breadcrumb', 'goldy-mining' );?></h2></label></td></tr>
	   	<tr>
	   		<td>
	   			<label for="goldy_mining_breadcrumb_select">
	   				<input type="radio" name="goldy_mining_breadcrumb_select" id="goldy_mining_breadcrumb_select" value="yes" <?php if(get_post_meta($object->ID,'goldy_mining_breadcrumb_select',true)=='yes'){echo "checked";}?>><?php echo esc_html__( 'Yes', 'goldy-mining' );?> 
	   				<input type="radio" name="goldy_mining_breadcrumb_select" id="goldy_mining_breadcrumb_select" value="no" <?php if(get_post_meta($object->ID,'goldy_mining_breadcrumb_select',true)=='no'){echo "checked";}?>><?php echo esc_html__( 'No', 'goldy-mining' );?>
	   			</label>
	   		</td>
	   	</tr>
	   	<tr><td><label><h2 class="custom_meta">Sidebar</h2></label></td></tr>
   		<tr>
	   		<td>
	   			<label for="no_sidebar">		   				
	   				<input type="radio" name="sidebar_select" id="no_sidebar" class="no_sidebar" value="no_sidebar" <?php if(get_post_meta($object->ID,'sidebar_select',true)=='no_sidebar'){echo "checked";}?>>
		   				<img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/images/full.png' ?>">
		   			</input>
	   			</label>
	   			<label for="left_sidebar">
	   				<input type="radio" name="sidebar_select" id="left_sidebar" class="left_sidebar" value="left_sidebar" <?php if(get_post_meta($object->ID,'sidebar_select',true)=='left_sidebar'){echo "checked";}?>>
	   					<img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/images/left.png' ?>">
	   				</input>
	   			</label>
	   			<label for="right_sidebar">			   				
	   				<input type="radio" name="sidebar_select" id="right_sidebar" class="right_sidebar" value="right_sidebar" <?php if(get_post_meta($object->ID,'sidebar_select',true)=='right_sidebar'){echo "checked";}?>>
	   					<img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/images/right.png' ?>">
	   				</input>
	   			</label>			
	   		</td>
	   	</tr>
	</table>
	<?php
}
add_action( 'save_post','goldy_mining_save_sidebar_meta_box_data');
function goldy_mining_save_sidebar_meta_box_data( $post_id ) {
	if(isset($_REQUEST['goldy_mining_breadcrumb_select'])){
		$goldy_mining_breadcrumb_select = sanitize_text_field( wp_unslash($_REQUEST['goldy_mining_breadcrumb_select'] ));
		update_post_meta($post_id,'goldy_mining_breadcrumb_select',$goldy_mining_breadcrumb_select);
	}
	if(isset($_REQUEST['sidebar_select'])){
		$sidebar_select = sanitize_text_field( wp_unslash($_REQUEST['sidebar_select'] ));
		update_post_meta($post_id,'sidebar_select',$sidebar_select);
	}
}

function goldy_mining_breadcrumb_slider(){
	?>
	<div class="breadcrumb_info">
		<div class="breadcrumb_data">
			<section id="breadcrumb-section" class="breadcrumb-area breadcrumb-centerc">
				<div class="breadcrumb-content">
					<div class="breadcrumb-heading">
						<h1><?php  goldy_mining_breadcrumb_title();	?></h1>
					</div>
					<ol class="breadcrumb-list">
						<li>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html__( 'Home', 'goldy-mining' );?></a>
							<?php echo "&nbsp;&nbsp;&#187;&nbsp;&nbsp;"; ?>
						</li>
						<li>
							<?php goldy_mining_breadcrumb_title();?>
						</li>
					</ol>
				</div> 
			</section>
		</div>		
	</div>
	<?php
}
/**
 * Enqueue scripts and styles.
 */
function goldy_mining_scripts() {
	wp_enqueue_script('jquery', false, array(), false, false);
	wp_enqueue_style( 'goldy-mining-style', get_stylesheet_uri(), array(), _GOLDY_MINING_VERSION );
	wp_style_add_data( 'goldy-mining-style', 'rtl', 'replace' );

	wp_enqueue_script( 'goldy-mining-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array(), _GOLDY_MINING_VERSION, true );
		wp_localize_script( 'goldy-mining-navigation', 'aboutdata', 
				array(
					'about_sec' => esc_attr(get_theme_mod('goldy_mining_diseble')),
				)
     	);
	wp_enqueue_script( 'goldy-mining-owl_slider', get_template_directory_uri() . '/assets/js/owl_slider.js', array(), _GOLDY_MINING_VERSION, true );	
	wp_enqueue_script( 'goldy-mining-owl-carousel-min', get_template_directory_uri() . '/assets/js/owl.carousel.js', array(), _GOLDY_MINING_VERSION, true );	
	wp_enqueue_style( 'goldy-mining-theme-css', esc_url(get_template_directory_uri()).'/assets/css/theme.css' , array(), _GOLDY_MINING_VERSION );
	wp_enqueue_style( 'goldy-mining-fontawesome-css', esc_url(get_template_directory_uri()).'/assets/fontawesome/css/font-awesome.css' , array(), _GOLDY_MINING_VERSION );
	wp_enqueue_style( 'goldy-mining-owl-carousel-min-css', esc_url(get_template_directory_uri()).'/assets/css/owl.carousel.min.css' , array(), _GOLDY_MINING_VERSION );
	wp_enqueue_style( 'goldy-mining-owl-carousel_theme-min-css', esc_url(get_template_directory_uri()).'/assets/css/owl.theme.min.css' , array(), _GOLDY_MINING_VERSION );
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'goldy_mining_scripts' );

function goldy_mining_admin_script_style() {
	wp_enqueue_style( 'goldy-mining-admin_site-css', esc_url(get_template_directory_uri()).'/assets/css/admin_site.css' , array(), _GOLDY_MINING_VERSION );
	wp_enqueue_script('goldy-mining-alpha-color-picker',	get_template_directory_uri() . '/assets/js/alpha-color-picker.js',array( 'jquery', 'wp-color-picker' ), null,true);
	wp_enqueue_style('goldy-mining-alpha-color-picker',get_template_directory_uri() . '/assets/css/alpha-color-picker.css',array( 'wp-color-picker' ));
	wp_enqueue_style('wp-color-picker' );
    wp_enqueue_script('wp-color-picker-alpha',  get_template_directory_uri() . '/assets/js/wp-color-picker-alpha.js', array( 'wp-color-picker' ), '1.0.0', true );
   
    $color_picker_strings = array(
        'clear'            => __( 'Clear', 'goldy-mining' ),
        'clearAriaLabel'   => __( 'Clear color', 'goldy-mining' ),
        'defaultString'    => __( 'Default', 'goldy-mining' ),
        'defaultAriaLabel' => __( 'Select default color', 'goldy-mining' ),
        'pick'             => __( 'Select Color', 'goldy-mining' ),
        'defaultLabel'     => __( 'Color value', 'goldy-mining' ),
    );

    wp_localize_script( 'wp-color-picker-alpha', 'wpColorPickerL10n', $color_picker_strings );
    wp_enqueue_script( 'wp-color-picker-alpha' );  
}
add_action('admin_enqueue_scripts', 'goldy_mining_admin_script_style');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

require get_template_directory() . '/inc/customizer-control.php';

require get_template_directory() . '/inc/customizer_css.php';

require get_parent_theme_file_path( '/inc/about.php' );

require get_template_directory() . '/inc/customizer-repeater/functions.php';

require get_template_directory() . '/inc/wptt-webfont-loader.php';


/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}


/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}

function goldy_mining_main_js() {
    wp_enqueue_script( 'main-js', get_theme_file_uri( '/assets/js/owl_slider.js' ), array(), '1.0', true );
    // Localize the script with new data and pass php variables to JS.
    $main_js_data = array(
        /* FOR LATER USE. */
        'goldy_mining_img_autoplay' => esc_attr(get_theme_mod('goldy_mining_featured_slider_autoplay', 'true')),
        'goldy_mining_img_autoplayspped' => esc_attr(get_theme_mod('goldy_mining_featured_slider_autoplay_speed','1000')),
        'goldy_mining_img_autoplaytime' => esc_attr(get_theme_mod('goldy_mining_featured_slider_autoplay_timeout','5000')),

        'goldy_mining_autoplay' => esc_attr(get_theme_mod('goldy_mining_our_testimonial_slider_autoplay', 'true')),
        'goldy_mining_autoplayspped' => esc_attr(get_theme_mod('goldy_mining_our_testimonial_slider_autoplay_speed','1000')),
        'goldy_mining_autoplaytime' => esc_attr(get_theme_mod('goldy_mining_our_testimonial_autoplay_timeout','5000')),

        'goldy_mining_sponsors_autoplay' => esc_attr(get_theme_mod('goldy_mining_our_sponsors_slider_autoplay', 'true')),
        'goldy_mining_sponsors_autoplayspped' => esc_attr(get_theme_mod('goldy_mining_our_sponsors_slider_autoplay_speed','1000')),
        'goldy_mining_sponsors_autoplaytime' => esc_attr(get_theme_mod('goldy_mining_our_sponsors_autoplay_timeout','5000')),


    );
    wp_localize_script( 'main-js', 'main_vars', $main_js_data );
}
add_action( 'wp_enqueue_scripts', 'goldy_mining_main_js' );
global $contecustomarr;
$contecustomarr = array(
		'options' => array(
			'goldy_mining_contact_info_number' => '04463235323',
			'goldy_mining_email_info_number'  => 'goldy-mining@gmail.com',
			'header_top_site_title'  => 'Goldy Mining Pro Theme',
			'display_social_icon'  => true,
			'social_icon_section_content'=> json_encode(
				array(
					array(
						'icon_value'     => 'fa-facebook',
						'link'           => '#',
						'id'             => 'goldy_mining_customizer_repeater_info_001',					
					),
					array(
						'icon_value'     => 'fa-twitter',
						'link'           => '#',
						'id'             => 'goldy_mining_customizer_repeater_info_002',					
					),
					array(
						'icon_value'     => 'fa-linkedin',
						'link'           => '#',
						'id'             => 'goldy_mining_customizer_repeater_info_003',					
					),
					array(
						'icon_value'     => 'fa-instagram',
						'link'           => '#',
						'id'             => 'goldy_mining_customizer_repeater_info_004',					
					),
				)
			), 
			'featuredimage_slider' => json_encode(
				array(
					array(
						'title'           => esc_html__( ' New Skills', 'goldy-mining' ),
						'text'           => esc_html__( ' Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'goldy-mining' ),
						'link'           => esc_html__( ' #', 'goldy-mining' ),
						'text2'           => esc_html__( ' Button', 'goldy-mining' ),
						'id'              => 'goldy_mining_customizer_repeater_slider_001',
					),
				)
			),
			'featured_section_content'=> json_encode(
				array(
					array(
						'icon_value'       => 'fa-cloud',
						'title'           => esc_html__( ' Featured title 1', 'goldy-mining' ),
						'text'           => esc_html__( ' this is featured.', 'goldy-mining' ),
						'id'              => 'goldy_mining_customizer_repeater_featured_slider_001',
					),array(
						'icon_value'       => 'fa-facebook',
						'title'           => esc_html__( ' Featured title 2', 'goldy-mining' ),
						'text'           => esc_html__( ' this is featured.', 'goldy-mining' ),
						'id'              => 'goldy_mining_customizer_repeater_featured_slider_002',
					),array(
						'icon_value'       => 'fa-twitter',
						'title'           => esc_html__( ' Featured title 3', 'goldy-mining' ),
						'text'           => esc_html__( ' this is featured.', 'goldy-mining' ),
						'id'              => 'goldy_mining_customizer_repeater_featured_slider_003',
					),
				)
			),
			'about_main_title' => esc_html__('About Us', 'goldy-mining' ),
			'about_description'  => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-mining' ),
			'about_layout1_title' => esc_html__('Hi, I Am Samantha!', 'goldy-mining' ),
			'about_layout1_subheading' => esc_html__('Owner/Founder, Executive Coach', 'goldy-mining' ),
			'about_layout1_description' => esc_html__('Yes, I Know My Stuff! And Throughout Our Coaching Time, You Will Develop The Tools And Confidence To Take Action. My Way Of Coaching Is To Empower You In Becoming The Leader You Want To Be. You Are Unique And So Your Coaching Should Be Too.', 'goldy-mining' ),
			'about_layout1_button' => esc_html__('Read More', 'goldy-mining' ),
			'about_layout1_button_link' => esc_html__('#', 'goldy-mining' ),
			'our_portfolio_main_title' => esc_html__('Our Portfolio', 'goldy-mining' ),
			'our_portfolio_main_discription' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-mining' ),
			'our_portfolio_section_content' =>  json_encode(
				array(
					array(
					'title'           => esc_html__( 'Free Consulting', 'goldy-mining' ),
					'subtitle'        => esc_html__( 'Business Consulting', 'goldy-mining' ),
					'link'           => '#',
					'icon_value'       => 'fa-facebook-square',
					'id'              => 'goldy_mining_customizer_repeater_portofolio_info_001',					
					),array(
						'title'           => esc_html__( 'Best Analysis', 'goldy-mining' ),
						'subtitle'        => esc_html__( 'Financial Analysis', 'goldy-mining' ),
						'link'           => '#',
						'icon_value'       => 'fa-facebook-square',
						'id'              => 'goldy_mining_customizer_repeater_portofolio_info_002',					
					),array(
						'title'           => esc_html__( 'Successes Reports', 'goldy-mining' ),
						'subtitle'        => esc_html__( 'Project Reporting', 'goldy-mining' ),
						'link'           => '#',
						'icon_value'       => 'fa-facebook-square',
						'id'              => 'goldy_mining_customizer_repeater_portofolio_info_003',					
					),
				)
			),
			'our_team_main_title' => esc_html__('Our Team', 'goldy-mining' ),
			'our_team_main_discription' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-mining' ),
			'our_team_section_content' =>  json_encode(
				array(
					array(
						'title'          => esc_html__( 'Rizon Pet', 'goldy-mining' ),
						'subtitle'       => esc_html__( 'Project Manager', 'goldy-mining' ),
						'link'           => '#',
						'twitter'        => esc_html__( 'https://twitter.com/', 'goldy-mining' ),
						'facebook'       => 'https://www.facebook.com/',
						'linkedin'       => 'https://www.instagram.com/',
						'instagram'      => 'https://www.linkedin.com/feed/',
						'id'             => 'goldy_mining_customizer_repeater_team_info_001',					
					),
					array(
						'title'          => esc_html__( 'Glenn Maxwell', 'goldy-mining' ),
						'subtitle'       => esc_html__( 'Project Manager', 'goldy-mining' ),
						'link'           => '#',
						'twitter'        => 'https://twitter.com/',
						'facebook'       => 'https://www.facebook.com/',
						'linkedin'       => 'https://www.instagram.com/',
						'instagram'      => 'https://www.linkedin.com/feed/',
						'id'             => 'goldy_mining_customizer_repeater_team_info_002',					
					),
					array(
						'title'          => esc_html__( 'Aaron Finch', 'goldy-mining' ),
						'subtitle'       => esc_html__( 'Manager And Director', 'goldy-mining' ),
						'link'           => '#',
						'twitter'        => 'https://twitter.com/',
						'facebook'       => 'https://www.facebook.com/',
						'linkedin'       => 'https://www.instagram.com/',
						'instagram'      => 'https://www.linkedin.com/feed/',
						'id'             => 'goldy_mining_customizer_repeater_team_info_003',					
					),
					array(
						'title'          => esc_html__( 'Christiana Ena', 'goldy-mining' ),
						'subtitle'       => esc_html__( 'Project Manager', 'goldy-mining' ),
						'link'           => '#',
						'twitter'        => 'https://twitter.com/',
						'facebook'       => 'https://www.facebook.com/',
						'linkedin'       => 'https://www.instagram.com/',
						'instagram'      => 'https://www.linkedin.com/feed/',
						'id'             => 'goldy_mining_customizer_repeater_team_info_004',					
					),
				)
			),
			'our_testimonial_main_title' => esc_html__('Our Testimonial', 'goldy-mining' ),
			'our_testimonial_main_discription' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-mining' ),
			'our_testimonial_section_content'=> json_encode(
				array(
					array(
						'title'           => esc_html__( 'Rizon Pet', 'goldy-mining' ),
						'subtitle'           => esc_html__( 'New Skills', 'goldy-mining' ),
						'text'           => esc_html__( 'Cricket is a bat-and-ball game played between two teams of eleven players each on a field at the centre.', 'goldy-mining' ),
						'link'           => esc_html__( ' #', 'goldy-mining' ),
						'id'              => 'goldy_mining_customizer_repeater_testimonial_001',
					),array(
						'title'           => esc_html__( 'Glenn Maxwell', 'goldy-mining' ),
						'subtitle'           => esc_html__( 'New Skills', 'goldy-mining' ),
						'text'           => esc_html__( 'Cricket is a bat-and-ball game played between two teams of eleven players each on a field at the centre.', 'goldy-mining' ),
						'link'           => esc_html__( ' #', 'goldy-mining' ),
						'id'              => 'goldy_mining_customizer_repeater_testimonial_002',
					),array(
						'title'           => esc_html__( 'Virat kohli', 'goldy-mining' ),
						'subtitle'           => esc_html__( 'New Skills', 'goldy-mining' ),
						'text'           => esc_html__( 'Cricket is a bat-and-ball game played between two teams of eleven players each on a field at the centre.', 'goldy-mining' ),
						'link'           => esc_html__( ' #', 'goldy-mining' ),
						'id'              => 'goldy_mining_customizer_repeater_testimonial_003',
					),
				)
			),
			'our_sponsors_main_title' => esc_html__('Our Sponsors', 'goldy-mining' ),
			'our_sponsors_main_discription' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-mining' ),
			'our_sponsors_section_content'=> json_encode(
				array(
					array(					
						'link'           => '#',
						'id'              => 'goldy_mining_customizer_repeater_sponsors_001',
					),
					array(
						'link'           => '#',
						'id'              => 'goldy_mining_customizer_repeater_sponsors_002',
					),
					array(
						'link'           => '#',
						'id'              => 'goldy_mining_customizer_repeater_sponsors_003',
					),
					
			    )
			),
		),
 	);
add_theme_support( 'starter-content',$contecustomarr);
