<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package goldy-health-cover
 */
global $contecustomarr;
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'goldy-health-cover' ); ?></a>
			<header id="masthead" class="site-header <?php echo esc_attr(get_theme_mod( 'goldy_health_cover_header_layout'));?>">
			

				<div class="main_site_header">
					<div class="header_topbar">
						<div>
							<?php
								health_cover_social_section();
							?>
						</div>
						<div>
							<ul class="social_infomation">
								<li>
									<?php if(get_theme_mod( 'goldy_health_cover_contact_info_number',$contecustomarr['options']['goldy_health_cover_contact_info_number'])){ ?>
									
										<?php if(!empty(get_theme_mod( 'goldy_health_cover_contact_info_number',$contecustomarr['options']['goldy_health_cover_contact_info_number']))){ ?>
												<div class="contact_data">
													<div class="contact_icon">
														<i class="fa fa-phone"></i>
													</div>
													<div class="contact_info">
														<p><?php echo esc_html(get_theme_mod( 'goldy_health_cover_contact_info_number',$contecustomarr['options']['goldy_health_cover_contact_info_number'] )); ?></p>
													</div>
												</div>
												
										<?php } 
										
									}?>
								</li>
								<li>
									<?php 
									if(get_theme_mod( 'goldy_health_cover_email_info_number',$contecustomarr['options']['goldy_health_cover_email_info_number'] )){ 
										if(!empty(get_theme_mod( 'goldy_health_cover_email_info_number',$contecustomarr['options']['goldy_health_cover_email_info_number'] ))){ ?>
											<div class="email_data">
												<div class="email_icon">
													<i class="fa fa-envelope"></i>
												</div>
												<div class="email_info">
													<p><?php echo esc_html(get_theme_mod( 'goldy_health_cover_email_info_number',$contecustomarr['options']['goldy_health_cover_email_info_number'] )); ?></p>
												</div>
											</div>
										<?php }
									} ?>
								</li>
							</ul>
						</div>
					</div>
					<div class="site_main_header">
						<div class="">
							<div class="header_data">
								<div class="site-branding">
									<?php
									the_custom_logo();
									?>
									<div class="header_logo">
										<?php
										if ( is_front_page() && is_home() ) :
											?>
											<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
											<?php
										else :
											?>
											<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
											<?php
										endif;
										$health_cover_description = get_bloginfo( 'description', 'display' );
										if ( $health_cover_description || is_customize_preview() ) :
											?>
											<p class="site-description"><?php echo esc_html($health_cover_description); ?></p>
										<?php endif; ?>
									</div>
								</div><!-- .site-branding -->
							</div>
						</div>
						<div class="site_navmenu">
							<div class="call_button_info">
								<nav id="site-navigation" class="main-navigation">
									<button class="menu-toggle" id="navbar-toggle" aria-controls="primary-menu" aria-expanded="false">
										<i class="fa fa-bars"></i>
									</button>
									<?php
									wp_nav_menu(
										array(
											'theme_location' => 'menu-1',
											'menu_id'        => 'primary-menu',
										)
									);
									?>							
								</nav>
								<div class="mobile_menu main-navigation" id="mobile_primary">
									<?php
									wp_nav_menu(
										array(
											'theme_location' => 'menu-1',
											'menu_id'        => 'primary-menu',
										)
									);
									?>
									<button class="menu-toggle" id="mobilepop"  aria-expanded="false">
										<i class="fa fa-close"></i>
									</button>
								</div>				
							</div>
						</div>
					</div>
				</div>
				
			</header><!-- #masthead -->	
			
	<?php echo esc_attr(health_cover_breadcrumb_sections()); 
	if ( is_front_page() ) {
		if (  !empty( get_theme_mod( 'goldy_health_cover_contact_info_number') )  || !empty( get_theme_mod( 'goldy_health_cover_email_info_number') ) || !empty( get_theme_mod( 'goldy_health_cover_display_social_icon') ) || !empty( get_theme_mod( 'goldy_health_cover_social_icon_section_content') ) || !empty( get_theme_mod( 'goldy_health_cover_featuredimage_slider') ) || !empty( get_theme_mod( 'goldy_health_cover_featured_section_content') ) || !empty( get_theme_mod( 'goldy_health_cover_about_main_title') ) || !empty( get_theme_mod( 'goldy_health_cover_our_portfolio_main_title') ) || !empty( get_theme_mod( 'goldy_health_cover_our_team_main_title') ) || !empty( get_theme_mod( 'goldy_health_cover_our_testimonial_main_title') ) || !empty( get_theme_mod( 'goldy_health_cover_our_sponsors_main_title') )) { ?>
			<div class="theme_section_info">
				<?php 
					$goldy_health_cover_diseble = get_theme_mod( 'goldy_health_cover_diseble' );
					$goldy_health_cover_diseble_array =  explode(",",$goldy_health_cover_diseble);

					$glodly_ordring = get_theme_mod( 'globalddd_ordering' );
					$glodly_sortable =  explode(",",$glodly_ordring);

					$orderarr = array('goldy_health_cover_featuredimage_slider','goldy_health_cover_featured_section','goldy_health_cover_widget_section','goldy_health_cover_about_section','goldy_health_cover_our_portfolio_section','goldy_health_cover_appointment_section','goldy_health_cover_our_team_section','goldy_health_cover_our_testimonial_section','goldy_health_cover_our_sponsors_section','goldy_health_cover_services_section');
					$orderarr = apply_filters('health_cover_order_settings', $orderarr);
					$global_ordering_array = get_theme_mod( 'global_ordering',$orderarr );
					?>
					<?php
					if(is_front_page()){
						if(!empty($glodly_ordring)){
							foreach ($glodly_sortable as $glodly_sortables => $glodly_sortable_value) { 
								if(!in_array( $glodly_sortable_value, $goldy_health_cover_diseble_array)){
									call_user_func($glodly_sortable_value);
								}		
							}
						}elseif(!empty($global_ordering_array)){
							foreach ($global_ordering_array as $global_ordering_arraydd) { 
								if(!in_array( $global_ordering_arraydd, $goldy_health_cover_diseble_array)){
									call_user_func($global_ordering_arraydd);
								}		
							}
						}
									
					} 
				?>
			</div>
			<?php
		}else{
			//if (current_user_can('edit_theme_options')) {
				?>
				<div class="theme_section_info">
				<?php 
					$goldy_health_cover_diseble = get_theme_mod( 'goldy_health_cover_diseble' );
					$goldy_health_cover_diseble_array =  explode(",",$goldy_health_cover_diseble);

					$glodly_ordring = get_theme_mod( 'globalddd_ordering' );
					$glodly_sortable =  explode(",",$glodly_ordring);

					$orderarr = array('goldy_health_cover_featuredimage_slider','goldy_health_cover_featured_section','goldy_health_cover_widget_section','goldy_health_cover_about_section','goldy_health_cover_our_portfolio_section','goldy_health_cover_appointment_section','goldy_health_cover_our_team_section','goldy_health_cover_our_testimonial_section','goldy_health_cover_our_sponsors_section','goldy_health_cover_services_section');
					$orderarr = apply_filters('health_cover_order_settings', $orderarr);
					$global_ordering_array = get_theme_mod( 'global_ordering',$orderarr );
					?>
					<?php
					if(is_front_page()){
						if(!empty($glodly_ordring)){
							foreach ($glodly_sortable as $glodly_sortables => $glodly_sortable_value) { 
								if(!in_array( $glodly_sortable_value, $goldy_health_cover_diseble_array)){
									call_user_func($glodly_sortable_value);
								}		
							}
						}elseif(!empty($global_ordering_array)){
							foreach ($global_ordering_array as $global_ordering_arraydd) { 
								if(!in_array( $global_ordering_arraydd, $goldy_health_cover_diseble_array)){
									call_user_func($global_ordering_arraydd);
								}		
							}
						}
									
					} 
				?>
			</div>
				<?php
			//}
		}
	}?>
	<div class="health_cover_container_data">
		<?php
		if(get_post_meta(get_the_ID(),'sidebar_select',true)){
			?>
			<div class="health_cover_container_info <?php echo esc_attr(get_post_meta(get_the_ID(),'sidebar_select',true));?> <?php echo esc_attr(get_theme_mod( 'goldy_health_cover_container_blog_layout','grid_view'));?> <?php echo esc_attr(get_theme_mod( 'goldy_health_cover_container_page_layout','content_boxed'));?>">
				<?php
		}else{
		?>
		<div class="health_cover_container_info <?php echo esc_attr(get_theme_mod( 'goldy_health_cover_post_sidebar_select_'.get_post_type(),'right_sidebar'));?> <?php echo esc_attr(get_theme_mod( 'goldy_health_cover_container_blog_layout','grid_view'));?> <?php echo esc_attr(get_theme_mod( 'goldy_health_cover_container_page_layout','content_boxed'));?>">
<?php }
