<?php
/**
 * goldy-health-cover functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package goldy-health-cover
 */

if ( ! defined( '_GOLDY_HEALTH_COVER_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_GOLDY_HEALTH_COVER_VERSION', '1.0.0' );
}

if ( ! function_exists( 'goldy_health_cover_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function goldy_health_cover_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on goldy-health-cover, use a find and replace
		 * to change 'goldy-health-cover' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'goldy-health-cover', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary', 'goldy-health-cover' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'health_cover_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'goldy_health_cover_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $health_cover_content_width
 */
function health_cover_content_width() {
	$GLOBALS['health_cover_content_width'] = apply_filters( 'health_cover_content_width', 640 );
}
add_action( 'after_setup_theme', 'health_cover_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function health_cover_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'goldy-health-cover' ),
			'id'            => 'health_cover_sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-health-cover' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer1', 'goldy-health-cover' ),
			'id'            => 'health_cover_footer1',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-health-cover' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer2', 'goldy-health-cover' ),
			'id'            => 'health_cover_footer2',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-health-cover' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer3', 'goldy-health-cover' ),
			'id'            => 'health_cover_footer3',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-health-cover' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer4', 'goldy-health-cover' ),
			'id'            => 'health_cover_footer4',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-health-cover' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer5', 'goldy-health-cover' ),
			'id'            => 'health_cover_footer5',
			'description'   => esc_html__( 'Add widgets here.', 'goldy-health-cover' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'health_cover_widgets_init' );


function health_cover_wpdocs_setup_theme() {
    add_theme_support( 'post-thumbnails' );
    set_post_thumbnail_size( 600, 350, true );
}
add_action( 'after_setup_theme', 'health_cover_wpdocs_setup_theme' );



// Add custom meta box
add_action("add_meta_boxes", "health_cover_add_sidebar_meta_box");
function health_cover_add_sidebar_meta_box()
{
	$post_types = get_post_type();
    add_meta_box("goldy-health-cover-meta-box", esc_html__( "Custom Meta Box", 'goldy-health-cover' ),"health_cover_sidebar_meta_box_markup", $post_types, "normal", "high", null);
}
function health_cover_sidebar_meta_box_markup($object){
	?>
	<table class="admin_sidebar_select">
		<tr><td><label><h2 class="custom_meta"><?php echo esc_html__( 'Breadcrumb', 'goldy-health-cover' );?></h2></label></td></tr>
	   	<tr>
	   		<td>
	   			<label for="health_cover_breadcrumb_select">
	   				<input type="radio" name="health_cover_breadcrumb_select" id="health_cover_breadcrumb_select" value="yes" <?php if(get_post_meta($object->ID,'health_cover_breadcrumb_select',true)=='yes'){echo "checked";}?>><?php echo esc_html__( 'Yes', 'goldy-health-cover' );?> 
	   				<input type="radio" name="health_cover_breadcrumb_select" id="health_cover_breadcrumb_select" value="no" <?php if(get_post_meta($object->ID,'health_cover_breadcrumb_select',true)=='no'){echo "checked";}?>><?php echo esc_html__( 'No', 'goldy-health-cover' );?>
	   			</label>
	   		</td>
	   	</tr>
	   	<tr><td><label><h2 class="custom_meta">Sidebar</h2></label></td></tr>
   		<tr>
	   		<td>
	   			<label for="no_sidebar">		   				
	   				<input type="radio" name="sidebar_select" id="no_sidebar" class="no_sidebar" value="no_sidebar" <?php if(get_post_meta($object->ID,'sidebar_select',true)=='no_sidebar'){echo "checked";}?>>
		   				<img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/images/full.png' ?>">
		   			</input>
	   			</label>
	   			<label for="left_sidebar">
	   				<input type="radio" name="sidebar_select" id="left_sidebar" class="left_sidebar" value="left_sidebar" <?php if(get_post_meta($object->ID,'sidebar_select',true)=='left_sidebar'){echo "checked";}?>>
	   					<img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/images/left.png' ?>">
	   				</input>
	   			</label>
	   			<label for="right_sidebar">			   				
	   				<input type="radio" name="sidebar_select" id="right_sidebar" class="right_sidebar" value="right_sidebar" <?php if(get_post_meta($object->ID,'sidebar_select',true)=='right_sidebar'){echo "checked";}?>>
	   					<img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/images/right.png' ?>">
	   				</input>
	   			</label>			
	   		</td>
	   	</tr>
	</table>
	<?php
}
add_action( 'save_post','health_cover_save_sidebar_meta_box_data');
function health_cover_save_sidebar_meta_box_data( $post_id ) {
	if(isset($_REQUEST['health_cover_breadcrumb_select'])){
		$health_cover_breadcrumb_select = filter_var(wp_unslash($_REQUEST['health_cover_breadcrumb_select']),FILTER_SANITIZE_STRING);
		update_post_meta($post_id,'health_cover_breadcrumb_select',$health_cover_breadcrumb_select);
	}
	if(isset($_REQUEST['sidebar_select'])){
		$sidebar_select = filter_var(wp_unslash($_REQUEST['sidebar_select']),FILTER_SANITIZE_STRING);
		update_post_meta($post_id,'sidebar_select',$sidebar_select);
	}
}

function health_cover_breadcrumb_slider(){
	?>
	<div class="breadcrumb_info">
		<div class="breadcrumb_data">
			<section id="breadcrumb-section" class="breadcrumb-area breadcrumb-centerc">
				<div class="breadcrumb-content">
					<div class="breadcrumb-heading">
						<h1><?php  health_cover_breadcrumb_title();	?></h1>
					</div>
					<ol class="breadcrumb-list">
						<li>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html__( 'Home', 'goldy-health-cover' );?></a>
							<?php echo "&nbsp;&nbsp;&#187;&nbsp;&nbsp;"; ?>
						</li>
						<li>
							<?php health_cover_breadcrumb_title();?>
						</li>
					</ol>
				</div> 
			</section>
		</div>		
	</div>
	<?php
}
/**
 * Enqueue scripts and styles.
 */
function health_cover_scripts() {
	wp_enqueue_script('jquery', false, array(), false, false);
	wp_enqueue_style( 'goldy-health-cover-style', get_stylesheet_uri(), array(), _GOLDY_HEALTH_COVER_VERSION );
	wp_style_add_data( 'goldy-health-cover-style', 'rtl', 'replace' );

	wp_enqueue_script( 'goldy-health-cover-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array(), _GOLDY_HEALTH_COVER_VERSION, true );
		wp_localize_script( 'goldy-health-cover-navigation', 'aboutdata', 
				array(
					'about_sec' => esc_attr(get_theme_mod('goldy_health_cover_diseble')),
				)
     	);
	wp_enqueue_script( 'goldy-health-cover-owl_slider', get_template_directory_uri() . '/assets/js/owl_slider.js', array(), _GOLDY_HEALTH_COVER_VERSION, true );	
	wp_enqueue_script( 'goldy-health-cover-owl-carousel-min', get_template_directory_uri() . '/assets/js/owl.carousel.js', array(), _GOLDY_HEALTH_COVER_VERSION, true );	
	wp_enqueue_script( 'goldy-health-cover-appoinment', get_template_directory_uri() . '/assets/js/appoinment.js', array(), _GOLDY_HEALTH_COVER_VERSION, true );
	wp_localize_script( 'goldy-health-cover-appoinment', 'health_appoinment', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));
	wp_enqueue_style( 'goldy-health-cover-theme-css', esc_url(get_template_directory_uri()).'/assets/css/theme.css' , array(), _GOLDY_HEALTH_COVER_VERSION );
	wp_enqueue_style( 'goldy-health-cover-fontawesome-css', esc_url(get_template_directory_uri()).'/assets/fontawesome/css/font-awesome.css' , array(), _GOLDY_HEALTH_COVER_VERSION );
	wp_enqueue_style( 'goldy-health-cover-owl-carousel-min-css', esc_url(get_template_directory_uri()).'/assets/css/owl.carousel.min.css' , array(), _GOLDY_HEALTH_COVER_VERSION );
	wp_enqueue_style( 'goldy-health-cover-owl-carousel_theme-min-css', esc_url(get_template_directory_uri()).'/assets/css/owl.theme.min.css' , array(), _GOLDY_HEALTH_COVER_VERSION );
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'health_cover_scripts' );

function health_cover_admin_script_style() {
	wp_enqueue_style( 'goldy-health-cover-admin_site-css', esc_url(get_template_directory_uri()).'/assets/css/admin_site.css' , array(), _GOLDY_HEALTH_COVER_VERSION );
	wp_enqueue_script('goldy-health-cover-alpha-color-picker',	get_template_directory_uri() . '/assets/js/alpha-color-picker.js',array( 'jquery', 'wp-color-picker' ), null,true);
	wp_enqueue_style('goldy-health-cover-alpha-color-picker',get_template_directory_uri() . '/assets/css/alpha-color-picker.css',array( 'wp-color-picker' ));
	wp_enqueue_style('wp-color-picker' );
    wp_enqueue_script('wp-color-picker-alpha',  get_template_directory_uri() . '/assets/js/wp-color-picker-alpha.js', array( 'wp-color-picker' ), '1.0.0', true );
   
    $color_picker_strings = array(
        'clear'            => __( 'Clear', 'goldy-health-cover' ),
        'clearAriaLabel'   => __( 'Clear color', 'goldy-health-cover' ),
        'defaultString'    => __( 'Default', 'goldy-health-cover' ),
        'defaultAriaLabel' => __( 'Select default color', 'goldy-health-cover' ),
        'pick'             => __( 'Select Color', 'goldy-health-cover' ),
        'defaultLabel'     => __( 'Color value', 'goldy-health-cover' ),
    );

    wp_localize_script( 'wp-color-picker-alpha', 'wpColorPickerL10n', $color_picker_strings );
    wp_enqueue_script( 'wp-color-picker-alpha' );  
}
add_action('admin_enqueue_scripts', 'health_cover_admin_script_style');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

require get_template_directory() . '/inc/customizer-control.php';

require get_template_directory() . '/inc/customizer_css.php';

require get_parent_theme_file_path( '/inc/about.php' );

require get_template_directory() . '/inc/goldy-health-cover-customizer-repeater/functions.php';

require get_template_directory() . '/inc/wptt-webfont-loader.php';

require get_template_directory() . '/inc/appoinment_load.php';


/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}


/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}

function health_cover_main_js() {
    wp_enqueue_script( 'main-js', get_theme_file_uri( '/assets/js/owl_slider.js' ), array(), '1.0', true );
    // Localize the script with new data and pass php variables to JS.
    $main_js_data = array(
        /* FOR LATER USE. */
        'health_cover_img_autoplay' => esc_attr(get_theme_mod('goldy_health_cover_featured_slider_autoplay', 'true')),
        'health_cover_img_autoplayspped' => esc_attr(get_theme_mod('goldy_health_cover_featured_slider_autoplay_speed','1000')),
        'health_cover_img_autoplaytime' => esc_attr(get_theme_mod('goldy_health_cover_featured_slider_autoplay_timeout','5000')),

        'health_cover_autoplay' => esc_attr(get_theme_mod('goldy_health_cover_our_testimonial_slider_autoplay', 'true')),
        'health_cover_autoplayspped' => esc_attr(get_theme_mod('goldy_health_cover_our_testimonial_slider_autoplay_speed','1000')),
        'health_cover_autoplaytime' => esc_attr(get_theme_mod('goldy_health_cover_our_testimonial_autoplay_timeout','5000')),

        'health_cover_sponsors_autoplay' => esc_attr(get_theme_mod('goldy_health_cover_our_sponsors_slider_autoplay', 'true')),
        'health_cover_sponsors_autoplayspped' => esc_attr(get_theme_mod('goldy_health_cover_our_sponsors_slider_autoplay_speed','1000')),
        'health_cover_sponsors_autoplaytime' => esc_attr(get_theme_mod('goldy_health_cover_our_sponsors_autoplay_timeout','5000')),


    );
    wp_localize_script( 'main-js', 'main_vars', $main_js_data );
}
add_action( 'wp_enqueue_scripts', 'health_cover_main_js' );
global $contecustomarr;
$contecustomarr = array(
		'options' => array(
			'goldy_health_cover_contact_info_number' => '04463235323',
			'goldy_health_cover_email_info_number'  => 'info@website.com',
			'goldy_health_cover_display_social_icon'  => true,
			'goldy_health_cover_social_icon_section_content'=> json_encode(
				array(
					array(
						'icon_value'     => 'fa-facebook',
						'link'           => '#',
						'id'             => 'customizer_repeater_info_001',					
					),
					array(
						'icon_value'     => 'fa-twitter',
						'link'           => '#',
						'id'             => 'customizer_repeater_info_002',					
					),
					array(
						'icon_value'     => 'fa-linkedin',
						'link'           => '#',
						'id'             => 'customizer_repeater_info_003',					
					),
					array(
						'icon_value'     => 'fa-instagram',
						'link'           => '#',
						'id'             => 'customizer_repeater_info_004',					
					),
				)
			), 
			'goldy_health_cover_featuredimage_slider' => json_encode(
				array(
					array(
						'title'           => esc_html__( ' New Skills', 'goldy-health-cover' ),
						'text'           => esc_html__( ' Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'goldy-health-cover' ),
						'link'           => esc_html__( ' #', 'goldy-health-cover' ),
						'text2'           => esc_html__( ' Button', 'goldy-health-cover' ),
						'id'              => 'customizer_repeater_slider_001',
					),
				)
			),
			'goldy_health_cover_featured_section_content'=> json_encode(
				array(
					array(
						'icon_value'       => 'fa-cloud',
						'title'           => esc_html__( ' Featured title 1', 'goldy-health-cover' ),
						'text'           => esc_html__( ' this is featured.', 'goldy-health-cover' ),
						'id'              => 'customizer_repeater_featured_slider_001',
					),array(
						'icon_value'       => 'fa-facebook',
						'title'           => esc_html__( ' Featured title 2', 'goldy-health-cover' ),
						'text'           => esc_html__( ' this is featured.', 'goldy-health-cover' ),
						'id'              => 'customizer_repeater_featured_slider_002',
					),array(
						'icon_value'       => 'fa-twitter',
						'title'           => esc_html__( ' Featured title 3', 'goldy-health-cover' ),
						'text'           => esc_html__( ' this is featured.', 'goldy-health-cover' ),
						'id'              => 'customizer_repeater_featured_slider_003',
					),
				)
			),
			'goldy_health_cover_about_main_title' => esc_html__('About Us', 'goldy-health-cover' ),
			'goldy_health_cover_about_description'  => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-health-cover' ),
			'goldy_health_cover_about_layout1_title' => esc_html__('Hi, I Am Samantha!', 'goldy-health-cover' ),
			'goldy_health_cover_about_layout1_subheading' => esc_html__('Owner/Founder, Executive Coach', 'goldy-health-cover' ),
			'goldy_health_cover_about_layout1_description' => esc_html__('Yes, I Know My Stuff! And Throughout Our Coaching Time, You Will Develop The Tools And Confidence To Take Action. My Way Of Coaching Is To Empower You In Becoming The Leader You Want To Be. You Are Unique And So Your Coaching Should Be Too.', 'goldy-health-cover' ),
			'goldy_health_cover_about_layout1_button' => esc_html__('Read More', 'goldy-health-cover' ),
			'goldy_health_cover_about_layout1_button_link' => esc_html__('#', 'goldy-health-cover' ),
			'goldy_health_cover_our_portfolio_main_title' => esc_html__('Our Portfolio', 'goldy-health-cover' ),
			'goldy_health_cover_our_portfolio_main_discription' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-health-cover' ),
			'goldy_health_cover_our_portfolio_section_content' =>  json_encode(
				array(
					array(
					'title'           => esc_html__( 'Free Consulting', 'goldy-health-cover' ),
					'subtitle'        => esc_html__( 'Business Consulting', 'goldy-health-cover' ),
					'text'        => esc_html__( 'Lorem Ipsum Dolor Sit Amet, Consectetur Adipiscing Elit. Sapien, Sit Sed Accumsan, Viverra Sociis Ullamcorper Aenean Fermentum.', 'goldy-health-cover' ),
					'link'           => '#',
					'icon_value'       => 'fa-facebook-square',
					'id'              => 'customizer_repeater_portofolio_info_001',					
					),array(
						'title'           => esc_html__( 'Best Analysis', 'goldy-health-cover' ),
						'subtitle'        => esc_html__( 'Financial Analysis', 'goldy-health-cover' ),
						'text'        => esc_html__( 'Lorem Ipsum Dolor Sit Amet, Consectetur Adipiscing Elit. Sapien, Sit Sed Accumsan, Viverra Sociis Ullamcorper Aenean Fermentum.', 'goldy-health-cover' ),
						'link'           => '#',
						'icon_value'       => 'fa-facebook-square',
						'id'              => 'customizer_repeater_portofolio_info_002',					
					),array(
						'title'           => esc_html__( 'Successes Reports', 'goldy-health-cover' ),
						'subtitle'        => esc_html__( 'Project Reporting', 'goldy-health-cover' ),
						'text'        => esc_html__( 'Lorem Ipsum Dolor Sit Amet, Consectetur Adipiscing Elit. Sapien, Sit Sed Accumsan, Viverra Sociis Ullamcorper Aenean Fermentum.', 'goldy-health-cover' ),
						'link'           => '#',
						'icon_value'       => 'fa-facebook-square',
						'id'              => 'customizer_repeater_portofolio_info_003',					
					),
				)
			),
			'goldy_health_cover_book_an_appointment_main_title' => esc_html__('Book an Appointment', 'goldy-health-cover' ),
			'goldy_health_cover_book_an_appointment_name_field_ph' => esc_html__('Enter Your Name', 'goldy-health-cover' ),
			'goldy_health_cover_book_an_appointment_email_field_ph' => esc_html__('Enter Your Email', 'goldy-health-cover' ),
			'goldy_health_cover_book_an_appointment_number_field_ph' => esc_html__('Your Moblie Number', 'goldy-health-cover' ),
			'goldy_health_cover_book_an_appointment_your_query_field_ph' => esc_html__('Your Query', 'goldy-health-cover' ),
			'goldy_health_cover_book_an_appointment_button_name' => esc_html__('Submit', 'goldy-health-cover' ),
			'goldy_health_cover_our_team_main_title' => esc_html__('Our Team', 'goldy-health-cover' ),
			'goldy_health_cover_our_team_main_discription' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-health-cover' ),
			'goldy_health_cover_our_team_section_content' =>  json_encode(
				array(
					array(
						'title'          => esc_html__( 'Rizon Pet', 'goldy-health-cover' ),
						'subtitle'       => esc_html__( 'Project Manager', 'goldy-health-cover' ),
						'link'           => '#',
						'id'             => 'customizer_repeater_team_info_001',					
					),
					array(
						'title'          => esc_html__( 'Glenn Maxwell', 'goldy-health-cover' ),
						'subtitle'       => esc_html__( 'Project Manager', 'goldy-health-cover' ),
						'link'           => '#',
						'id'             => 'customizer_repeater_team_info_002',					
					),
					array(
						'title'          => esc_html__( 'Aaron Finch', 'goldy-health-cover' ),
						'subtitle'       => esc_html__( 'Manager And Director', 'goldy-health-cover' ),
						'link'           => '#',
						'id'             => 'customizer_repeater_team_info_003',					
					),
					array(
						'title'          => esc_html__( 'Christiana Ena', 'goldy-health-cover' ),
						'subtitle'       => esc_html__( 'Project Manager', 'goldy-health-cover' ),
						'link'           => '#',
						'id'             => 'customizer_repeater_team_info_004',					
					),
				)
			),
			'goldy_health_cover_our_testimonial_main_title' => esc_html__('Our Testimonial', 'goldy-health-cover' ),
			'goldy_health_cover_our_testimonial_main_discription' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-health-cover' ),
			'goldy_health_cover_our_testimonial_section_content'=> json_encode(
				array(
					array(
						'title'           => esc_html__( 'Rizon Pet', 'goldy-health-cover' ),
						'subtitle'           => esc_html__( 'New Skills', 'goldy-health-cover' ),
						'text'           => esc_html__( 'Cricket is a bat-and-ball game played between two teams of eleven players each on a field at the centre.', 'goldy-health-cover' ),
						'link'           => esc_html__( ' #', 'goldy-health-cover' ),
						'id'              => 'customizer_repeater_testimonial_001',
					),array(
						'title'           => esc_html__( 'Glenn Maxwell', 'goldy-health-cover' ),
						'subtitle'           => esc_html__( 'New Skills', 'goldy-health-cover' ),
						'text'           => esc_html__( 'Cricket is a bat-and-ball game played between two teams of eleven players each on a field at the centre.', 'goldy-health-cover' ),
						'link'           => esc_html__( ' #', 'goldy-health-cover' ),
						'id'              => 'customizer_repeater_testimonial_002',
					),array(
						'title'           => esc_html__( 'Virat kohli', 'goldy-health-cover' ),
						'subtitle'           => esc_html__( 'New Skills', 'goldy-health-cover' ),
						'text'           => esc_html__( 'Cricket is a bat-and-ball game played between two teams of eleven players each on a field at the centre.', 'goldy-health-cover' ),
						'link'           => esc_html__( ' #', 'goldy-health-cover' ),
						'id'              => 'customizer_repeater_testimonial_003',
					),
				)
			),
			'goldy_health_cover_our_sponsors_main_title' => esc_html__('Our Sponsors', 'goldy-health-cover' ),
			'goldy_health_cover_our_sponsors_main_discription' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-health-cover' ),
			'goldy_health_cover_our_sponsors_section_content'=> json_encode(
				array(
					array(					
						'link'           => '#',
						'id'              => 'customizer_repeater_sponsors_001',
					),
					array(
						'link'           => '#',
						'id'              => 'customizer_repeater_sponsors_002',
					),
					array(
						'link'           => '#',
						'id'              => 'customizer_repeater_sponsors_003',
					),
					
			    )
			),
			'goldy_health_cover_our_services_main_title' => esc_html__('Our Services', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_first_widget_title' => esc_html__('New Skills', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_first_widget_desc' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s.', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_fisrt_widget_readmore_btn' => esc_html__('Read More', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_first_widget_btn_link' => esc_html__('#', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_second_widget_title' => esc_html__('23 Hours Services', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_second_widget_desc' => esc_html__(' when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_second_widget_readmore_btn' => esc_html__('Read More', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_second_widget_btn_link' => esc_html__('#', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_third_widget_title' => esc_html__('opening Hours', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_third_widget_desc1' => esc_html__('Monday-Friday', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_third_widget_desc2' => esc_html__('9:00AM To 11:00PM', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_third_widget_desc3' => esc_html__('Saturday', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_third_widget_desc4' => esc_html__('10:00AM To 9:00PM', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_third_widget_desc5' => esc_html__('Sunday', 'goldy-health-cover' ),
			'goldy_health_cover_our_services_third_widget_desc6' => esc_html__('10:00AM To 5:00PM', 'goldy-health-cover' ),
		),
 	);
add_theme_support( 'starter-content',$contecustomarr);