<?php
add_action( 'admin_init', 'goldy_ekart_remove_menu_pages' );

function goldy_ekart_remove_menu_pages() {          
	remove_submenu_page( 'themes.php', 'goldy-mex-about' );                                          
}

function goldy_ekart_about_menu() {
	add_theme_page( esc_html__( 'About Theme', 'goldy-ekart' ), esc_html__( 'About Theme', 'goldy-ekart' ), 'edit_theme_options', 'goldy-ekart-about', 'goldy_ekart_about_display' );
}
add_action( 'admin_menu', 'goldy_ekart_about_menu' );

function goldy_ekart_about_display(){
	?>
	<div class="goldy_ekart_about_data">
		<div class="goldy_ekart_about_title">
			<h1><?php echo esc_html( 'Goldy Ekart', 'goldy-ekart' ); ?></h1>
			<div class="goldy_ekart_about_theme">
				<div class="goldy_ekart_about_description">
					<p>
					<?php echo esc_html( 'Goldy Ekart is a clean, modern, user friendly, responsive and highly customizable WordPress theme that is specifically designed for people who wants to developed online store for electronic, headphone, laptop, camera, watch, mobile, plumbing, tools, accessories, or any kind, this theme going to be the best solution. you’ll easily find the design of this theme impressive and suitable for your Website. This Goldy Ekart WordPress theme, carries an abundance of crucial features and functionalities. For instance, featured slider, featured Section, About Section, Our Portfolio, Book an Appointment, Our team Section, Testimonial Slider, Our Services, Our Sponsors, Pricing Plan, Sticky Header, Social Information, Sidebar, Excerpt Options, and many more. All of these highly customizable features and sections are completely responsive and absolutely easy to customize.', 'goldy-ekart' ); ?>
					</p>
					<div class="goldy_ekart_about_demo">
						<div class="feature-section">
							<div class="about_data_goldy_solar">
								<h3><?php echo esc_html( 'Free Theme Demo', 'goldy-ekart' ); ?></h3>
								<?php $theme_demo_url = 'https://inverstheme.com/themedemo/goldy-ekart/'; ?>
								<a href="<?php echo esc_url($theme_demo_url); ?>"><?php echo esc_html( 'Theme Demo ', 'goldy-ekart' ); ?></a>
							</div>
						</div>
						<div class="feature-section">
							<div class="about_data_goldy_solar">
								<h3><?php echo esc_html( 'Documentation', 'goldy-ekart' ); ?></h3>
								<?php $theme_doc_url = 'https://www.inverstheme.com/goldy-ekart-documentation/'; ?>
								<a href="<?php echo esc_url($theme_doc_url); ?>"><?php echo esc_html( 'Read Documentation', 'goldy-ekart' ); ?></a>
							</div>
						</div>
						<div class="feature-section">
							<div class="about_data_goldy_solar">
								<h3><?php echo esc_html( 'Free VS Pro', 'goldy-ekart' ); ?></h3>
								<?php $theme_compare_url = 'https://www.inverstheme.com/theme/goldy-ekart/'; ?>
								<a href="<?php echo esc_url($theme_compare_url); ?>"><?php echo esc_html( 'Compare free Vs Pro ', 'goldy-ekart' ); ?></a>
							</div>
						</div>
					</div>
				</div>

				<div class="goldy_ekart_about_image">
					<img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/screenshot.png">
				</div>
			</div>
		</div>
		<ul class="tabs">
			<li class="tab-link current" data-tab="about"><?php echo esc_html( 'About', 'goldy-ekart' ); ?></li>
		</ul> 
		<div id="about" class="tab-content current">
			<div class="about_section">
				<div class="about_info_data theme_info">
					<div class="about_theme_title">
						<h2><?php echo esc_html( 'For Shortcode', 'goldy-ekart' ); ?></h2>
					</div>
					<div class="about_theme_data">
						<p><?php echo esc_html( "For Displaying Theme Sections in Page or Post Put the Shortcode Which Is Given Below.", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "Featured Slider : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_featuredimage_slider']", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "Featured Section : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_featured_section']", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "Our Portfolio : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_our_portfolio_section']", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "About Us : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_about_section']", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "Book an Appointment : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_appointment_section']", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "Our Team : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_our_team_section']", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "Our Testimonial : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_our_testimonial_section']", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "Pricing Plan : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_ekart_pricing_plan_section']", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "Our Sponsors : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_our_sponsors_section']", 'goldy-ekart' ); ?></p>
						<p><strong><?php echo esc_html( "Our Services : ", 'goldy-ekart' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_services_section']", 'goldy-ekart' ); ?></p>
					</div>
				</div>
				<div class="about_info_data theme_info">
					<div class="about_theme_title">
						<h2><?php echo esc_html( 'Theme Customizer', 'goldy-ekart' ); ?></h2>
					</div>
					<div class="about_theme_data">
						<p><?php echo esc_html( 'All Theme Options are available via Customize screen.', 'goldy-ekart' ); ?></p>
					</div>
					<div class="about_theme_btn">
						<a class="customize_btn button button-primary" href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>"><?php echo esc_html( 'Customize', 'goldy-ekart' ); ?></a>
					</div>
				</div>
				<div class="theme_que theme_info">
					<div class="about_theme_que">
						<h2><?php echo esc_html( 'Got theme support question?', 'goldy-ekart' ); ?></h2>
					</div>
					<div class="about_que_data">
						<p><?php echo esc_html( 'Get genuine support from genuine people. Whether its customization or compatibility, our seasoned developers deliver tailored solutions to your queries.', 'goldy-ekart' ); ?></p>
					</div>
					<div class="about_que_btn">
						<a class="support_forum button button-primary" href="https://www.inverstheme.com/contact-us/"><?php echo esc_html( 'Support Forum', 'goldy-ekart' ); ?></a>
					</div>
				</div>
			</div>
		</div>			
	</div>
	<?php
}
?>