<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package goldy
 */
$selected_categories = get_theme_mod( 'goldy_select_menu_categories', array() );
	if ($selected_categories) { 
?>
    <div class="cafe_menu_section">
        <div class="cafe_menu_data">
        	<?php if(get_theme_mod('goldy_cafe_menu_main_title', 'Our Menu')) { ?>
	        	<div class="cafe_menu_main_title heading_main_title wow fadeInUp">
	        		<h2><?php echo esc_html(get_theme_mod('goldy_cafe_menu_main_title', 'Our Menu'));?></h2>
	        	</div>
	        <?php } ?>
        	<div class="cafe_menu wow fadeInUp">
        	<?php
	        	if (!is_array($selected_categories) && is_string($selected_categories)) {
	                $selected_categories = array($selected_categories);
	            }
	        	foreach ($selected_categories as $category_id) { ?>
	        	<div class="cafe_inner_data">
		        	<?php
				    $category = get_term($category_id, 'cafe-categories');
					if (!empty($category->name)) {
					?>
					<div class="cafe_cat_name">
		        		<h2><?php echo $category->name; ?></h2>
		        	</div>
		        	<?php 
			        }
			        	$args = get_posts(array(
						    'post_type' => 'cafe-menu',
						    'post_status' => 'publish',
					        'posts_per_page' => -1,
					        'order'  => 'ASC',
					        'tax_query' => array(
						        array(
						            'taxonomy' => 'cafe-categories',
						            'field'    => 'term_id',
						            'terms'    => $category_id,
						        ),
						    ),
						)); 
						foreach($args as $pro_post){
							$post_link = get_permalink($pro_post->ID);
							$goldy_cafe_product_price = get_post_meta($pro_post->ID, 'goldy_cafe_product_price', true);
					?>
					<div class="restaurent-menu-item">
						<?php if ( get_the_post_thumbnail_url($pro_post->ID, 'thumbnail') ) : ?>
			        	<div class="cafe_item_img">
			                <img src="<?php echo esc_url( get_the_post_thumbnail_url($pro_post->ID, 'thumbnail') ); ?>" alt="<?php echo esc_attr( $pro_post->post_title ); ?>">
			            </div>
			            <?php endif; ?>
			            <div class="cafe_menu_main">
			            	<div class="cafe_menu_inner">
			            		<a href="<?php echo esc_url($post_link);?>">
						            <h3 class="rest_post_title"><?php echo $pro_post->post_title; ?></h3>
					            </a>
					            <div class="rest_menu_lines"></div>
					            <p class="menu_price"><?php echo esc_html($goldy_cafe_product_price); ?></p>
				            </div>
				            <p class="rest_post_desc"><?php echo $pro_post->post_content; ?></p>
			            </div>
			        </div>
			        <?php 
					    }
				    ?>
			    </div>
			    <?php
			    }
		    ?>
		    </div>
	    </div>
    </div>
<?php } ?>