<?php
add_action("init","goldy_cafe_menu_customizer",11);
function goldy_cafe_menu_customizer(){
// Cafe Menu
	new \Kirki\Section(
		'goldy_cafe_menu_section',
		[
			'title'       => esc_html__( 'Cafe Menu', 'goldy-cafe' ),
			'panel'       => 'globly_theme_option',
			'priority'    => 150,
		]
	);

	new \Kirki\Field\Text(
		[
			'settings' => 'goldy_cafe_menu_main_title',
			'label'    => esc_html__( 'Our Menu Title', 'goldy-cafe' ),
			'section'  => 'goldy_cafe_menu_section',
			'default'  => esc_html__( 'Our Menu', 'goldy-cafe' ),
			'priority' => 5,
			'partial_refresh'    => [
				'goldy_cafe_menu_main_title' => [
					'selector'        => '.cafe_menu_main_title',
					'render_callback' => function() {
					    return true;
					}
				],
			],
		]
	);

	// Get the list of categories
	$categories = get_terms(array(
	    'taxonomy' => 'cafe-categories',
	    'hide_empty' => false,
	));

	// Create an empty array to store the choices
	$category_choices = array();

	// Iterate over the categories and add them to the choices array
	foreach ($categories as $category) {
	    $category_choices[$category->term_id] = $category->name;
	}

	new \Kirki\Field\Select(
		[
			'settings'    => 'goldy_select_menu_categories',
			'label'       => esc_html__( 'Select Menu Categories', 'goldy-cafe' ),
			'description' => esc_html__( 'Select Menu Categories To Display Cafe Menu.', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'multiple'    => 10,
			'choices'     => $category_choices,
		]
	);

	new \Kirki\Field\Image(
		[
			'settings'    => 'goldy_cafe_background_image',
			'label'       => esc_html__( 'Backgroung Image', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => '',
			'priority'    => 15,
		]
	);

	new \Kirki\Field\Select(
		[
			'settings'    => 'goldy_cafe_background_position',
			'label'       => esc_html__( 'Background Position', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => 'center center',
			'priority'    => 20,
			'placeholder' => esc_html__( 'Choose an option', 'goldy-cafe' ),
			'choices'     => [
				'left top' => esc_html__( 'Left Top', 'goldy-cafe' ),
				'left center' => esc_html__( 'Left Center', 'goldy-cafe' ),
				'left bottom' => esc_html__( 'Left Bottom', 'goldy-cafe' ),
				'right top' => esc_html__( 'Right Top', 'goldy-cafe' ),
				'right center' => esc_html__( 'Right Center', 'goldy-cafe' ),
				'right bottom' => esc_html__( 'Right Bottom', 'goldy-cafe' ),
				'center top' => esc_html__( 'Center Top', 'goldy-cafe' ),
				'center center' => esc_html__( 'Center Center', 'goldy-cafe' ),
				'center bottom' => esc_html__( 'Center Bottom', 'goldy-cafe' ),
			],
			'output' => array(
				array(
					'element'  => '.cafe_menu_section',
					'property' => 'background-position',
					'suffix' 	  => '!important',
				),
			),
		]
	);

	new \Kirki\Field\Select(
		[
			'settings'    => 'goldy_cafe_background_attachment',
			'label'       => esc_html__( 'Background Attachment', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => 'scroll',
			'priority'    => 25,
			'placeholder' => esc_html__( 'Choose an option', 'goldy-cafe' ),
			'choices'     => [
				'scroll' => esc_html__( 'Scroll', 'goldy-cafe' ),
				'fixed' => esc_html__( 'Fixed', 'goldy-cafe' ),
			],
			'output' => array(
				array(
					'element'  => '.cafe_menu_section',
					'property' => 'background-attachment',
					'suffix' 	  => '!important',
				),
			),
		]
	);

	new \Kirki\Field\Select(
		[
			'settings'    => 'goldy_cafe_background_size',
			'label'       => esc_html__( 'Background Size', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => 'cover',
			'priority'    => 30,
			'placeholder' => esc_html__( 'Choose an option', 'goldy-cafe' ),
			'choices'     => [
				'auto' => esc_html__( 'Auto', 'goldy-cafe' ),
				'cover' => esc_html__( 'Cover', 'goldy-cafe' ),
				'contain' => esc_html__( 'Contain', 'goldy-cafe' ),
			],
			'output' => array(
				array(
					'element'  => '.cafe_menu_section',
					'property' => 'background-size',
					'suffix' 	  => '!important',
				),
			),
		]
	);

	new \Kirki\Field\Color(
		[
			'settings'    => 'goldy_cafe_menu_background_color',
			'label'       => __( 'Background Color', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => '#ffffff',
			'priority'    => 35,
			'choices'     => [
				'alpha' => true,
			],
			'output' => array(
				array(
					'element'  => '.cafe_menu_section',
					'property' => 'background-color',
				),
			),
		]
	);

	new \Kirki\Field\Color(
		[
			'settings'    => 'goldy_cafe_menu_main_title_color',
			'label'       => __( 'Main Title Color', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => '#333333',
			'priority'    => 40,
			'choices'     => [
				'alpha' => true,
			],
			'output' => array(
				array(
					'element'  => '.cafe_menu_main_title h2',
					'property' => 'color',
				),
			),
		]
	);

	new \Kirki\Field\Color(
		[
			'settings'    => 'goldy_cafe_menu_title_color',
			'label'       => __( 'Menu Main Title Color', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => '#a06f48',
			'priority'    => 45,
			'choices'     => [
				'alpha' => true,
			],
			'output' => array(
				array(
					'element'  => '.cafe_cat_name h2',
					'property' => 'color',
				),
			),
		]
	);

	new \Kirki\Field\Color(
		[
			'settings'    => 'goldy_cafe_menu_item_title_color',
			'label'       => __( 'Menu Iteams Title Color', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => '#404040',
			'priority'    => 50,
			'choices'     => [
				'alpha' => true,
			],
			'output' => array(
				array(
					'element'  => 'h3.rest_post_title',
					'property' => 'color',
				),
			),
		]
	);

	new \Kirki\Field\Color(
		[
			'settings'    => 'goldy_cafe_menu_item_desc_color',
			'label'       => __( 'Iteams Description Color', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => '#8f8f8f',
			'priority'    => 55,
			'choices'     => [
				'alpha' => true,
			],
			'output' => array(
				array(
					'element'  => 'p.rest_post_desc',
					'property' => 'color',
				),
			),
		]
	);

	new \Kirki\Field\Color(
		[
			'settings'    => 'goldy_cafe_menu_items_price_color',
			'label'       => __( 'Iteams Price Color', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => '#a06f48',
			'priority'    => 60,
			'choices'     => [
				'alpha' => true,
			],
			'output' => array(
				array(
					'element'  => 'p.menu_price',
					'property' => 'color',
				),
			),
		]
	);

	new \Kirki\Field\Color(
		[
			'settings'    => 'goldy_cafe_border_color',
			'label'       => __( 'Border Color', 'goldy-cafe' ),
			'section'     => 'goldy_cafe_menu_section',
			'default'     => 'rgba(0, 0, 0, 0.1)',
			'priority'    => 65,
			'choices'     => [
				'alpha' => true,
			],
			'output' => array(
				array(
					'element'  => '.restaurent-menu-item',
					'property' => 'border-color',
				),
			),
		]
	);
}

?>