<?php 
function goldy_create_custom_post_type() {
    $labels = array(
        'name'               => 'Cafe Menu',
        'singular_name'      => 'Menu',
        'add_new'            => 'Add New',
        'add_new_item'       => 'Add New Menu',
        'edit_item'          => 'Edit Menu',
        'new_item'           => 'New Menu',
        'view_item'          => 'View Menu',
        'search_items'       => 'Search Menu',
        'not_found'          => 'No Menu found',
        'not_found_in_trash' => 'No Menu found in Trash',
        'parent_item_colon'  => '',
        'menu_name'          => 'Cafe Menu'
    );

    $args = array(
        'labels'              => $labels,
        'public'              => true,
        'publicly_queryable'  => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'query_var'           => true,
        'rewrite'             => array( 'slug' => 'cafe-menu' ),
        'capability_type'     => 'post',
        'has_archive'         => true,
        'hierarchical'        => false,
        'menu_position'       => 5,
        'menu_icon'           => 'dashicons-list-view',
        'supports'            => array( 'title', 'editor', 'thumbnail' ),
    );

    register_post_type( 'cafe-menu', $args );
}
add_action( 'init', 'goldy_create_custom_post_type' );

function goldy_create_custom_taxonomies() {
    $labels = array(
        'name'              => 'Menu Categories',
        'singular_name'     => 'Custom Taxonomy',
        'search_items'      => 'Search Menu Categories',
        'all_items'         => 'All Menu Categories',
        'parent_item'       => 'Parent Menu Categories',
        'parent_item_colon' => 'Parent Menu Categories:',
        'edit_item'         => 'Edit Menu Categories',
        'update_item'       => 'Update Menu Categories',
        'add_new_item'      => 'Add New Menu Categories',
        'new_item_name'     => 'New Menu Categories',
        'menu_name'         => 'Menu Categories',
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'cafe-categories' ),
    );

    register_taxonomy( 'cafe-categories', 'cafe-menu', $args );
}
add_action( 'init', 'goldy_create_custom_taxonomies' );


function goldy_add_price_meta_box()
{
  add_meta_box("price_meta_box", "Price", "goldy_price_meta_box_markup", "cafe-menu", "normal", "high", null);
}

add_action("add_meta_boxes", "goldy_add_price_meta_box");


function  goldy_price_meta_box_markup($post)
{
wp_nonce_field(basename(__FILE__), "meta-box-nonce");
	$goldy_cafe_product_price = get_post_meta( $post->ID, 'goldy_cafe_product_price', true );
?>
	<label for="goldy_cafe_product_price">Price:</label>
    <input type="text" id="goldy_cafe_product_price" name="goldy_cafe_product_price" value="<?php echo esc_attr($goldy_cafe_product_price); ?>">
<?php  

}

function goldy_save_custom_metabox( $post_id ) {
    if ( isset( $_POST['goldy_cafe_product_price'] ) ) {
        $goldy_cafe_product_price = sanitize_text_field( $_POST['goldy_cafe_product_price'] );
        update_post_meta( $post_id, 'goldy_cafe_product_price', $goldy_cafe_product_price );
    }
}
add_action( 'save_post', 'goldy_save_custom_metabox' );
?>