<?php
add_action( 'admin_init', 'goldy_cafe_remove_menu_pages' );

function goldy_cafe_remove_menu_pages() {          
	remove_submenu_page( 'themes.php', 'goldy-mex-about' );                                          
}

function goldy_cafe_about_menu() {
	add_theme_page( esc_html__( 'About Theme', 'goldy-cafe' ), esc_html__( 'About Theme', 'goldy-cafe' ), 'edit_theme_options', 'goldy-cafe-about', 'goldy_cafe_about_display' );
}
add_action( 'admin_menu', 'goldy_cafe_about_menu' );

function goldy_cafe_about_display(){
	?>
	<div class="goldy_cafe_about_data">
		<div class="goldy_cafe_about_title">
			<h1><?php echo esc_html( 'Goldy Cafe', 'goldy-cafe' ); ?></h1>
			<div class="goldy_cafe_about_theme">
				<div class="goldy_cafe_about_description">
					<p>
					<?php echo esc_html( 'Goldy Cafe Innovator is a modern and versatile WordPress theme designed exclusively for cafe and culinary-focused businesses. With Goldy Cafe Innovator, you have the perfect WordPress theme to create an attractive and functional website that will help you promote your cafe, connect with your audience, and boost your online presence in the culinary world. This theme serves as your gateway to creating a captivating online presence that caters to a wide array of cafe products and services. With its sleek and user-friendly design, Goldy Cafe Innovator provides a responsive and customizable platform suitable for a variety of niches, ranging from coffee shops and eateries to bakery and catering services. You will undoubtedly find the design of this theme to be impressive and perfectly tailored to your cafe-focused website.', 'goldy-cafe' ); ?>
					</p>
					<div class="goldy_cafe_about_demo">
						<div class="feature-section">
							<div class="about_data_goldy_solar">
								<h3><?php echo esc_html( 'Free Theme Demo', 'goldy-cafe' ); ?></h3>
								<?php $theme_demo_url = 'https://inverstheme.com/themedemo/goldy-cafe/'; ?>
								<a href="<?php echo esc_url($theme_demo_url); ?>"><?php echo esc_html( 'Theme Demo ', 'goldy-cafe' ); ?></a>
							</div>
						</div>
						<div class="feature-section">
							<div class="about_data_goldy_solar">
								<h3><?php echo esc_html( 'Documentation', 'goldy-cafe' ); ?></h3>
								<?php $theme_doc_url = 'https://www.inverstheme.com/goldy-cafe-documentation/'; ?>
								<a href="<?php echo esc_url($theme_doc_url); ?>"><?php echo esc_html( 'Read Documentation', 'goldy-cafe' ); ?></a>
							</div>
						</div>
						<div class="feature-section">
							<div class="about_data_goldy_solar">
								<h3><?php echo esc_html( 'Free VS Pro', 'goldy-cafe' ); ?></h3>
								<?php $theme_compare_url = 'https://www.inverstheme.com/theme/goldy-cafe-pro/'; ?>
								<a href="<?php echo esc_url($theme_compare_url); ?>"><?php echo esc_html( 'Compare free Vs Pro ', 'goldy-cafe' ); ?></a>
							</div>
						</div>
					</div>
				</div>

				<div class="goldy_cafe_about_image">
					<img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/screenshot.png">
				</div>
			</div>
		</div>
		<ul class="tabs">
			<li class="tab-link current" data-tab="about"><?php echo esc_html( 'About', 'goldy-cafe' ); ?></li>
		</ul> 
		<div id="about" class="tab-content current">
			<div class="about_section">
				<div class="about_info_data theme_info">
					<div class="about_theme_title">
						<h2><?php echo esc_html( 'For Shortcode', 'goldy-cafe' ); ?></h2>
					</div>
					<div class="about_theme_data">
						<p><?php echo esc_html( "For Displaying Theme Sections in Page or Post Put the Shortcode Which Is Given Below.", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "Featured Slider : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_featuredimage_slider']", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "Featured Section : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_featured_section']", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "Our Portfolio : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_our_portfolio_section']", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "About Us : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_about_section']", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "Book an Appointment : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_appointment_section']", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "Our Team : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_our_team_section']", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "Our Testimonial : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_our_testimonial_section']", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "Pricing Plan : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_cafe_pricing_plan_section']", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "Our Sponsors : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_our_sponsors_section']", 'goldy-cafe' ); ?></p>
						<p><strong><?php echo esc_html( "Our Services : ", 'goldy-cafe' ); ?></strong><?php echo esc_html( "[themesection section='goldy_mex_services_section']", 'goldy-cafe' ); ?></p>
					</div>
				</div>
				<div class="about_info_data theme_info">
					<div class="about_theme_title">
						<h2><?php echo esc_html( 'Theme Customizer', 'goldy-cafe' ); ?></h2>
					</div>
					<div class="about_theme_data">
						<p><?php echo esc_html( 'All Theme Options are available via Customize screen.', 'goldy-cafe' ); ?></p>
					</div>
					<div class="about_theme_btn">
						<a class="customize_btn button button-primary" href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>"><?php echo esc_html( 'Customize', 'goldy-cafe' ); ?></a>
					</div>
				</div>
				<div class="theme_que theme_info">
					<div class="about_theme_que">
						<h2><?php echo esc_html( 'Got theme support question?', 'goldy-cafe' ); ?></h2>
					</div>
					<div class="about_que_data">
						<p><?php echo esc_html( 'Get genuine support from genuine people. Whether its customization or compatibility, our seasoned developers deliver tailored solutions to your queries.', 'goldy-cafe' ); ?></p>
					</div>
					<div class="about_que_btn">
						<a class="support_forum button button-primary" href="https://www.inverstheme.com/contact-us/"><?php echo esc_html( 'Support Forum', 'goldy-cafe' ); ?></a>
					</div>
				</div>
			</div>
		</div>			
	</div>
	<?php
}
?>