<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'glass-artifact' ); ?></a>

<?php if(get_theme_mod('glass_artifact_site_loader',false)!= ''){ ?>
    <?php if(get_theme_mod( 'glass_artifact_preloader_type','four-way-loader') == 'four-way-loader'){ ?>
	    <div class="cssloader">
	    	<div class="sh1"></div>
	    	<div class="sh2"></div>
	    	<h1 class="lt"><?php esc_html_e( 'loading',  'glass-artifact' ); ?></h1>
	    </div>
    <?php }else if(get_theme_mod( 'glass_artifact_preloader_type') == 'cube-loader') {?>
		<div class="cssloader">
    		<div class="loader-main ">
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
			</div>
    	</div>
    <?php }?>
<?php }?>

<div class="<?php if( get_theme_mod( 'glass_artifact_sticky_header', false) != '') { ?>sticky-header<?php } else { ?>close-sticky main-menus<?php } ?>">
	<div id="site-navigation" class="main-header-box wow fadeInDown">
		<div class="container">
			<div class="inner-header-box">
				<div class="top-header">
					<div class="row">
						<div class="col-lg-3 col-md-3 col-sm-4 logo-position align-self-center">
				    		<div class="logo text-start">
					    		<div class="logo-image">
					    			<?php the_custom_logo(); ?>
						    	</div>
						    	<div class="logo-content">
							    	<?php
							    		if ( get_theme_mod('glass_artifact_display_header_title', true) == true ) :
								      		echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
								      			echo esc_attr(get_bloginfo('name'));
								      		echo '</a>';
								      	endif;

								      	if ( get_theme_mod('glass_artifact_display_header_text', false) == true ) :
							      			echo '<span>'. esc_attr(get_bloginfo('description')) . '</span>';
							      		endif;
						    		?>
								</div>
							</div>
					   	</div>
						<div class="col-lg-6 col-md-5 col-sm-2 align-self-center">
							<div class="top-menu-wrapper">
							    <div class="navigation_header">
							        <div class="toggle-nav mobile-menu">
							            <button onclick="glass_artifact_openNav()">
							                <span class="dashicons dashicons-menu"></span>
							            </button>
							        </div>
							        <div id="mySidenav" class="nav sidenav">
							            <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'glass-artifact' ); ?>">
							                <?php {
							                    wp_nav_menu(
							                        array(
							                            'theme_location' => 'main-menu',
							                            'container_class' => 'navi clearfix navbar-nav',
							                            'menu_class'     => 'menu clearfix',
							                            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
							                            'fallback_cb'    => 'wp_page_menu',
							                        )
							                    );
							                } ?>
							            </nav>
							            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="glass_artifact_closeNav()">
							                <span class="dashicons dashicons-no"></span>
							            </a>
							        </div>
							    </div>
							</div>
						</div>
						<div class="col-lg-3 col-md-4 col-sm-6 align-self-center">
							<div class="text-end sign-button">
								<?php if ( get_theme_mod('glass_artifact_sign_up_url') || get_theme_mod('glass_artifact_sign_up_text') ) : ?>
									<a href="<?php echo esc_url( get_theme_mod('glass_artifact_sign_up_url' ) ); ?>" class="me-md-2 signup-btn"><?php echo esc_html( get_theme_mod('glass_artifact_sign_up_text' ) ); ?></a>
								<?php endif; ?>
								<?php if ( get_theme_mod('glass_artifact_sign_in_url') || get_theme_mod('glass_artifact_sign_in_text') ) : ?>
									<a href="<?php echo esc_url( get_theme_mod('glass_artifact_sign_in_url' ) ); ?>" class=" signin-box"><?php echo esc_html( get_theme_mod('glass_artifact_sign_in_text' ) ); ?></a>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>