<?php
/**
* Get started notice
*/

add_action( 'wp_ajax_glass_artifact_dismissed_notice_handler', 'glass_artifact_ajax_notice_handler' );

function glass_artifact_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function glass_artifact_deprecated_hook_admin_notice() {
    // Check if it's been dismissed...
    if ( ! get_option( 'dismissed-get_started', false ) ) {
        $current_screen = get_current_screen();

        // Check screen ID correctly
        if ( 
            $current_screen && 
            $current_screen->id !== 'appearance_page_glass-artifact-guide-page' &&
            $current_screen->id !== 'appearance_page_glassartifact-wizard'
        ) {
            $glass_artifact_comments_theme = wp_get_theme();
            ?>
            <div class="glass-artifact-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="glass-artifact-notice">
                    <div class="glass-artifact-notice-content">
                        <div class="glass-artifact-notice-heading">
                            <h2>
                                <?php esc_html_e('Thanks For Installing ', 'glass-artifact'); ?>
                                <?php echo esc_html( $glass_artifact_comments_theme ); ?>
                                <?php esc_html_e('Theme', 'glass-artifact'); ?>
                            </h2>
                            <p>
                                <?php
                                /* translators: %s: theme name */
                                printf(
                                    esc_html__("%s is now installed and ready to use. We've provided some links to get you started.", 'glass-artifact'),
                                    $glass_artifact_comments_theme
                                );
                                ?>
                            </p>
                        </div>
                        <div class="diplay-flex-btn">
                            <a class="button button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=glass-artifact-guide-page' ) ); ?>">
                                <?php echo esc_html__('GET STARTED', 'glass-artifact'); ?>
                            </a>
                            <a class="button button-primary" href="<?php echo esc_url( GLASS_ARTIFACT_BUY_NOW ); ?>">
                                <?php echo esc_html__('GO TO PREMIUM', 'glass-artifact'); ?>
                            </a>
                            <a class="button button-primary import" href="<?php echo esc_url( admin_url( 'themes.php?page=glassartifact-wizard' ) ); ?>">
                                <?php echo esc_html__('ONE CLICK DEMO IMPORTER', 'glass-artifact'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="glass-artifact-notice-img">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/notification.png' ); ?>" alt="<?php esc_attr_e('logo', 'glass-artifact'); ?>">
                    </div>
                </div>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'glass_artifact_deprecated_hook_admin_notice' );

add_action( 'admin_menu', 'glass_artifact_getting_started' );
function glass_artifact_getting_started() {
	add_theme_page( esc_html__('Get Started', 'glass-artifact'), esc_html__('Get Started', 'glass-artifact'), 'edit_theme_options', 'glass-artifact-guide-page', 'glass_artifact_test_guide');
}

function glass_artifact_admin_enqueue_scripts() {
	wp_enqueue_style( 'glass-artifact-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'glass-artifact-admin-script', get_template_directory_uri() . '/js/glass-artifact-admin-script.js', array( 'jquery' ), '', true );
    wp_localize_script( 'glass-artifact-admin-script', 'glass_artifact_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'glass_artifact_admin_enqueue_scripts' );

if ( ! defined( 'GLASS_ARTIFACT_DOCS_FREE' ) ) {
define('GLASS_ARTIFACT_DOCS_FREE',__('https://demo.misbahwp.com/docs/glass-artifact-free-docs/','glass-artifact'));
}
if ( ! defined( 'GLASS_ARTIFACT_DOCS_PRO' ) ) {
define('GLASS_ARTIFACT_DOCS_PRO',__('https://demo.misbahwp.com/docs/glass-artifact-pro-docs','glass-artifact'));
}
if ( ! defined( 'GLASS_ARTIFACT_BUY_NOW' ) ) {
define('GLASS_ARTIFACT_BUY_NOW',__('https://www.misbahwp.com/products/artifact-wordpress-theme','glass-artifact'));
}
if ( ! defined( 'GLASS_ARTIFACT_SUPPORT_FREE' ) ) {
define('GLASS_ARTIFACT_SUPPORT_FREE',__('https://wordpress.org/support/theme/glass-artifact','glass-artifact'));
}
if ( ! defined( 'GLASS_ARTIFACT_REVIEW_FREE' ) ) {
define('GLASS_ARTIFACT_REVIEW_FREE',__('https://wordpress.org/support/theme/glass-artifact/reviews/#new-post','glass-artifact'));
}
if ( ! defined( 'GLASS_ARTIFACT_DEMO_PRO' ) ) {
define('GLASS_ARTIFACT_DEMO_PRO',__('https://demo.misbahwp.com/glass-artifact/','glass-artifact'));
}
if( ! defined( 'GLASS_ARTIFACT_THEME_LITE' ) ) {
define('GLASS_ARTIFACT_THEME_LITE',__('https://www.misbahwp.com/products/glass-artifact','glass-artifact'));
}
if( ! defined( 'GLASS_ARTIFACT_THEME_BUNDLE' ) ) {
define('GLASS_ARTIFACT_THEME_BUNDLE',__('https://www.misbahwp.com/products/wordpress-bundle','glass-artifact'));
}

function glass_artifact_test_guide() { ?>
	<?php $theme = wp_get_theme(); ?>

	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( GLASS_ARTIFACT_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'glass-artifact' ) ?></a>
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'glass-artifact' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( GLASS_ARTIFACT_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'glass-artifact' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( GLASS_ARTIFACT_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'glass-artifact' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','glass-artifact'); ?><?php echo esc_html( $theme ); ?>  <span><?php esc_html_e('Version: ', 'glass-artifact'); ?><?php echo esc_html($theme['Version']);?></span></h3>
				<div class="demo-import-box">
					<h4><?php echo esc_html__('Import homepage demo in just one click.','glass-artifact'); ?></h4>
					<p><?php echo esc_html__('Get started with the wordpress theme installation','glass-artifact'); ?></p>
					<a class="button button-primary import" href="themes.php?page=glassartifact-wizard"><?php echo esc_html__('ONE CLICK DEMO IMPORTER','glass-artifact'); ?></a>
				</div>
				<img class="img_responsive" style="width:100%;" src="<?php echo esc_url( get_template_directory_uri() ); ?>/screenshot.png">
				<div id="description-insidee">
					<?php
						$theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="postboxx donate volleyball-postboxx">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'glass-artifact' ); ?></h3>
				<div class="insidee">
				<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','glass-artifact'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( GLASS_ARTIFACT_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'glass-artifact' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( GLASS_ARTIFACT_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'glass-artifact' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( GLASS_ARTIFACT_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'glass-artifact' ) ?></a>
					</div>
				</div>

				<h3 class="hndle bundle"><?php esc_html_e( 'Get All Themes', 'glass-artifact' ); ?></h3>
				<div class="insidee theme-bundle">
					<img width="100%" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/bundle-image.png' ); ?>" alt="<?php esc_attr_e('logo', 'glass-artifact'); ?>">
					<p class="offer"><?php esc_html_e('Get 100+ Perfect WordPress Theme In A Single Package at just $89."','glass-artifact'); ?></p>
					<p class="coupon"><?php esc_html_e('Get Our Theme Pack of 100+ WordPress Themes At 15% Off','glass-artifact'); ?><span class="coupon-code"><?php esc_html_e('"Bundleup15"','glass-artifact'); ?></span></p>
				<div id="admin_pro_linkss">
					<a class="blue-button-1" href="<?php echo esc_url( GLASS_ARTIFACT_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Buy All Themes - $89', 'glass-artifact' ) ?></a>
				</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','glass-artifact'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','glass-artifact'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','glass-artifact'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','glass-artifact'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
	  		</div>
			</div>
		</div>
	</div>

<?php } ?>
