<?php

if ( ! defined( 'GLASS_ARTIFACT_BUY_NOW_1' ) ) {
define('GLASS_ARTIFACT_BUY_NOW_1',__('https://www.misbahwp.com/products/artifact-wordpress-theme','glass-artifact'));
}

if ( class_exists("Kirki")){

	// LOGO

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'glass_artifact_logo_resizer',
		'label'       => esc_html__( 'Adjust Your Logo Size ', 'glass-artifact' ),
		'section'     => 'title_tagline',
		'choices'     => [
			'min'  => 10,
			'max'  => 245,
			'step' => 5,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'glass-artifact' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'glass_artifact_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'glass-artifact' ),
		'section'     => 'title_tagline',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'glass-artifact' ),
			'off' => esc_html__( 'Disable', 'glass-artifact' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'glass_artifact_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'glass-artifact' ),
		'section'     => 'title_tagline',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'glass-artifact' ),
			'off' => esc_html__( 'Disable', 'glass-artifact' ),
		],
	] );

	// FONT STYLE TYPOGRAPHY

	Kirki::add_panel( 'glass_artifact_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Typography', 'glass-artifact' ),
	) );

	Kirki::add_section( 'glass_artifact_font_style_section', array(
		'title'      => esc_html__( 'Typography Option',  'glass-artifact' ),
		'priority'   => 2,
		'capability' => 'edit_theme_options',
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_font_style_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_all_headings_typography',
		'section'     => 'glass_artifact_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'glass-artifact' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'glass_artifact_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'glass-artifact' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'glass-artifact' ),
		'section'     => 'glass_artifact_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_body_content_typography',
		'section'     => 'glass_artifact_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'glass-artifact' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'glass_artifact_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'glass-artifact' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'glass-artifact' ),
		'section'     => 'glass_artifact_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

		// PANEL
	Kirki::add_panel( 'glass_artifact_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'glass-artifact' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'glass_artifact_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'glass-artifact' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_section_animation',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'glass_artifact_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'glass-artifact' ),
			'off' => esc_html__( 'Disable', 'glass-artifact' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'glass_artifact_panel_id_2', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Dark Mode', 'glass-artifact' ),
	) );

	// DARK MODE SECTION
	Kirki::add_section( 'glass_artifact_section_dark_mode', array(
	    'title'          => esc_html__( 'Dark Mode', 'glass-artifact' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_section_dark_mode',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'glass_artifact_dark_colors',
	    'section'     => 'glass_artifact_section_dark_mode',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dark Appearance', 'glass-artifact' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'glass_artifact_is_dark_mode_enabled',
		'label'       => esc_html__( 'Turn To Dark Mode', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_dark_mode',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'glass-artifact' ),
			'off' => esc_html__( 'Disable', 'glass-artifact' ),
		],
	] );


	// PANEL
	Kirki::add_panel( 'glass_artifact_panel_id_3', array(
	    'priority'    => 10,
	    'title'       => esc_html__( '404 Settings / No Result', 'glass-artifact' ),
	) );

	// 404 SECTION
	Kirki::add_section( 'glass_artifact_section_404', array(
		'panel'          => 'glass_artifact_panel_id_3',
	    'title'          => esc_html__( '404 Settings', 'glass-artifact' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_section_404',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'glass_artifact_404_heading',
	    'section'     => 'glass_artifact_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Heading', 'glass-artifact' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_404_page_title',
		'section'  => 'glass_artifact_section_404',
		'default'  => esc_html__('404 Not Found', 'glass-artifact'),
		'priority' => 10,
	] );

		Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'glass_artifact_404_text',
	    'section'     => 'glass_artifact_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Content', 'glass-artifact' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_404_page_content',
		'section'  => 'glass_artifact_section_404',
		'default'  => esc_html__('Sorry, no posts matched your criteria.', 'glass-artifact'),
		'priority' => 10,
	] );

	// NO Result
	Kirki::add_section( 'glass_artifact_no_result', array(
		'panel'          => 'glass_artifact_panel_id_3',
	    'title'          => esc_html__( 'No Result Page Settings', 'glass-artifact' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_no_result',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'glass_artifact_not_found_heading',
	    'section'     => 'glass_artifact_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Heading', 'glass-artifact' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_no_results_page_title',
		'section'  => 'glass_artifact_no_result',
		'default'  => esc_html__('404 Not Found', 'glass-artifact'),
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'glass_artifact_not_found_text',
	    'section'     => 'glass_artifact_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Content', 'glass-artifact' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_no_results_page_content',
		'section'  => 'glass_artifact_no_result',
		'default'  => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'glass-artifact'),
		'priority' => 10,
	] );


	// PANEL

	Kirki::add_panel( 'glass_artifact_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Options', 'glass-artifact' ),
	) );

	//COLOR SECTION

	Kirki::add_section( 'glass_artifact_section_color', array(
	    'title'          => esc_html__( 'Global Color', 'glass-artifact' ),
	    'panel'          => 'glass_artifact_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_section_color',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_global_colors',
		'section'     => 'glass_artifact_section_color',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Here you can change your theme color on one click.', 'glass-artifact' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'glass_artifact_first_color',
		'label'       => __( 'choose your First Color', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_color',
		'default'     => '#32BBE5',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'glass_artifact_second_color',
		'label'       => __( 'Choose Your Second Color', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_color',
		'default'     => '#000000',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'glass_artifact_third_color',
		'label'       => __( 'Choose Your Third Color', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_color',
		'default'     => '#FFFFFF',
	] );

	// Additional Settings

	Kirki::add_section( 'glass_artifact_additional_settings', array(
	    'title'          => esc_html__( 'Additional Settings', 'glass-artifact' ),
	    'panel'          => 'glass_artifact_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_additional_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'glass_artifact_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'glass-artifact' ),
		'section'     => 'glass_artifact_additional_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'glass_artifact_scroll_top_position',
		'label'       => esc_html__( 'Alignment for Scroll To Top', 'glass-artifact' ),
		'section'     => 'glass_artifact_additional_settings',
		'default'     => 'Right',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'glass-artifact' ),
			'Center' => esc_html__( 'Center', 'glass-artifact' ),
			'Right'  => esc_html__( 'Right', 'glass-artifact' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'dashicons',
		'settings' => 'glass_artifact_scroll_top_icon',
		'label'    => esc_html__( 'Select Appropriate Scroll Top Icon', 'glass-artifact' ),
		'section'  => 'glass_artifact_additional_settings',
		'default'  => 'dashicons dashicons-arrow-up-alt',
		'priority' => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'menu_text_transform_glass_artifact',
		'label'       => esc_html__( 'Menus Text Transform', 'glass-artifact' ),
		'section'     => 'glass_artifact_additional_settings',
		'default'     => 'CAPITALISE',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'CAPITALISE' => esc_html__( 'CAPITALISE', 'glass-artifact' ),
			'UPPERCASE' => esc_html__( 'UPPERCASE', 'glass-artifact' ),
			'LOWERCASE' => esc_html__( 'LOWERCASE', 'glass-artifact' ),

		],
	]
	);

	new \Kirki\Field\Select(
	[
		'settings'    => 'glass_artifact_menu_zoom',
		'label'       => esc_html__( 'Menu Transition', 'glass-artifact' ),
		'section'     => 'glass_artifact_additional_settings',
		'default' => 'None',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'None' => __('None','glass-artifact'),
            'Zoominn' => __('Zoom Inn','glass-artifact'),
            
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'glass_artifact_container_width',
		'label'       => esc_html__( 'Theme Container Width', 'glass-artifact' ),
		'section'     => 'glass_artifact_additional_settings',
		'default'     => 100,
		'choices'     => [
			'min'  => 50,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'glass_artifact_sticky_header',
		'label'       => esc_html__( 'Here you can enable or disable your Sticky Header.', 'glass-artifact' ),
		'section'     => 'glass_artifact_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'glass_artifact_site_loader',
		'label'       => esc_html__( 'Here you can enable or disable your Site Loader.', 'glass-artifact' ),
		'section'     => 'glass_artifact_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

		new \Kirki\Field\Select(
	[
		'settings'    => 'glass_artifact_preloader_type',
		'label'       => esc_html__( 'Preloader Type', 'glass-artifact' ),
		'section'     => 'glass_artifact_additional_settings',
		'default' => 'four-way-loader',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'four-way-loader' => __('Type 1','glass-artifact'),
            'cube-loader' => __('Type 2','glass-artifact'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'glass_artifact_page_layout',
		'label'       => esc_html__( 'Page Layout Setting', 'glass-artifact' ),
		'section'     => 'glass_artifact_additional_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','glass-artifact'),
            'Right Sidebar' => __('Right Sidebar','glass-artifact'),
            'One Column' => __('One Column','glass-artifact')
		],
	] );

	if ( class_exists("woocommerce")){

	// Woocommerce Settings

	Kirki::add_section( 'glass_artifact_woocommerce_settings', array(
			'title'          => esc_html__( 'Woocommerce Settings', 'glass-artifact' ),
			'panel'          => 'glass_artifact_panel_id',
			'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_woocommerce_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'glass_artifact_shop_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable shop page sidebar.', 'glass-artifact' ),
		'section'     => 'glass_artifact_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'glass_artifact_product_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable product page sidebar.', 'glass-artifact' ),
		'section'     => 'glass_artifact_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'glass_artifact_related_product_setting',
		'label'       => esc_html__( 'Here you can enable or disable your related products.', 'glass-artifact' ),
		'section'     => 'glass_artifact_woocommerce_settings',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Number(
	[
		'settings' => 'glass_artifact_per_columns',
		'label'    => esc_html__( 'Product Per Row', 'glass-artifact' ),
		'section'  => 'glass_artifact_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 4,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'glass_artifact_product_per_page',
		'label'    => esc_html__( 'Product Per Page', 'glass-artifact' ),
		'section'  => 'glass_artifact_woocommerce_settings',
		'default'  => 9,
		'choices'  => [
			'min'  => 1,
			'max'  => 15,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number_per_row',
		'label'    => esc_html__( 'Related Product Per Column', 'glass-artifact' ),
		'section'  => 'glass_artifact_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 4,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number',
		'label'    => esc_html__( 'Related Product Per Page', 'glass-artifact' ),
		'section'  => 'glass_artifact_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 10,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Select(
	[
		'settings'    => 'glass_artifact_shop_page_layout',
		'label'       => esc_html__( 'Shop Page Layout Setting', 'glass-artifact' ),
		'section'     => 'glass_artifact_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','glass-artifact'),
            'Right Sidebar' => __('Right Sidebar','glass-artifact')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'glass_artifact_product_page_layout',
		'label'       => esc_html__( 'Product Page Layout Setting', 'glass-artifact' ),
		'section'     => 'glass_artifact_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','glass-artifact'),
            'Right Sidebar' => __('Right Sidebar','glass-artifact')
		],
	] );

	
	new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'glass_artifact_woocommerce_pagination_position',
		'label'       => esc_html__( 'Woocommerce Pagination Alignment', 'glass-artifact' ),
		'section'     => 'glass_artifact_woocommerce_settings',
		'default'     => 'Center',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'glass-artifact' ),
			'Center' => esc_html__( 'Center', 'glass-artifact' ),
			'Right'  => esc_html__( 'Right', 'glass-artifact' ),
		],
	]
	);

}

	// POST SECTION

	Kirki::add_section( 'glass_artifact_section_post', array(
	    'title'          => esc_html__( 'Post Settings', 'glass-artifact' ),
	    'panel'          => 'glass_artifact_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_section_post',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	new \Kirki\Field\Sortable(
	[
		'settings' => 'glass_artifact_archive_element_sortable',
		'label'    => __( 'Archive Post Page Element Reordering', 'glass-artifact' ),
		'description'    => esc_html__( 'This setting is not favorable with post format.', 'glass-artifact' ),
		'section'  => 'glass_artifact_section_post',
		'default'  => [ 'option1', 'option2', 'option3', 'option4', 'option5' ],
		'choices'  => [
			'option1' => esc_html__( 'Post Image', 'glass-artifact' ),
			'option2' => esc_html__( 'Post Meta', 'glass-artifact' ),
			'option3' => esc_html__( 'Post Title', 'glass-artifact' ),
			'option4' => esc_html__( 'Post Content', 'glass-artifact' ),
			'option5' => esc_html__( 'Post Button', 'glass-artifact' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'glass_artifact_post_excerpt_number_1',
		'label'       => esc_html__( 'Post Content Range', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_post',
		'default'     => 15,
		'choices'     => [
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'glass_artifact_pagination_setting',
		'label'       => esc_html__( 'Here you can enable or disable your Pagination.', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_post',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'glass_artifact_archive_sidebar_layout',
		'label'       => esc_html__( 'Archive Post Sidebar Layout Setting', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','glass-artifact'),
            'Right Sidebar' => __('Right Sidebar','glass-artifact'),
            'Three Column' => __('Three Column','glass-artifact'),
            'Four Column' => __('Four Column','glass-artifact'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','glass-artifact'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','glass-artifact'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','glass-artifact')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'glass_artifact_single_post_sidebar_layout',
		'label'       => esc_html__( 'Single Post Sidebar Layout Setting', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','glass-artifact'),
            'Right Sidebar' => __('Right Sidebar','glass-artifact'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'glass_artifact_search_sidebar_layout',
		'label'       => esc_html__( 'Search Page Sidebar Layout Setting', 'glass-artifact' ),
		'section'     => 'glass_artifact_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','glass-artifact'),
            'Right Sidebar' => __('Right Sidebar','glass-artifact'),
            'Three Column' => __('Three Column','glass-artifact'),
            'Four Column' => __('Four Column','glass-artifact'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','glass-artifact'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','glass-artifact'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','glass-artifact')
		],
	] );

		// Breadcrumb
	Kirki::add_section( 'glass_artifact_bradcrumb', array(
	    'title'          => esc_html__( 'Breadcrumb Settings', 'glass-artifact' ),
	    'panel'          => 'glass_artifact_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_bradcrumb',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	 Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_enable_breadcrumb_heading',
		'section'     => 'glass_artifact_bradcrumb',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Single Page Breadcrumb', 'glass-artifact' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'glass_artifact_breadcrumb_enable',
		'label'       => esc_html__( 'Breadcrumb Enable / Disable', 'glass-artifact' ),
		'section'     => 'glass_artifact_bradcrumb',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'glass-artifact' ),
			'off' => esc_html__( 'Disable', 'glass-artifact' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'default'     => '/',
        'settings' => 'glass_artifact_breadcrumb_separator' ,
        'label'    => esc_html__( 'Breadcrumb Separator',  'glass-artifact' ),
        'section'  => 'glass_artifact_bradcrumb',
    ] );

	// HEADER SECTION

	Kirki::add_section( 'glass_artifact_section_header', array(
	    'title'          => esc_html__( 'Header Settings', 'glass-artifact' ),
	    'panel'          => 'glass_artifact_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_section_header',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_header_sign_button_heading',
		'section'     => 'glass_artifact_section_header',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Button', 'glass-artifact' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Header Button Text 1', 'glass-artifact' ),
		'settings' => 'glass_artifact_sign_up_text',
		'section'  => 'glass_artifact_section_header',
		'default'  => '',
		'priority' => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'url',
		'label'       => esc_html__( 'Header Button URL 1', 'glass-artifact' ),
		'settings' => 'glass_artifact_sign_up_url',
		'section'  => 'glass_artifact_section_header',
		'default'  => '',
		'priority' => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Header Button Text 2', 'glass-artifact' ),
		'settings' => 'glass_artifact_sign_in_text',
		'section'  => 'glass_artifact_section_header',
		'default'  => '',
		'priority' => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'url',
		'label'       => esc_html__( 'Header Button URL 2', 'glass-artifact' ),
		'settings' => 'glass_artifact_sign_in_url',
		'section'  => 'glass_artifact_section_header',
		'default'  => '',
		'priority' => 10,
	] );	

	// SLIDER SECTION

	Kirki::add_section( 'glass_artifact_blog_slide_section', array(
        'title'          => esc_html__( ' Banner Settings', 'glass-artifact' ),
        'panel'          => 'glass_artifact_panel_id',
        'priority'       => 160,
    ) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_blog_slide_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_enable_heading',
		'section'     => 'glass_artifact_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Banner', 'glass-artifact' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'glass_artifact_blog_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'glass-artifact' ),
		'section'     => 'glass_artifact_blog_slide_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'glass-artifact' ),
			'off' => esc_html__( 'Disable', 'glass-artifact' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_slider_heading',
		'section'     => 'glass_artifact_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Slider', 'glass-artifact' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_banner_main_heading',
		'label'    => esc_html__( 'Banner Main Heading', 'glass-artifact' ),
		'section'  => 'glass_artifact_blog_slide_section',
		'priority' => 10,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_banner_main_content',
		'label'    => esc_html__( 'Banner Main Content', 'glass-artifact' ),
		'section'  => 'glass_artifact_blog_slide_section',
		'priority' => 10,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'dashicons',
		'settings' => 'glass_artifact_slider_list_icon',
		'label'    => esc_html__( 'Select List Icon ', 'glass-artifact' ),
		'section'  => 'glass_artifact_blog_slide_section',
		'default'  => 'dashicons dashicons-admin-users',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_banner_list_box_content_1',
		'label'    => esc_html__( 'List Content 1', 'glass-artifact' ),
		'section'  => 'glass_artifact_blog_slide_section',
		'priority' => 10,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_banner_list_box_content_2',
		'label'    => esc_html__( 'List Content 2', 'glass-artifact' ),
		'section'  => 'glass_artifact_blog_slide_section',
		'priority' => 10,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_banner_list_box_content_3',
		'label'    => esc_html__( 'List Content 3', 'glass-artifact' ),
		'section'  => 'glass_artifact_blog_slide_section',
		'priority' => 10,
    ] );

    new \Kirki\Field\Image(
		[
			'settings'    => 'glass_artifact_banner_list_image',
			'label'       => esc_html__( 'Upload List Image ', 'glass-artifact' ),
			'section'     => 'glass_artifact_blog_slide_section',
			'default'     => '',
			'priority'    => 10,
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'label'    => esc_html__( 'Form Shortcode',  'glass-artifact' ),
		'type'     => 'text',
		'description' => esc_html__( 'Copy the shortcode from Contact form plugin and past it here and publish then refresh in front your form will show', 'glass-artifact' ),
		'settings' => 'glass_artifact_contact_form_shortcode',
		'section'  => 'glass_artifact_blog_slide_section',
    ] );

    new \Kirki\Field\Image(
		[
			'settings'    => 'glass_artifact_banner_main_image',
			'label'       => esc_html__( 'Upload Banner Image ', 'glass-artifact' ),
			'section'     => 'glass_artifact_blog_slide_section',
			'default'     => '',
			'priority'    => 10,
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_slider_section_exprience_number',
		'label'    => esc_html__( 'Year Of Exprience', 'glass-artifact' ),
		'section'  => 'glass_artifact_blog_slide_section',
		'priority' => 10,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_slider_section_exprience_text',
		'label'    => esc_html__( 'Exprience Text', 'glass-artifact' ),
		'section'  => 'glass_artifact_blog_slide_section',
		'priority' => 10,
    ] );

	// OUR PRODUCTS SECTION

	Kirki::add_section( 'glass_artifact_products_section', array(
        'title'          => esc_html__( 'About Us Settings', 'glass-artifact' ),
        'panel'          => 'glass_artifact_panel_id',
        'priority'       => 160,
    ) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_products_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_products_section_enable_heading',
		'section'     => 'glass_artifact_products_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable About Us Section', 'glass-artifact' ) . '</h3>',
		'priority'    => 1,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'glass_artifact_products_section_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'glass-artifact' ),
		'section'     => 'glass_artifact_products_section',
		'default'     => '0',
		'priority'    => 2,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'glass-artifact' ),
			'off' => esc_html__( 'Disable', 'glass-artifact' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_products_heading',
		'section'     => 'glass_artifact_products_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'About Us Headings',  'glass-artifact' ) . '</h3>',
		'priority'    => 3,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_products_main_heading',
		'label'    => esc_html__( 'Main Heading', 'glass-artifact' ),
		'section'  => 'glass_artifact_products_section',
		'priority' => 5,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_products_main_content',
		'label'    => esc_html__( 'Main Content', 'glass-artifact' ),
		'section'  => 'glass_artifact_products_section',
		'priority' => 5,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_our_product_heading',
		'section'     => 'glass_artifact_products_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'About Us', 'glass-artifact' ) . '</h3>',
		'priority'    => 7,
	] );

	new \Kirki\Field\Image(
		[
			'settings'    => 'glass_artifact_about_us_left_image_1',
			'label'       => esc_html__( 'Upload About Image 1', 'glass-artifact' ),
			'section'     => 'glass_artifact_products_section',
			'default'     => '',
			'priority'    => 8,
		]
	);

	new \Kirki\Field\Image(
		[
			'settings'    => 'glass_artifact_about_us_left_image_2',
			'label'       => esc_html__( 'Upload About Image 2', 'glass-artifact' ),
			'section'     => 'glass_artifact_products_section',
			'default'     => '',
			'priority'    => 8,
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_slider_section_price_heading',
		'label'    => esc_html__( 'Year Of Exprience', 'glass-artifact' ),
		'section'  => 'glass_artifact_products_section',
		'priority' => 9,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_slider_section_price_text',
		'label'    => esc_html__( 'Exprience Text', 'glass-artifact' ),
		'section'  => 'glass_artifact_products_section',
		'priority' => 9,
    ] );

	for ($i=1; $i <=4 ; $i++) {

		Kirki::add_field( 'theme_config_id', [
			'type'     => 'dashicons',
			'settings' => 'glass_artifact_top_categories_icon' .$i,
			'label'    => esc_html__( 'Select Achivenment Icon ', 'glass-artifact' ) .$i,
			'section'  => 'glass_artifact_products_section',
			'default'  => 'dashicons dashicons-admin-users',
			'priority'    => 9,
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'     => 'text',
			'settings' => 'glass_artifact_products_about_section_achivement_heading' .$i,
			'label'    => esc_html__( 'Achivenment Heading ', 'glass-artifact' ) .$i,
			'section'  => 'glass_artifact_products_section',
			'priority'    => 9,
	    ] );

	    Kirki::add_field( 'theme_config_id', [
			'type'     => 'text',
			'settings' => 'glass_artifact_products_about_section_achivement_content' .$i,
			'label'    => esc_html__( 'Achivenment Content ', 'glass-artifact' ) .$i,
			'section'  => 'glass_artifact_products_section',
			'priority'    => 9,
	    ] );
	}

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_about_us_button_text',
		'label'    => esc_html__( 'Button Text', 'glass-artifact' ),
		'section'  => 'glass_artifact_products_section',
		'priority' => 10,
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'url',
		'settings' => 'glass_artifact_about_us_button_url',
		'label'    => esc_html__( 'Button URL', 'glass-artifact' ),
		'section'  => 'glass_artifact_products_section',
		'priority' => 10,
    ] );

	// FOOTER SECTION

	Kirki::add_section( 'glass_artifact_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'glass-artifact' ),
        'panel'          => 'glass_artifact_panel_id',
        'priority'       => 160,
    ) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'glass-artifact' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( GLASS_ARTIFACT_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'glass-artifact' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'glass_artifact_footer_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'glass-artifact' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_footer_text_heading',
		'section'     => 'glass_artifact_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'glass-artifact' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'glass_artifact_footer_text',
		'section'  => 'glass_artifact_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'glass_artifact_footer_text_heading_2',
	'section'     => 'glass_artifact_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Alignment', 'glass-artifact' ) . '</h3>',
	'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'glass_artifact_copyright_text_alignment',
		'label'       => esc_html__( 'Copyright text Alignment', 'glass-artifact' ),
		'section'     => 'glass_artifact_footer_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'glass-artifact' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'glass-artifact' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'glass-artifact' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'glass-artifact' ),

		],
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'glass_artifact_footer_text_heading_1',
	'section'     => 'glass_artifact_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Background Color', 'glass-artifact' ) . '</h3>',
	'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'glass_artifact_copyright_bg',
		'label'       => __( 'Choose Your Copyright Background Color', 'glass-artifact' ),
		'section'     => 'glass_artifact_footer_section',
		'default'     => '#000000',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'glass_artifact_enable_footer_socail_link',
		'section'     => 'glass_artifact_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'glass-artifact' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'glass_artifact_footer_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icon', 'glass-artifact' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'glass-artifact' ),
		'settings'     => 'glass_artifact_footer_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'glass-artifact' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'glass-artifact' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'glass-artifact' ),
				'description' => esc_html__( 'Add the social icon url here.', 'glass-artifact' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );

}