<?php
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Glass_Artifact_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	*/
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/core/includes/upgrade-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Glass_Artifact_Customize_Section_Pro' );

		// Add the PRO Upgrade section.
		$manager->add_section(
		    new Glass_Artifact_Customize_Section_Pro(
		        $manager,
		        'glass_artifact_upgrade_pro',
		        array(
		            'title'         => esc_html__( 'Glass Artifact PRO', 'glass-artifact' ),
		            'pro_text'      => esc_html__( 'Glass Artifact PRO', 'glass-artifact' ),
		            'pro_url'       => esc_url( GLASS_ARTIFACT_BUY_NOW ),
		            'demo_text'     => esc_html__( 'Demo', 'glass-artifact' ),
		            'demo_url'      => esc_url( GLASS_ARTIFACT_DEMO_PRO ),
		            'support_text'  => esc_html__( 'Support', 'glass-artifact' ),
		            'support_url'   => esc_url( GLASS_ARTIFACT_SUPPORT_FREE ),
		            'bundle_text'   => esc_html__( 'Get All Themes', 'glass-artifact' ),
		            'bundle_url'    => esc_url( GLASS_ARTIFACT_THEME_BUNDLE ),
		            'lite_doc_text' => esc_html__( 'Lite Doc', 'glass-artifact' ),
		            'lite_doc_url'  => esc_url( GLASS_ARTIFACT_DOCS_FREE ),
		            'review_text'   => esc_html__( 'Review', 'glass-artifact' ),
		            'review_url'    => esc_url( GLASS_ARTIFACT_REVIEW_FREE ),
		            'priority'      => 1,
		        )
		    )
		);

	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script(
			'glass-artifact-customize-controls',
			trailingslashit( get_template_directory_uri() ) . '/js/customize-controls.js',
			array( 'customize-controls' )
		);

		wp_enqueue_style(
			'glass-artifact-customize-controls',
			trailingslashit( get_template_directory_uri() ) . '/css/customize-controls.css'
		);
	}
}

// Doing this customizer thang!
Glass_Artifact_Customize::get_instance();
