<?php

if ( giornale_setting('giornale_enable_recommended_posts', true) == true ) :

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => 6 ,
        'ignore_sticky_posts' => true,
        'orderby' => giornale_setting('giornale_recommended_posts_orderby', 'date'),
        'order' => giornale_setting('giornale_recommended_posts_sort_order', 'desc'),
    );
    
    if ( is_numeric(giornale_setting('giornale_recommended_posts_category')) ) :
        $args['cat'] = giornale_setting('giornale_recommended_posts_category');
    endif;

    $recommended_posts = new WP_Query($args);
    $recommended_posts_enabled = giornale_setting('giornale_enable_recommended_posts_only_first_page_pagination', true);

    if (
        $recommended_posts->have_posts() &&
        (
            (
                $recommended_posts_enabled == true && 
                get_query_var('paged') <= 1
            ) ||
            $recommended_posts_enabled == false
        )

    ) :

        $recommended_posts_style = giornale_setting('giornale_recommended_posts_style', 'light');

    ?>

        <section class="recommended-posts-wrapper <?php echo esc_attr($recommended_posts_style);?>_style">

            <div id="recommended-posts-inner" class="container">

                <?php if ( giornale_setting('giornale_enable_recommended_posts_section_title', true) == true ) : ?>
                    
                    <h2 class="recommended-articles-section-title section-title-underlined"><?php echo esc_html(giornale_setting('giornale_recommended_posts_section_title', __( 'Recommended Posts', 'giornale' ))) ;?></h2>

                <?php endif; ?>

                <div class="row">

                    <div class="col-md-12">

                        <div class="recommended-posts-container <?php echo esc_attr(giornale_setting('giornale_recommended_posts_layout','layout-1'));?>">

                            <div class="recommended-posts-item">

                              <?php

                                  while ( $recommended_posts->have_posts() ) : $recommended_posts->the_post();

                                      global $post;

                                      $post_count = $recommended_posts->current_post;

                                      $thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large');
                                      $recommendedPostsStyle = (isset($thumb[0])) ? 'style="background-image: url(' . esc_url($thumb[0]) . ')"' : '';

                              ?>

                                      <div class="recommended-post recommended-post-<?php echo esc_attr($post_count);?>" <?php echo $recommendedPostsStyle;?> >

                                          <a title="<?php echo esc_attr(get_the_title());?>" class="recommended-post-permalink" href="<?php echo esc_url(get_permalink($post->ID)); ?>" ></a>

                                          <div class="recommended-post-info">
                                              <h3 class="title"><?php echo esc_html(get_the_title()); ?></h3>
                                              <span><?php echo esc_html(get_the_date(false, $post->ID)); ?></span>
                                          </div>

                                      </div>


                              <?php

                                  endwhile;
                                  wp_reset_postdata();

                              ?>
                            
                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </section>

    <?php

    endif;
    wp_reset_postdata();

endif;

?>