<?php

if ( giornale_setting('giornale_enable_recent_posts', true) == true ) :

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => 4,
        'ignore_sticky_posts' => true,
    );

    $recent_posts = new WP_Query($args);
    $recent_posts_enabled = giornale_setting('giornale_enable_recent_posts_only_first_page_pagination', true);

    if (
        $recent_posts->have_posts() &&
        (
            (
                $recent_posts_enabled == true && 
                get_query_var('paged') <= 1
            ) ||
            $recent_posts_enabled == false
        )

    ) :

?>

    <section class="recent-posts-section">

        <div class="container">

            <div class="row">
                
                <div class="col-md-12">
                    
                    <div class="recent-posts-inner">

                        <?php

                            while ($recent_posts->have_posts()) : $recent_posts->the_post();
                                
                                global $post;

                                $post_count = $recent_posts->current_post + 1;

                                if ($post_count == 1) :

                        ?>

                                    <div class="recent-posts-left-column">
                                    
                                        <article>

                                            <h3><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                            <p class="post-summary">
                                                <?php echo giornale_recent_post_more_tag(get_the_ID()); ?>
                                            </p>
                                            <p class="recent-post-author"><?php echo esc_html(giornale_setting('giornale_recent_posts_post_author_label', __( 'By', 'giornale' ))) . '&nbsp;' . get_the_author_posts_link(); ?></p>
                                        
                                        </article>

                                        <div class="recent-post-image">

                                            <?php
                                                if ('' != get_the_post_thumbnail() ) : 
                                                    the_post_thumbnail('giornale_recent_post_image');
                                                else :
                                                    $thumbnailIMG = get_stylesheet_directory_uri() . '/assets/images/placeholder-650x450.jpg';
                                                    echo '<img src="' . esc_url($thumbnailIMG) . '" alt="' . esc_attr(get_the_title()) . '">';
                                                endif;
                                            ?>

                                        </div>

                                    </div>

                                    <div class="recent-posts-right-column">

                        <?php

                                endif;

                                if (
                                    $post_count > 1 && 
                                    $post_count <= 4
                                ) :

                        ?>

                                    <article>
                                        <h4><a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_the_title()); ?></a></h4>
                                        <p class="recent-post-author"><?php echo esc_html(giornale_setting('giornale_recent_posts_post_author_label', __( 'By', 'giornale' ))) . '&nbsp;' . get_the_author_posts_link(); ?></p>
                                    </article>

                        <?php 

                                endif;

                            endwhile;
                            wp_reset_postdata();
                
                        ?>

                        <!-- close recent-posts-right-column div -->
                        </div>

                    </div>

                </div>

            </div>
            
        </div>

    </section>

<?php

    endif; 

endif;

?>