<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php

if ( function_exists('wp_body_open') ) {
	wp_body_open();
}

?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'giornale' ); ?></a>

<?php get_template_part('template-parts/scroll','sidebar'); ?>

<div id="wrapper">

    <?php if (giornale_setting('giornale_enable_newsticker_section', true) == true ) : ?>

        <div class="newsticker-wrapper">

            <div class="container">
                
                <div class="row">
                    
                    <div class="col-md-12">
                    
                        <?php echo giornale_get_newsticker(); ?>
                    
                    </div>
                
                </div>
            
            </div>

        </div>

    <?php endif; ?>

    <header id="header-wrapper">

        <?php if ( giornale_setting('giornale_enable_topbar_section', true) == true ) : ?>

            <div id="topbar-section">

                <div class="container">

                    <div class="row">

                        <div class="col-md-12">

                            <div class="topbar-left-column">

                                <?php echo esc_html(giornale_get_current_date()); ?>

                            </div>

                            <?php

                                echo giornale_get_topbar_right_column();
                                    
                            ?>
                        
                        </div>

                    </div>

                </div>

            </div>

        <?php endif;?>

        <div id="header">

            <div class="container">

                <div class="row hd-flex">

                    <div class="col-md-4" >

                        <div id="logo">

                            <?php

                                if ( function_exists( 'the_custom_logo' ) && get_theme_mod( 'custom_logo' ) ) {

                                    the_custom_logo();

                                } else {

                                    echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';

                                        echo esc_html(get_bloginfo('name'));

                                        if ( get_theme_mod('giornale_hide_tagline', true) == false) :
                                            
                                            echo '<span>'. esc_html(get_bloginfo('description')) . '</span>';

                                        endif;

                                    echo '</a>';

                                }

                            ?>

                        </div>

                    </div>

                    <?php get_sidebar('banner'); ?>

                </div>

            </div>

        </div>

        <div id="topbar-wrapper">
    
            <div class="container">

                <div class="row">

                    <div id="primary-menu-wrapper" class="col-md-12" >

                        <a class="open-modal-sidebar" href="#modal-sidebar"><i class="fa fa-bars"></i></a>

                        <button class="menu-toggle" aria-controls="mainmenu" aria-expanded="false" type="button">
                            <span aria-hidden="true"><?php esc_html_e( 'Menu', 'giornale' ); ?></span>
                            <span class="dashicons" aria-hidden="true"></span>
                        </button>

                        <nav id="primary-menu" class="header-menu" >

                            <?php

                                wp_nav_menu( array(
                                    'theme_location' => 'main-menu',
                                    'container' => 'false'
                                ));

                            ?>

                        </nav>

                        <?php 
                                            
                            if ( 
                                giornale_is_woocommerce_active() && 
                                giornale_setting('giornale_enable_woocommerce_header_cart', true) == true
                            ) :
                                                        
                                echo giornale_header_cart();
                                                    
                            endif;
                                                
                        ?>

                    </div>

                </div>

            </div>

        </div>

        <?php if (giornale_setting('giornale_enable_newsticker_section2', false) == true ) : ?>

            <div class="newsticker-wrapper">

                <div class="container">
                    
                    <div class="row">
                        
                        <div class="col-md-12">
                        
                            <?php echo giornale_get_newsticker(); ?>
                        
                        </div>
                    
                    </div>
                
                </div>

            </div>

        <?php endif; ?>

    </header>