<?php

/**
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if (!function_exists('giornale_top_section_function')) {

	function giornale_top_section_function( $page = false ) {

		if(
		
			(
				$page == 'archive' &&
				giornale_setting('giornale_enable_category_title', true) == true
			) ||
		
			(
				$page == 'search' &&
				giornale_setting('giornale_enable_searched_item', true) == true 
			) ||
		
			(
				$page == 'home' &&
				giornale_setting('giornale_enable_homepage_label', true) == true &&
                (
                    (
                        giornale_setting('giornale_enable_homepage_label_only_first_page_pagination', true) == true && 
                        get_query_var('paged') <= 1
                    ) ||
                    giornale_setting('giornale_enable_homepage_label_only_first_page_pagination', true) == false
                )
			) 
		
		) :
			
	?>
		
            <section class="top-section-wrapper">
            
                <div id="top-section-inner">
                        
                    <?php 

                        if ( $page == 'archive' ) : 
                    
                    ?>
                    
                            <h1 class="archive-title section-title-underlined"><?php echo giornale_get_archive_title(); ?></h1>
                    
                    <?php 
                        
                        endif;

                        if ( $page == 'search' ) : 
                    
                    ?>
                    
                            <h1 class="search-result-title section-title-underlined"><?php esc_html_e( 'You searched: ', 'giornale' ) ?><strong><?php echo get_search_query(); ?> </strong></h1>
                    
                    <?php 
                        
                        endif;

                        if ( $page == 'home' ) : 
                    
                    ?>
                            
                            <h3 class="homepage-title section-title-underlined"><?php echo esc_html(giornale_setting('giornale_custom_homepage_label', __( 'Don\'t miss...', 'giornale' ))); ?></h3>

                    <?php 
                        
                        endif;
    
                    ?>        
        
                </div>        
                        
            </section>

	<?php 
	
		endif;
	
	}

	add_action( 'giornale_top_section', 'giornale_top_section_function', 10, 1);

}

?>