<?php

/**
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

/*-----------------------------------------------------------------------------------*/
/* Socials icons */
/*-----------------------------------------------------------------------------------*/ 

if (!function_exists('giornale_get_social_icons')) {

	function giornale_get_social_icons() {

		$allowed = array(

			'div' => array(
				'class' => array(),
			),
			'a' => array(
				'href' => array(),
				'title' => array(),
				'class' => array(),
				'button-title' => array(),
				'target' => array()
			),
			'i' => array(
				'class' => array(),
			)

		);

		$socials = array ( 
			
			"facebook" => array( "icon" => "fa fa-facebook" , "target" => "_blank"),
			"x" => array( "icon" => "tip-social-icons icon-twitter-x" , "target" => "_blank"),
			"tiktok" => array( "icon" => "tip-social-icons icon-tiktok" , "target" => "_blank"),
			"matrix" => array( "icon" => "tip-social-icons icon-matrix" , "target" => "_blank"),
			"flickr" => array( "icon" => "fa fa-flickr" , "target" => "_blank"),
			"slack" => array( "icon" => "fa fa-slack" , "target" => "_blank"),
			"pinterest" => array( "icon" => "fa fa-pinterest" , "target" => "_blank"),
			"tumblr" => array( "icon" => "fa fa-tumblr" , "target" => "_blank"),
			"soundcloud" => array( "icon" => "fa fa-soundcloud" , "target" => "_blank"),
			"spotify" => array( "icon" => "fa fa-spotify" , "target" => "_blank"),
			"youtube" => array( "icon" => "fa fa-youtube" , "target" => "_blank"),
			"vimeo" => array( "icon" => "fa fa-vimeo" , "target" => "_blank"),
			"vk" => array( "icon" => "fa fa-vk" , "target" => "_blank"),
			"instagram" => array( "icon" => "fa fa-instagram" , "target" => "_blank"),

		);

		$check = 0;
		
		$html = '<div class="social-buttons">';

		for ($i = 1; $i <= 4; $i++) {

			if (
				giornale_setting('giornale_social_link_icon_' . $i) &&
				giornale_setting('giornale_social_link_icon_' . $i) <> 'none'
			) : 
			
				$check++;	
 				
				$icon = giornale_setting('giornale_social_link_icon_' . $i);	
				$url = giornale_setting('giornale_social_link_url_' . $i);	
 
				$html .= '<a href="' . esc_url( $url, array( 'http', 'https')) . '"';
				$html .= ' target="' . $socials[$icon]['target'] . '" ';
				$html .= ' title="' . $icon . '" ';
				$html .= ' button-title="' . ucwords($icon) . '" ';
				$html .= ' class="social social_link_' . $i . '" >';
				$html .= ' <i class="' . $socials[$icon]['icon'] . '" ></i>';
				$html .= ' </a>';

			endif;

		}

		if ( giornale_setting('giornale_footer_rss_button') == true ): 
		
			$check++;	
			$html .= '<a href="'. esc_url(get_bloginfo('rss2_url')). '" title="Rss" button-title="Rss" class="social rss"><i class="fa fa-rss" ></i></a> ';
		
		endif; 

		$html .= '</div>';

		if ( $check > 0 ) {
			
			return wp_kses($html, $allowed);
	
		} else {

			return false;
		
		}

	}
	
}

?>