<?php 

/**
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if (!function_exists('giornale_masonry_function')) {
	
	function giornale_masonry_function($type) { 
	
		if ( have_posts() ) :
	
	?>
        
			<div class="row masonry" id="masonry">
                    
                <?php while ( have_posts() ) : the_post(); ?>
               
                    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                
                        <?php do_action('giornale_postformat'); ?>
                
                    </div>

                <?php endwhile; ?>

			</div>
	
	<?php 
	
		else:

		$additional = ($type == 'search') ? 'not-found' : '';
	
	?>

			<div class="row">

                <div class="post-container col-md-12">
            
                    <article class="post-article <?php echo esc_attr($additional);?>">
                            
                        <h1><?php esc_html_e( 'Not found.', 'giornale' );?></h1>
                        <p><?php esc_html_e( 'Sorry, no items found, in this section.', 'giornale' ) ?></p>
             
                    </article>
            
				</div>
        	
			</div>

	<?php 
	
		endif;
	
	} 

	add_action( 'giornale_masonry', 'giornale_masonry_function');

} 

?>