<?php 

/**
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if (!function_exists('giornale_before_content_function')) {

	function giornale_before_content_function( $type = "post" ) {
		
		if ( 
			$type == 'post' && 
			( 
				giornale_setting('giornale_enable_post_author', true) || 
				giornale_setting('giornale_enable_post_date', true)
			)
		) :

			echo '<div class="post-meta">';

				if ( giornale_setting('giornale_enable_post_author', true) == true ) :
					
					echo '<span class="post-meta-author">';

						echo esc_html(giornale_setting('giornale_post_author_label', __( 'Written by', 'giornale' )));
						echo '&nbsp;';
						echo get_the_author_posts_link();

					echo '</span>';

				endif;

				if ( giornale_setting('giornale_enable_post_date', true) == true ) :
					
					echo '<span class="post-meta-date">';

						echo get_the_date();

					echo '</span>';

				endif;

			echo '</div>';

		endif;
		
		if ( ! giornale_is_single() ) {

			do_action('giornale_get_title', 'blog' ); 

		} else {

			if ( !giornale_is_woocommerce_active('is_cart') ) :
	
				if ( giornale_is_single() && !is_page_template() ) :
							 
					do_action('giornale_get_title', 'single');
							
				else :
					
					do_action('giornale_get_title', 'blog'); 
							 
				endif;
	
			endif;

		}

		if ( $type == 'post' ) :

			echo '<div class="post-meta">';

				if ( giornale_setting('giornale_enable_post_category', true ) == true ) :
					
					echo '<span class="post-meta-category">'; 

						the_category(' . '); 
					
					echo '</span>';
				
				endif;

				if ( giornale_setting('giornale_enable_post_icon', true ) == true ) :

					echo '<span class="post-meta-icon">'; 

						echo giornale_posticon();
					
					echo '</span>';
					
				endif;

			echo '</div>';

		endif;

	} 
	
	add_action( 'giornale_before_content', 'giornale_before_content_function' );

}

?>