<?php 

/**
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * It is also available at this URL: http://www.gnu.org/licenses/gpl-3.0.txt
 */

if (!function_exists('giornale_scroll_sidebar_function')) {

	function giornale_scroll_sidebar_function() { 
	
		if ( is_active_sidebar('giornale-scroll-widget-area')) { 
			
			dynamic_sidebar('giornale-scroll-widget-area');
			
		} else { 
					
			the_widget( 'WP_Widget_Archives','',
			array(	'before_widget' => '<div class="post-article widget_archive">',
					'after_widget'  => '</div>',
					'before_title'  => '<div class="title-container"><h3 class="title">',
					'after_title'   => '</h3></div>'
			));

			the_widget( 'WP_Widget_Calendar',
			array(	'title'=> esc_html__('Calendar','giornale')),
			array(	'before_widget' => '<div class="post-article widget_calendar">',
					'after_widget'  => '</div>',
					'before_title'  => '<div class="title-container"><h3 class="title">',
					'after_title'   => '</h3></div>'
			));

			the_widget( 'WP_Widget_Categories','',
			array(	'before_widget' => '<div class="post-article widget_categories">',
					'after_widget'  => '</div>',
					'before_title'  => '<div class="title-container"><h3 class="title">',
					'after_title'   => '</h3></div>'
			));
			
		} 
			 
	}

	add_action( 'giornale_scroll_sidebar', 'giornale_scroll_sidebar_function' );

}

?>