<?php

/**
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly

if( !class_exists( 'giornale_admin_notice' ) ) {

	class giornale_admin_notice {
	
		/**
		 * Constructor
		 */
		 
		public function __construct( $fields = array() ) {

			if ( 
				!get_option( 'giornale-dismissed-notice') &&
				version_compare( PHP_VERSION, GIORNALE_MIN_PHP_VERSION, '>=' )
			) {

				add_action( 'admin_notices', array(&$this, 'admin_notice') );
				add_action( 'admin_head', array( $this, 'dismiss' ) );
				add_action( 'admin_init', array(&$this, 'add_script') ,11);

            }

		}
        
		 /**
		 * Loads the notice style
		 */

		public function add_script() {

			global $wp_version;

			$file_dir = get_template_directory_uri() . '/core/admin/assets/';
			wp_enqueue_style ( 'giornale-notice', $file_dir.'css/notice.css' );

		}
        
        
        /**
		 * Dismiss notice.
		 */
		
		public function dismiss() {

			if ( isset( $_GET['giornale-dismiss'] ) && check_admin_referer( 'giornale-dismiss-action' ) ) {
		
				update_option( 'giornale-dismissed-notice', intval($_GET['giornale-dismiss']) );
				remove_action( 'admin_notices', array(&$this, 'admin_notice') );
				
			} 
		
		}

		/**
		 * Admin notice.
		 */
		 
		public function admin_notice() {
			
		?>
			
            <div class="notice notice-warning is-dismissible">
                
            	<p>
            
            		<strong>

                        <?php esc_html_e( 'Unlock all premium features of Giornale theme like...', 'giornale' );  ?>
                    
                    </strong>
                
                </p>
                
                <p class="notice-coupon-message">

					<span class="dashicon dashicons dashicons-yes-alt" size="10"></span><?php esc_html_e( '600+ Google Fonts', 'giornale' ); ?><br/>
					<span class="dashicon dashicons dashicons-yes-alt" size="10"></span><?php esc_html_e( '14 additional social sharing icons (such as WhatsApp, Twitch, Yelp, Email or LinkedIn)', 'giornale' ); ?><br/>
					<span class="dashicon dashicons dashicons-yes-alt" size="10"></span><?php esc_html_e( '6 additional social buttons', 'giornale' ); ?><br/>
					<span class="dashicon dashicons dashicons-yes-alt" size="10"></span><?php esc_html_e( 'Unlimited widget areas', 'giornale' ); ?><br/>
					<span class="dashicon dashicons dashicons-yes-alt" size="10"></span><?php esc_html_e( 'Portfolio section', 'giornale' ); ?><br/>
                
                </p>

            	<p>
					<strong>
						<?php esc_html_e( 'Get the premium version of Giornale or choose the Plus plan to use Giornale as a starter theme for your website', 'giornale' ); ?>
					</strong><br/>
					<strong><?php esc_html_e( 'You can also select a bundle of 19 WordPress themes', 'giornale' ); ?></strong>
                </p>

				<p>

					<a href="<?php echo esc_url(admin_url( 'themes.php?page=giornale-welcome-page&section=free_pro' )); ?>" class="button"><?php esc_html_e( 'Free vs Pro', 'giornale' ); ?></a>

					<a target="_blank" href="<?php echo esc_url( 'https://www.themeinprogress.com/giornale-versatile-newspaper-and-magazine-wordpress-theme/?ref=2&campaign=giornale-notice' ); ?>" class="button button-primary"><?php esc_html_e( 'Giornale Pro', 'giornale' ); ?></a>

					<a target="_blank" href="<?php echo esc_url( 'https://www.themeinprogress.com/wordpress-themes-bundle/?ref=2&	=giornale-notice' ); ?>" class="button button-primary"><?php esc_html_e( 'Bundle of 19 WordPress themes', 'giornale' ); ?></a>

					<span class="notice-arrow" style="">&#x2938;</span>

            	</p>

            	<p>

                    <?php

                        printf( 
                            '<a href="%1$s" class="dismiss-notice">' . esc_html__( 'Dismiss this notice', 'giornale' ) . '</a>', 
                            esc_url( wp_nonce_url( add_query_arg( 'giornale-dismiss', '1' ), 'giornale-dismiss-action'))
                        );

                    ?>
                    
            	</p>
                    
            </div>
		
		<?php
		
		}

	}

}

new giornale_admin_notice();

?>