<?php

if (!function_exists('giornale_customize_panel_function')) {

	function giornale_customize_panel_function() {

		$theme_panel = array (

			/* Giornale support section
			========================================================================== */

			array(

				'title' => esc_html__( 'Upgrade to Giornale Pro','giornale'),
				'id' => 'giornale-customize-info',
				'type' => 'giornale-customize-info',
				'section' => 'giornale-customize-info',
				'priority' => '08',

			),

			/**
			* Site identity > Hide Tagline option
			*/

			array(

				'label' => esc_html__( 'Hide Tagline','giornale'),
				'description' => esc_html__( 'Do you want to hide the tagline?','giornale'),
				'id' => 'giornale_hide_tagline',
				'type' => 'checkbox',
				'section' => 'title_tagline',
				'std' => true,

			),

			/**
			* Colors > Logo text color option
			*/

			array(

				'label' => esc_html__('Logo text color','giornale'),
				'description' => esc_html__('Choose your custom color for the logo.','giornale'),
				'id' => 'giornale_logo_text_color',
				'type' => 'color',
				'section' => 'colors',
				'std' => '#616161',
			),

			/* Giornale Main Settings panel
			========================================================================== */

			array(

				'title' => esc_html__( 'Giornale Main Settings','giornale'),
				'description' => esc_html__( 'Giornale Main Settings','giornale'),
				'type' => 'panel',
				'id' => 'general_panel',
				'priority' => '10',

			),

			/* Giornale Main Settings panel > Color Scheme section
			========================================================================== */

			array(

				'title' => esc_html__( 'Color Scheme','giornale'),
				'description' => esc_html__( 'From this section you can manage the color scheme of Giornale.','giornale'),
				'type' => 'section',
				'panel' => 'general_panel',
				'priority' => '11',
				'id' => 'colorscheme_section',

			),

			/**
			* Giornale Main Settings panel > Color Scheme section > Body Color Schemes option
			*/

			array(

				'label' => esc_html__( 'Body Color Schemes','giornale'),
				'description' => esc_html__('Choose your body color scheme.','giornale'),
				'id' => 'giornale_skin',
				'type' => 'select',
				'section' => 'colorscheme_section',
				'options' => array (
				   'cyan' => esc_html__( 'Cyan','giornale'),
				   'orange' => esc_html__( 'Orange','giornale'),
				   'blue' => esc_html__( 'Blue','giornale'),
				   'red' => esc_html__( 'Red','giornale'),
				   'pink' => esc_html__( 'Pink','giornale'),
				   'purple' => esc_html__( 'Purple','giornale'),
				   'yellow' => esc_html__( 'Yellow','giornale'),
				   'green' => esc_html__( 'Green','giornale'),
				   'black' => esc_html__( 'Black','giornale'),
				   'clean-yellow' => esc_html__( 'Clean Yellow','giornale'),
				   'clean-red' => esc_html__( 'Clean Red','giornale'),
				   'clean-turquoise' => esc_html__( 'Clean Turquoise','giornale'),
				   'clean-green' => esc_html__( 'Clean Green','giornale'),
				   'clean-blue' => esc_html__( 'Clean Blue','giornale'),
				   'clean-pink' => esc_html__( 'Clean Pink','giornale'),
				),

				'std' => 'orange',

			),

			/* Giornale Main Settings panel > Newsticker section
			========================================================================== */

			array(

				'title' => esc_html__( 'Newsticker section','giornale'),
				'description' => esc_html__( 'From this section you can manage the newsticker.','giornale'),
				'type' => 'section',
				'id' => 'newsticker_section',
				'panel' => 'general_panel',
				'priority' => '13',

			),

			/**
			* Giornale Main Settings panel > Newsticker section > Enable the newsticker option
			*/

			array(

				'label' => esc_html__( 'Enable the newsticker','giornale'),
				'description' => esc_html__( 'Do you want to enable the newsticker?','giornale'),
				'id' => 'giornale_enable_newsticker_section',
				'type' => 'checkbox',
				'section' => 'newsticker_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Newsticker section > News ticker title option
			*/

			array(

				'label' => esc_html__( 'News ticker title','giornale'),
				'description' => esc_html__( 'Insert the title for the news ticker','giornale'),
				'id' => 'giornale_news_ticker_title',
				'type' => 'text',
				'section' => 'newsticker_section',
				'std' => esc_html__( 'HOT', 'giornale'),

			),

			/**
			* Giornale Main Settings panel > Newsticker section > News ticker category option
			*/

			array(

				'label' => esc_html__('News ticker category','giornale'),
				'description' => esc_html__('Please select the category of the news ticker','giornale'),
				'id' => 'giornale_news_ticker_category',
				'type' => 'select',
				'section' => 'newsticker_section',
				'options' => giornale_get_categories(),
				'std' => 'all',

			),

			/**
			* Giornale Main Settings panel > Newsticker section > News ticker orderby option
			*/

			array(
				'label' => esc_html__('News ticker orderby','giornale'),
				'description' => esc_html__('How you want to order the articles?','giornale'),
				'id' => 'giornale_news_ticker_order',
				'type' => 'select',
				'section' => 'newsticker_section',
				'options' => array (
					'title' => esc_html__( 'Post title','giornale'),
					'rand' => esc_html__( 'Randomly','giornale'),
					'comment_count' => esc_html__( 'Comment count','giornale'),
					'date' => esc_html__( 'Post date','giornale'),
				 ),
				 'std' => 'date',
			),

			/**
			* Giornale Main Settings panel > Newsticker section > News ticker sort order option
			*/

			array(
				'label' => esc_html__('News ticker sort order','giornale'),
				'description' => esc_html__('Select the order of the articles','giornale'),
				'id' => 'giornale_news_ticker_sort_order',
				'type' => 'select',
				'section' => 'newsticker_section',
				'options' => array (
					'asc' => esc_html__( 'Ascending','giornale'),
					'desc' => esc_html__( 'Descending','giornale'),
				 ),
				 'std' => 'desc',
			),

			/**
			* Giornale Main Settings panel > Newsticker section > News ticker limit option
			*/

			array(

				'label' => esc_html__( 'News ticker limit','giornale'),
				'description' => esc_html__( 'Please set the limit of the news ticker','giornale'),
				'id' => 'giornale_news_ticker_limit',
				'type' => 'number',
				'input_attrs' => array(
					'min' => -1,
				),
				'section' => 'newsticker_section',
				'std' => '-1',

			),

			/* Giornale Main Settings panel > Topbar section
			========================================================================== */

			array(

				'title' => esc_html__( 'Topbar section','giornale'),
				'description' => esc_html__( 'From this section you can manage the topbar.','giornale'),
				'type' => 'section',
				'id' => 'topbar_section',
				'panel' => 'general_panel',
				'priority' => '13',

			),

			/**
			* Giornale Main Settings panel > Topbar section > Right columns option
			*/

			array(

				'label' => esc_html__('Right columns','giornale'),
				'description' => esc_html__('Select the element to show on right column','giornale'),
				'id' => 'giornale_topbar_rightcolumn',
				'type' => 'select',
				'section' => 'topbar_section',
				'options' => array (
					'topbar_text' => esc_html__( 'Show the topbar text','giornale'),
					'secondary_menu' => esc_html__( 'Show the secondary menu','giornale'),
					'social_icons' => esc_html__( 'Show the social icons','giornale'),
				 ),
				 'std' => 'topbar_text',

			),

			/**
			* Giornale Main Settings panel > Topbar section > Topbar text option
			*/

			array(

				'label' => esc_html__( 'Topbar text','giornale'),
				'description' => esc_html__( 'Please insert the topbar text.','giornale'),
				'id' => 'giornale_topbar_text',
				'type' => 'text',
				'section' => 'topbar_section',
				'std' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.','giornale'),

			),

			/**
			* Giornale Main Settings panel > Topbar section > Date format option
			*/

			array(

				'label' => esc_html__( 'Date format','giornale'),
				'description' => sprintf( wp_kses( __( '<a href="%s" target="_blank">To format the date, please refer to the online documentation for detailed instructions</a>.', 'giornale' ), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://wordpress.org/support/article/formatting-date-and-time' ) ),
				'id' => 'giornale_topbar_date_format',
				'type' => 'dateformat',
				'section' => 'topbar_section',
				'std' => 'l, F j Y',

			),

			/* Giornale Main Settings panel > Recent posts grid section
			========================================================================== */

			array(

				'title' => esc_html__( 'Recent posts grid','giornale'),
				'description' => esc_html__( 'From this section you can manage recent posts grid on the homepage.','giornale'),
				'type' => 'section',
				'id' => 'recent_posts_grid_section',
				'panel' => 'general_panel',
				'priority' => '13',

			),

			/**
			* Giornale Main Settings panel > Recent posts grid section > Recent Posts Grid option
			*/

			array(

				'label' => esc_html__( 'Recent Posts Grid', 'giornale' ),
				'description' => esc_html__( 'Do you want to enable the recent posts grid on the homepage?', 'giornale' ),
				'id' => 'giornale_enable_recent_posts',
				'type' => 'checkbox',
				'section' => 'recent_posts_grid_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Recent posts grid section > Recent posts only on the first page of pagination option
			*/

			array(

				'label' => esc_html__( 'Recent posts only on the first page of pagination', 'giornale' ),
				'description' => esc_html__( 'Do you want to show the recent posts grid only on the first page of pagination on your homepage? Enable this option to display the recent posts grid exclusively on the first page.', 'giornale' ),
				'id' => 'giornale_enable_recent_posts_only_first_page_pagination',
				'type' => 'checkbox',
				'section' => 'recent_posts_grid_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Recent posts grid section > Exclude Recent Posts option
			*/

			array(

				'label' => esc_html__( 'Exclude Recent Posts', 'giornale' ),
				'description' => esc_html__( 'Do you want to exclude the recent posts from the main homepage article loop (if the recent posts grid is enabled)?', 'giornale' ),
				'id' => 'giornale_exclude_recent_posts_on_loop',
				'type' => 'checkbox',
				'section' => 'recent_posts_grid_section',
				'std' => false,

			),

			/**
			* Giornale Main Settings panel > Recent posts grid section > Post author label option
			*/

			array(

				'label' => esc_html__( 'Post author label', 'giornale' ),
				'description' => esc_html__( 'Insert the label of post author','giornale'),
				'id' => 'giornale_recent_posts_post_author_label',
				'type' => 'text',
				'section' => 'recent_posts_grid_section',
				'std' => esc_html__( 'By', 'giornale' )

			),

			/* Giornale Main Settings panel > Trending posts section
			========================================================================== */

			array(

				'title' => esc_html__( 'Trending posts grid','giornale'),
				'description' => esc_html__( 'From this section you can manage trending posts grid on the homepage.','giornale'),
				'type' => 'section',
				'id' => 'trending_posts_section',
				'panel' => 'general_panel',
				'priority' => '13',

			),

			/**
			* Giornale Main Settings panel > Trending posts section > Trending Posts option
			*/

			array(

				'label' => esc_html__( 'Trending Posts', 'giornale' ),
				'description' => esc_html__( 'Do you want to enable the trending posts on the homepage?', 'giornale' ),
				'id' => 'giornale_enable_trending_posts',
				'type' => 'checkbox',
				'section' => 'trending_posts_section',
				'std' => true,

			),
			
			/**
			* Giornale Main Settings panel > Trending Posts section > Trending Posts only on the first page of pagination option
			*/

			array(

				'label' => esc_html__( 'Trending Posts only on the first page of pagination', 'giornale' ),
				'description' => esc_html__( 'Do you want to show the trending posts only on the first page of pagination on your homepage? Enable this option to display the trending posts exclusively on the first page.', 'giornale' ),
				'id' => 'giornale_enable_trending_posts_only_first_page_pagination',
				'type' => 'checkbox',
				'section' => 'trending_posts_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Trending posts section > Show trending posts section title option
			*/

			array(

				'label' => esc_html__( 'Show trending posts section title', 'giornale' ),
				'description' => esc_html__( 'Do you want to show the trending posts section title?', 'giornale' ),
				'id' => 'giornale_enable_trending_posts_section_title',
				'type' => 'checkbox',
				'section' => 'trending_posts_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Trending posts section > Trending posts section title option
			*/

			array(

				'label' => esc_html__( 'Trending posts section title','giornale'),
				'description' => esc_html__( 'Insert the title of trending posts section','giornale'),
				'id' => 'giornale_trending_posts_section_title',
				'type' => 'text',
				'section' => 'trending_posts_section',
				'std' => esc_html__( 'Trending Posts', 'giornale' )

			),

			/**
			* Giornale Main Settings panel > Trending posts section > Trending posts category option
			*/

			array(

				'label' => esc_html__('Trending posts category','giornale'),
				'description' => esc_html__('Please select the category of trending posts section','giornale'),
				'id' => 'giornale_trending_posts_category',
				'type' => 'select',
				'section' => 'trending_posts_section',
				'options' => giornale_get_categories(),
				'std' => 'all',

			),

			/**
			* Giornale Main Settings panel > Trending posts section > Trending posts orderby option
			*/

			array(

				'label' => esc_html__('Trending posts orderby','giornale'),
				'description' => esc_html__('How you want to order the articles?','giornale'),
				'id' => 'giornale_trending_posts_orderby',
				'type' => 'select',
				'section' => 'trending_posts_section',
				'options' => array (
					'ID' => esc_html__( 'ID','giornale'),
					'author' => esc_html__( 'Author','giornale'),
					'title' => esc_html__( 'Post title','giornale'),
					'date' => esc_html__( 'Date','giornale'),
					'comment_count' => esc_html__( 'Number of comments','giornale'),
				 ),
				 'std' => 'comment_count',

			),

			/**
			* Giornale Main Settings panel > Trending posts section > Trending posts sort order option
			*/

			array(
				'label' => esc_html__('Trending posts sort order','giornale'),
				'description' => esc_html__('Select the order of trending posts','giornale'),
				'id' => 'giornale_trending_posts_sort_order',
				'type' => 'select',
				'section' => 'trending_posts_section',
				'options' => array (
					'asc' => esc_html__( 'Ascending','giornale'),
					'desc' => esc_html__( 'Descending','giornale'),
				 ),
				 'std' => 'desc',
			),

			/**
			* Giornale Main Settings panel > Trending posts section > Trending posts images layout option
			*/

			array(

				'label' => esc_html__('Trending posts images layout','giornale'),
				'description' => esc_html__('Select a layout for the trending posts images.','giornale'),
				'id' => 'giornale_trending_posts_images_layout',
				'type' => 'select',
				'section' => 'trending_posts_section',
				'options' => array (
					'square' => esc_html__( 'Square images','giornale'),
					'round' => esc_html__( 'Round images','giornale'),
				 ),
				 'std' => 'square',

			),

			/**
			* Giornale Main Settings panel > Trending posts section > Post author label option
			*/

			array(

				'label' => esc_html__( 'Post author label', 'giornale' ),
				'description' => esc_html__( 'Insert the label of post author','giornale'),
				'id' => 'giornale_trending_posts_post_author_label',
				'type' => 'text',
				'section' => 'trending_posts_section',
				'std' => esc_html__( 'Written by', 'giornale' )

			),

			/* Giornale Main Settings panel > Recommended posts section
			========================================================================== */

			array(

				'title' => esc_html__( 'Recommended posts grid','giornale'),
				'description' => esc_html__( 'From this section you can manage the recommended posts grid on the homepage.','giornale'),
				'type' => 'section',
				'id' => 'recommended_posts_section',
				'panel' => 'general_panel',
				'priority' => '13',

			),

			/**
			* Giornale Main Settings panel > Recommended posts section > Recommended posts option
			*/

			array(

				'label' => esc_html__( 'Recommended posts', 'giornale' ),
				'description' => esc_html__( 'Do you want to enable the recommended posts grid on the homepage?', 'giornale' ),
				'id' => 'giornale_enable_recommended_posts',
				'type' => 'checkbox',
				'section' => 'recommended_posts_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Recommended posts section > Recommended posts only on the first page of pagination option
			*/

			array(

				'label' => esc_html__( 'Recommended posts only on the first page of pagination', 'giornale' ),
				'description' => esc_html__( 'Do you want to show the recommended posts grid only on the first page of pagination on your homepage? Enable this option to display the recommended posts grid exclusively on the first page.', 'giornale' ),
				'id' => 'giornale_enable_recommended_posts_only_first_page_pagination',
				'type' => 'checkbox',
				'section' => 'recommended_posts_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Recommended posts section > Show recommended posts section title option
			*/

			array(

				'label' => esc_html__( 'Show recommended posts section title', 'giornale' ),
				'description' => esc_html__( 'Do you want to show the recommended posts section title?', 'giornale' ),
				'id' => 'giornale_enable_recommended_posts_section_title',
				'type' => 'checkbox',
				'section' => 'recommended_posts_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Recommended posts section > Recommended posts section title option
			*/

			array(

				'label' => esc_html__( 'Recommended posts section title','giornale'),
				'description' => esc_html__( 'Insert the title of recommended posts section','giornale'),
				'id' => 'giornale_recommended_posts_section_title',
				'type' => 'text',
				'section' => 'recommended_posts_section',
				'std' => esc_html__( 'Recommended posts', 'giornale' )

			),

			/**
			* Giornale Main Settings panel > Recommended posts section > Recommended posts style option
			*/

			array(

				'label' => esc_html__('Recommended posts style','giornale'),
				'description' => esc_html__('Select a style for the recommended posts section','giornale'),
				'id' => 'giornale_recommended_posts_style',
				'type' => 'select',
				'section' => 'recommended_posts_section',
				'options' => array (
					'light' => esc_html__( 'Light style','giornale'),
					'grey' => esc_html__( 'Grey style','giornale'),
					'dark' => esc_html__( 'Dark style','giornale'),
				),
				 'std' => 'light',

			),

			/**
			* Giornale Main Settings panel > Recommended posts section > Recommended posts layout option
			*/

			array(

				'label' => esc_html__('Recommended posts layout','giornale'),
				'description' => esc_html__('Select a layout for the recommended posts grid','giornale'),
				'id' => 'giornale_recommended_posts_layout',
				'type' => 'select',
				'section' => 'recommended_posts_section',
				'options' => array (
					'layout-1' => esc_html__( 'Layout 1','giornale'),
					'layout-2' => esc_html__( 'Layout 2','giornale'),
					'layout-3' => esc_html__( 'Layout 3','giornale'),
					'layout-4' => esc_html__( 'Layout 4','giornale'),
					'layout-5' => esc_html__( 'Layout 5','giornale'),
					'layout-6' => esc_html__( 'Layout 6','giornale'),
					'layout-7' => esc_html__( 'Layout 7','giornale'),
				),
				 'std' => 'layout-1',

			),

			/**
			* Giornale Main Settings panel > Recommended posts section > Recommended posts category option
			*/

			array(

				'label' => esc_html__('Recommended posts category','giornale'),
				'description' => esc_html__('Please select the category of recommended posts section','giornale'),
				'id' => 'giornale_recommended_posts_category',
				'type' => 'select',
				'section' => 'recommended_posts_section',
				'options' => giornale_get_categories(),
				'std' => 'all',

			),

			/**
			* Giornale Main Settings panel > Recommended posts section > Recommended posts orderby option
			*/

			array(

				'label' => esc_html__('Recommended posts orderby','giornale'),
				'description' => esc_html__('How you want to order the articles?','giornale'),
				'id' => 'giornale_recommended_posts_orderby',
				'type' => 'select',
				'section' => 'recommended_posts_section',
				'options' => array (
					'ID' => esc_html__( 'ID','giornale'),
					'author' => esc_html__( 'Author','giornale'),
					'title' => esc_html__( 'Post title','giornale'),
					'date' => esc_html__( 'Date','giornale'),
					'comment_count' => esc_html__( 'Number of comments','giornale'),
				 ),
				 'std' => 'date',

			),

			/**
			* Giornale Main Settings panel > Recommended posts section > Recommended posts sort order option
			*/

			array(
				'label' => esc_html__('Recommended posts sort order','giornale'),
				'description' => esc_html__('Select the order of recommended posts','giornale'),
				'id' => 'giornale_recommended_posts_sort_order',
				'type' => 'select',
				'section' => 'recommended_posts_section',
				'options' => array (
					'asc' => esc_html__( 'Ascending','giornale'),
					'desc' => esc_html__( 'Descending','giornale'),
				 ),
				 'std' => 'desc',
			),

			/* Giornale Main Settings panel > General settings section
			========================================================================== */

			array(

				'title' => esc_html__( 'General settings','giornale'),
				'description' => esc_html__( 'From this section you can manage the general settings of Giornale.','giornale'),
				'type' => 'section',
				'id' => 'settings_section',
				'panel' => 'general_panel',
				'priority' => '13',

			),

			/**
			* Giornale Main Settings panel > General settings section > Underline for section titles option
			*/

			array(

				'label' => esc_html__( 'Underline for section titles','giornale'),
				'description' => esc_html__( 'Do you want to remove the underline below the section titles?','giornale'),
				'id' => 'giornale_underline_below_section_titles',
				'type' => 'checkbox',
				'section' => 'settings_section',
				'std' => false,

			),

			/**
			* Giornale Main Settings panel > General settings section > Secondary menu within the sidebar on mobile devices option
			*/

			array(

				'label' => esc_html__( 'Secondary menu within the sidebar on mobile devices','giornale'),
				'description' => esc_html__( 'Do you want to display the secondary menu within the scrollable sidebar on mobile devices?','giornale'),
				'id' => 'giornale_secondary_menu_scrollable_sidebar_on_mobile',
				'type' => 'checkbox',
				'section' => 'settings_section',
				'std' => false,

			),

			/**
			* Giornale Main Settings panel > General settings section > Enable the breadcrumb option
			*/

			array(

				'label' => esc_html__( 'Enable the breadcrumb','giornale'),
				'description' => esc_html__( 'Do you want to enable the breadcrumb on whole website (except the homepage)?','giornale'),
				'id' => 'giornale_enable_breadcrumb',
				'type' => 'checkbox',
				'section' => 'settings_section',
				'std' => false,

			),

			/**
			* Giornale Main Settings panel > General settings section > Homepage label option
			*/

			array(

				'label' => esc_html__( 'Homepage label','giornale'),
				'description' => esc_html__( 'Would you like to display a label before the list of recent posts on the homepage?','giornale'),
				'id' => 'giornale_enable_homepage_label',
				'type' => 'checkbox',
				'section' => 'settings_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > General settings section > Homepage label only on the first page of pagination
			*/

			array(

				'label' => esc_html__( 'Homepage label only on the first page of pagination', 'giornale' ),
				'description' => esc_html__( 'Do you want to show the homepage label only on the first page of pagination on your homepage? Enable this option to display the homepage label exclusively on the first page.', 'giornale' ),
				'id' => 'giornale_enable_homepage_label_only_first_page_pagination',
				'type' => 'checkbox',
				'section' => 'settings_section',
				'std' => true,

			),


			/**
			* Giornale Main Settings panel > General settings section > Custom homepage label option
			*/

			array(

				'label' => esc_html__( 'Custom homepage label','giornale'),
				'description' => esc_html__( 'Replace the default label before the list of recent posts on the homepage','giornale'),
				'id' => 'giornale_custom_homepage_label',
				'type' => 'text',
				'section' => 'settings_section',
				'std' => esc_html__( 'Don\'t miss...', 'giornale' )

			),

			/**
			* Giornale Main Settings panel > General settings section > Category title option
			*/

			array(

				'label' => esc_html__( 'Category title','giornale'),
				'description' => esc_html__( 'Do you want to display the current category title on archive pages?','giornale'),
				'id' => 'giornale_enable_category_title',
				'type' => 'checkbox',
				'section' => 'settings_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > General settings section > Searched item option
			*/

			array(

				'label' => esc_html__( 'Searched item','giornale'),
				'description' => esc_html__( 'Do you want to enable the searched item on the search result pages?','giornale'),
				'id' => 'giornale_enable_searched_item',
				'type' => 'checkbox',
				'section' => 'settings_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > General settings section > Back to top button option
			*/

			array(

				'label' => esc_html__( 'Back to top button','giornale'),
				'description' => esc_html__( 'Do you want to enable a button to back on the top of the site?','giornale'),
				'id' => 'giornale_enable_backtotop_button',
				'type' => 'checkbox',
				'section' => 'settings_section',
				'std' => true,

			),

			/* Giornale Main Settings panel > Single posts settings section
			========================================================================== */

			array(

				'title' => esc_html__( 'Single posts settings','giornale'),
				'description' => esc_html__( 'From this section, you can manage (show or hide) various elements within individual posts, such as the category, publication date, author, etc.','giornale'),
				'type' => 'section',
				'id' => 'single_posts_settings_section',
				'panel' => 'general_panel',
				'priority' => '13',

			),

			/**
			* Giornale Main Settings panel > Single posts settings section > Show categories option
			*/

			array(

				'label' => esc_html__( 'Show categories','giornale'),
				'description' => esc_html__( 'Do you want to enable the post categories?','giornale'),
				'id' => 'giornale_enable_post_category',
				'type' => 'checkbox',
				'section' => 'single_posts_settings_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Single posts settings section > Show post icon option
			*/

			array(

				'label' => esc_html__( 'Show post icon','giornale'),
				'description' => esc_html__( 'Do you want to enable the post icon?','giornale'),
				'id' => 'giornale_enable_post_icon',
				'type' => 'checkbox',
				'section' => 'single_posts_settings_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Single posts settings section > Show author option
			*/

			array(

				'label' => esc_html__( 'Show author','giornale'),
				'description' => esc_html__( 'Do you want to enable the author name?','giornale'),
				'id' => 'giornale_enable_post_author',
				'type' => 'checkbox',
				'section' => 'single_posts_settings_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Single posts settings section > Post author label option
			*/

			array(

				'label' => esc_html__( 'Post author label', 'giornale' ),
				'description' => esc_html__( 'Insert the label of post author','giornale'),
				'id' => 'giornale_post_author_label',
				'type' => 'text',
				'section' => 'single_posts_settings_section',
				'std' => esc_html__( 'Written by', 'giornale' )

			),

			/**
			* Giornale Main Settings panel > Single posts settings section > Show date option
			*/

			array(

				'label' => esc_html__( 'Show date','giornale'),
				'description' => esc_html__( 'Do you want to enable the post date?','giornale'),
				'id' => 'giornale_enable_post_date',
				'type' => 'checkbox',
				'section' => 'single_posts_settings_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Single posts settings section > Related posts option
			*/

			array(

				'label' => esc_html__( 'Related posts','giornale'),
				'description' => esc_html__( 'Do you want to display the related posts at the end of each article?','giornale'),
				'id' => 'giornale_enable_related_posts',
				'type' => 'checkbox',
				'section' => 'single_posts_settings_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > Single posts settings section > Post author info box option
			*/

			array(

				'label' => esc_html__( 'Post author info box','giornale'),
				'description' => esc_html__( 'Do you want to display the post author info box below the content? (Important, the biographical info must be added from the user settings)','giornale'),
				'id' => 'giornale_enable_author_info_box',
				'type' => 'checkbox',
				'section' => 'single_posts_settings_section',
				'std' => false,

			),

			/**
			* Giornale Main Settings panel > Single posts settings section > Post Format option
			*/

			array(

				'label' => esc_html__( 'Post Format','giornale'),
				'description' => esc_html__( 'Do you want to use a different layout for the Aside, Link and Quote posts?','giornale'),
				'id' => 'giornale_enable_post_format_layout',
				'type' => 'checkbox',
				'section' => 'single_posts_settings_section',
				'std' => true,

			),

			/* Giornale Main Settings panel > WooCommerce settings
			========================================================================== */

			array(

				'title' => esc_html__( 'WooCommerce settings','giornale'),
				'description' => esc_html__( 'From this section you can manage the settings of WooCommerce.','giornale'),
				'type' => 'section',
				'id' => 'woocommerce_section',
				'panel' => 'general_panel',
				'priority' => '25',

			),

			/**
			* Giornale Main Settings panel > WooCommerce settings section > WooCommerce header cart option
			*/

			array(

				'label' => esc_html__('WooCommerce header cart','giornale'),
				'description' => esc_html__('Do you want to show the header cart?','giornale'),
				'id' => 'giornale_enable_woocommerce_header_cart',
				'type' => 'checkbox',
				'section' => 'woocommerce_section',
				'std' => true,

			),

			/**
			* Giornale Main Settings panel > WooCommerce settings section > WooCommerce header cart icon option
			*/

			array(

				'label' => esc_html__('WooCommerce header cart icon','giornale'),
				'description' => esc_html__('Select the icon for WooCommerce header cart (Please clear the cookies to display the new icon)','giornale'),
				'id' => 'giornale_woocommerce_header_icon',
				'type' => 'select',
				'section' => 'woocommerce_section',
				'options' => array (
				   'fa-shopping-basket' => esc_html__( 'Icon 1','giornale'),
				   'fa-shopping-cart' => esc_html__( 'Icon 2','giornale'),
				   'fa-cart-plus' => esc_html__( 'Icon 3','giornale'),
				),
				'std' => 'fa-shopping-basket',

			),

			/**
			* Giornale Main Settings panel > WooCommerce settings section > Cross sell products option
			*/

			array(

				'label' => esc_html__( 'Cross sell products','giornale'),
				'description' => esc_html__( 'Do you want to display the cross sell products on cart page?','giornale'),
				'id' => 'giornale_enable_woocommerce_cross_sell_cart',
				'type' => 'checkbox',
				'section' => 'woocommerce_section',
				'std' => false,

			),

			/**
			* Giornale Main Settings panel > WooCommerce settings section > Related products option
			*/

			array(

				'label' => esc_html__( 'Related products','giornale'),
				'description' => esc_html__( 'Do you want to display the related products on product page?','giornale'),
				'id' => 'giornale_enable_woocommerce_related_products',
				'type' => 'checkbox',
				'section' => 'woocommerce_section',
				'std' => false,

			),

			/**
			* Giornale Main Settings panel > WooCommerce settings section > Up sell products option
			*/

			array(

				'label' => esc_html__( 'Up sell products','giornale'),
				'description' => esc_html__( 'Do you want to display the up sell products on product page?','giornale'),
				'id' => 'giornale_enable_woocommerce_upsell_products',
				'type' => 'checkbox',
				'section' => 'woocommerce_section',
				'std' => false,

			),

			/**
			* Giornale Main Settings panel > WooCommerce settings section > WooCommerce linkable product thumbnails option
			*/

			array(

				'label' => esc_html__( 'WooCommerce linkable product thumbnails','giornale'),
				'description' => esc_html__( 'Do you want to make linkable the product thumbnails on WooCommerce category pages?','giornale'),
				'id' => 'giornale_enable_woocommerce_linkable_product_thumbnails',
				'type' => 'checkbox',
				'section' => 'woocommerce_section',
				'std' => false,

			),

			/**
			* Giornale Main Settings panel > WooCommerce settings section > WooCommerce Category Layout option
			*/

			array(

				'label' => esc_html__('WooCommerce Category Layout','giornale'),
				'description' => esc_html__('Select a layout for the woocommerce categories.','giornale'),
				'id' => 'giornale_woocommerce_category_layout',
				'type' => 'select',
				'section' => 'woocommerce_section',
				'options' => array (
				   'full' => esc_html__( 'Full Width','giornale'),
				   'left-sidebar' => esc_html__( 'Left Sidebar','giornale'),
				   'right-sidebar' => esc_html__( 'Right Sidebar','giornale'),
				),

				'std' => 'right-sidebar',

			),

			/* Giornale Featured Links panel
			========================================================================== */

			array(

				'title' => esc_html__( 'Giornale Featured Links','giornale'),
				'description' => esc_html__( 'Giornale Featured Links','giornale'),
				'type' => 'panel',
				'id' => 'featured_links_panel',
				'priority' => '10',

			),

			/* Giornale Featured Links panel > Featured Link Settings section
			========================================================================== */

			array(

				'title' => esc_html__( 'Featured Link Settings','giornale'),
				'description' => esc_html__('Featured Link #1','giornale'),
				'type' => 'section',
				'panel' => 'featured_links_panel',
				'priority' => '09',
				'id' => 'featured_links_settings',

			),

			/**
			* Giornale Featured Links panel > Featured Link Settings section > Enable the featured links section option
			*/

			array(

				'label' => esc_html__( 'Enable the featured links section','giornale'),
				'description' => esc_html__( 'Do you want to display the featured links section, below the homepage slideshow?','giornale'),
				'id' => 'giornale_enable_featuredlinks_section',
				'type' => 'checkbox',
				'section' => 'featured_links_settings',
				'std' => false,

			),

			/* Giornale Featured Links panel > Featured Link #1 section
			========================================================================== */

			array(

				'title' => esc_html__( 'Featured Link #1','giornale'),
				'description' => esc_html__('Featured Link #1','giornale'),
				'type' => 'section',
				'panel' => 'featured_links_panel',
				'priority' => '10',
				'id' => 'featured_link_1',

			),

			/**
			* Giornale Featured Links panel > Featured Link #1 section > Image option
			*/

			array(

				'label' => esc_html__( 'Image','giornale'),
				'description' => esc_html__( 'Upload the image','giornale'),
				'id' => 'giornale_featured_link_1_image',
				'type' => 'upload',
				'section' => 'featured_link_1',
				'std' => '',

			),

			/**
			* Giornale Featured Links panel > Featured Link #1 section > Title option
			*/

			array(

				'label' => esc_html__( 'Title','giornale'),
				'description' => esc_html__( 'Insert the title of this slide','giornale'),
				'id' => 'giornale_featured_link_1_title',
				'type' => 'text',
				'section' => 'featured_link_1',
				'std' => '',

			),

			/**
			* Giornale Featured Links panel > Featured Link #1 section > Url option
			*/

			array(

				'label' => esc_html__( 'Url','giornale'),
				'description' => esc_html__( 'Insert the url of this slide','giornale'),
				'id' => 'giornale_featured_link_1_url',
				'type' => 'url',
				'section' => 'featured_link_1',
				'std' => '',

			),

			/* Giornale Featured Links panel > Featured Link #2 section
			========================================================================== */

			array(

				'title' => esc_html__( 'Featured Link #2','giornale'),
				'description' => esc_html__('Featured Link #2','giornale'),
				'type' => 'section',
				'panel' => 'featured_links_panel',
				'priority' => '10',
				'id' => 'featured_link_2',

			),

			/**
			* Giornale Featured Links panel > Featured Link #2 section > Image option
			*/

			array(

				'label' => esc_html__( 'Image','giornale'),
				'description' => esc_html__( 'Upload the image','giornale'),
				'id' => 'giornale_featured_link_2_image',
				'type' => 'upload',
				'section' => 'featured_link_2',
				'std' => '',

			),

			/**
			* Giornale Featured Links panel > Featured Link #2 section > Title option
			*/

			array(

				'label' => esc_html__( 'Title','giornale'),
				'description' => esc_html__( 'Insert the title of this slide','giornale'),
				'id' => 'giornale_featured_link_2_title',
				'type' => 'text',
				'section' => 'featured_link_2',
				'std' => '',

			),

			/**
			* Giornale Featured Links panel > Featured Link #2 section > Url option
			*/

			array(

				'label' => esc_html__( 'Url','giornale'),
				'description' => esc_html__( 'Insert the url of this slide','giornale'),
				'id' => 'giornale_featured_link_2_url',
				'type' => 'url',
				'section' => 'featured_link_2',
				'std' => '',

			),

			/* Giornale Featured Links panel > Featured Link #3 section
			========================================================================== */

			array(

				'title' => esc_html__( 'Featured Link #3','giornale'),
				'description' => esc_html__('Featured Link #3','giornale'),
				'type' => 'section',
				'panel' => 'featured_links_panel',
				'priority' => '10',
				'id' => 'featured_link_3',

			),

			/**
			* Giornale Featured Links panel > Featured Link #3 section > Image option
			*/

			array(

				'label' => esc_html__( 'Image','giornale'),
				'description' => esc_html__( 'Upload the image','giornale'),
				'id' => 'giornale_featured_link_3_image',
				'type' => 'upload',
				'section' => 'featured_link_3',
				'std' => '',

			),

			/**
			* Giornale Featured Links panel > Featured Link #3 section > Title option
			*/

			array(

				'label' => esc_html__( 'Title','giornale'),
				'description' => esc_html__( 'Insert the title of this slide','giornale'),
				'id' => 'giornale_featured_link_3_title',
				'type' => 'text',
				'section' => 'featured_link_3',
				'std' => '',

			),

			/**
			* Giornale Featured Links panel > Featured Link #3 section > Url option
			*/

			array(

				'label' => esc_html__( 'Url','giornale'),
				'description' => esc_html__( 'Insert the url of this slide','giornale'),
				'id' => 'giornale_featured_link_3_url',
				'type' => 'url',
				'section' => 'featured_link_3',
				'std' => '',

			),

			/* Giornale Main Settings panel > Layouts section
			========================================================================== */

			array(

				'title' => esc_html__( 'Layouts','giornale'),
				'description' => esc_html__( 'From this section you can manage the layouts of Giornale.','giornale'),
				'type' => 'section',
				'id' => 'layouts_section',
				'panel' => 'general_panel',
				'priority' => '16',

			),

			/**
			* Giornale Main Settings panel > Layouts section > Home Blog Layout option
			*/

			array(

				'label' => esc_html__('Home Blog Layout','giornale'),
				'description' => esc_html__('If you&#39;ve set the latest articles, for the homepage, choose a layout.','giornale'),
				'id' => 'giornale_home_layout',
				'type' => 'select',
				'section' => 'layouts_section',
				'options' => array (
				   'full' => esc_html__( 'Full Width','giornale'),
				   'left-sidebar' => esc_html__( 'Left Sidebar','giornale'),
				   'right-sidebar' => esc_html__( 'Right Sidebar','giornale'),
				   'col-md-4' => esc_html__( 'Masonry','giornale'),
				),

				'std' => 'right-sidebar',

			),

			/**
			* Giornale Main Settings panel > Layouts section > Category Layout option
			*/

			array(

				'label' => esc_html__('Category Layout','giornale'),
				'description' => esc_html__('Select a layout for category pages.','giornale'),
				'id' => 'giornale_category_layout',
				'type' => 'select',
				'section' => 'layouts_section',
				'options' => array (
				   'full' => esc_html__( 'Full Width','giornale'),
				   'left-sidebar' => esc_html__( 'Left Sidebar','giornale'),
				   'right-sidebar' => esc_html__( 'Right Sidebar','giornale'),
				   'col-md-4' => esc_html__( 'Masonry','giornale'),
				),

				'std' => 'right-sidebar',

			),

			/**
			* Giornale Main Settings panel > Layouts section > Search Layout option
			*/

			array(

				'label' => esc_html__('Search Layout','giornale'),
				'description' => esc_html__('Select a layout for the search section.','giornale'),
				'id' => 'giornale_search_layout',
				'type' => 'select',
				'section' => 'layouts_section',
				'options' => array (
				   'full' => esc_html__( 'Full Width','giornale'),
				   'left-sidebar' => esc_html__( 'Left Sidebar','giornale'),
				   'right-sidebar' => esc_html__( 'Right Sidebar','giornale'),
				   'col-md-4' => esc_html__( 'Masonry','giornale'),
				),

				'std' => 'right-sidebar',

			),

			/* Giornale Main Settings panel > Social Links and Footer section
			========================================================================== */

			array(

				'title' => esc_html__( 'Social Links and Footer','giornale'),
				'description' => esc_html__( 'From this section you can manage the social icons and the copyright text.','giornale'),
				'type' => 'section',
				'id' => 'footer_section',
				'panel' => 'general_panel',
				'priority' => '17',

			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Copyright Text option
			*/

			array(

				'label' => esc_html__( 'Copyright Text','giornale'),
				'description' => esc_html__( 'Insert your copyright text.','giornale'),
				'id' => 'giornale_copyright_text',
				'type' => 'textarea',
				'section' => 'footer_section',
				'std' => '',

			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Social link #1 icon option
			*/

			array(

				'label' => esc_html__( 'Social link #1 icon','giornale'),
				'description' => esc_html__( 'Choose a icon for this social link','giornale'),
				'id' => 'giornale_social_link_icon_1',
				'type' => 'select',
				'section' => 'footer_section',
				'options' => array(
					'none' => esc_html__('None', 'giornale'),
					'facebook' => esc_html__('Facebook', 'giornale'),
					'x' => esc_html__('X', 'giornale'),
					'tiktok' => esc_html__('TikTok', 'giornale'),
					'matrix' => esc_html__('Matrix', 'giornale'),
					'slack' => esc_html__('Slack', 'giornale'),
					'pinterest' => esc_html__('Pinterest', 'giornale'),
					'tumblr' => esc_html__('Tumblr', 'giornale'),
					'soundcloud' => esc_html__('Soundcloud', 'giornale'),
					'spotify' => esc_html__('Spotify', 'giornale'),
					'youtube' => esc_html__('Youtube', 'giornale'),
					'vimeo' => esc_html__('Vimeo', 'giornale'),
					'vk' => esc_html__('Vk', 'giornale'),
					'instagram' => esc_html__('Instagram', 'giornale'),
				),
				'std' => 'none',
			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Social link #1 URL option
			*/

			array(

				'label' => esc_html__( 'Social link #1 URL','giornale'),
				'description' => esc_html__( 'Insert the URL of this social link','giornale'),
				'id' => 'giornale_social_link_url_1',
				'type' => 'social_link',
				'section' => 'footer_section',
				'std' => '',

			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Social link #2 icon option
			*/

			array(

				'label' => esc_html__( 'Social link #2 icon','giornale'),
				'description' => esc_html__( 'Choose a icon for this social link','giornale'),
				'id' => 'giornale_social_link_icon_2',
				'type' => 'select',
				'section' => 'footer_section',
				'options' => array(
					'none' => esc_html__('None', 'giornale'),
					'facebook' => esc_html__('Facebook', 'giornale'),
					'x' => esc_html__('X', 'giornale'),
					'tiktok' => esc_html__('TikTok', 'giornale'),
					'matrix' => esc_html__('Matrix', 'giornale'),
					'slack' => esc_html__('Slack', 'giornale'),
					'pinterest' => esc_html__('Pinterest', 'giornale'),
					'tumblr' => esc_html__('Tumblr', 'giornale'),
					'soundcloud' => esc_html__('Soundcloud', 'giornale'),
					'spotify' => esc_html__('Spotify', 'giornale'),
					'youtube' => esc_html__('Youtube', 'giornale'),
					'vimeo' => esc_html__('Vimeo', 'giornale'),
					'vk' => esc_html__('Vk', 'giornale'),
					'instagram' => esc_html__('Instagram', 'giornale'),
				),
				'std' => 'none',
			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Social link #2 URL option
			*/

			array(

				'label' => esc_html__( 'Social link #2 URL','giornale'),
				'description' => esc_html__( 'Insert the URL of this social link','giornale'),
				'id' => 'giornale_social_link_url_2',
				'type' => 'social_link',
				'section' => 'footer_section',
				'std' => '',

			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Social link #3 icon option
			*/

			array(

				'label' => esc_html__( 'Social link #3 icon','giornale'),
				'description' => esc_html__( 'Choose a icon for this social link','giornale'),
				'id' => 'giornale_social_link_icon_3',
				'type' => 'select',
				'section' => 'footer_section',
				'options' => array(
					'none' => esc_html__('None', 'giornale'),
					'facebook' => esc_html__('Facebook', 'giornale'),
					'x' => esc_html__('X', 'giornale'),
					'tiktok' => esc_html__('TikTok', 'giornale'),
					'matrix' => esc_html__('Matrix', 'giornale'),
					'slack' => esc_html__('Slack', 'giornale'),
					'pinterest' => esc_html__('Pinterest', 'giornale'),
					'tumblr' => esc_html__('Tumblr', 'giornale'),
					'soundcloud' => esc_html__('Soundcloud', 'giornale'),
					'spotify' => esc_html__('Spotify', 'giornale'),
					'youtube' => esc_html__('Youtube', 'giornale'),
					'vimeo' => esc_html__('Vimeo', 'giornale'),
					'vk' => esc_html__('Vk', 'giornale'),
					'instagram' => esc_html__('Instagram', 'giornale'),
				),
				'std' => 'none',
			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Social link #3 URL option
			*/

			array(

				'label' => esc_html__( 'Social link #3 URL','giornale'),
				'description' => esc_html__( 'Insert the URL of this social link','giornale'),
				'id' => 'giornale_social_link_url_3',
				'type' => 'social_link',
				'section' => 'footer_section',
				'std' => '',

			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Social link #4 icon option
			*/

			array(

				'label' => esc_html__( 'Social link #4 icon','giornale'),
				'description' => esc_html__( 'Choose a icon for this social link','giornale'),
				'id' => 'giornale_social_link_icon_4',
				'type' => 'select',
				'section' => 'footer_section',
				'options' => array(
					'none' => esc_html__('None', 'giornale'),
					'facebook' => esc_html__('Facebook', 'giornale'),
					'x' => esc_html__('X', 'giornale'),
					'tiktok' => esc_html__('TikTok', 'giornale'),
					'matrix' => esc_html__('Matrix', 'giornale'),
					'slack' => esc_html__('Slack', 'giornale'),
					'pinterest' => esc_html__('Pinterest', 'giornale'),
					'tumblr' => esc_html__('Tumblr', 'giornale'),
					'soundcloud' => esc_html__('Soundcloud', 'giornale'),
					'spotify' => esc_html__('Spotify', 'giornale'),
					'youtube' => esc_html__('Youtube', 'giornale'),
					'vimeo' => esc_html__('Vimeo', 'giornale'),
					'vk' => esc_html__('Vk', 'giornale'),
					'instagram' => esc_html__('Instagram', 'giornale'),
				),
				'std' => 'none',
			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Social link #4 URL option
			*/

			array(

				'label' => esc_html__( 'Social link #4 URL','giornale'),
				'description' => esc_html__( 'Insert the URL of this social link','giornale'),
				'id' => 'giornale_social_link_url_4',
				'type' => 'social_link',
				'section' => 'footer_section',
				'std' => '',

			),

			/**
			* Giornale Main Settings panel > Social Links and Footer section > Feed Rss Button option
			*/

			array(

				'label' => esc_html__( 'Feed Rss Button','giornale'),
				'description' => esc_html__( 'Do you want to display the Feed Rss button?','giornale'),
				'id' => 'giornale_footer_rss_button',
				'type' => 'checkbox',
				'section' => 'footer_section',
				'std' => false,

			),

			/* Giornale Typography panel
			========================================================================== */

			array(

				'title' => esc_html__( 'Giornale Typography','giornale'),
				'description' => esc_html__( 'Giornale Typography','giornale'),
				'type' => 'panel',
				'id' => 'typography_panel',
				'priority' => '11',

			),

			/* Giornale Typography panel > Logo section
			========================================================================== */

			array(

				'title' => esc_html__( 'Logo','giornale'),
				'description' => esc_html__( 'From this section you can manage the typography of the logo.','giornale'),
				'type' => 'section',
				'id' => 'logo_section',
				'panel' => 'typography_panel',
				'priority' => '10',

			),

			/**
			* Giornale Typography panel > Logo section > Font size option
			*/

			array(

				'label' => esc_html__( 'Font size','giornale'),
				'description' => esc_html__( 'Insert a size, for logo font (For example, 60px) ','giornale'),
				'id' => 'giornale_logo_font_size',
				'type' => 'pixel_size',
				'section' => 'logo_section',
				'std' => '50px',

			),

			/**
			* Giornale Typography panel > Logo section > Description font size option
			*/

			array(

				'label' => esc_html__( 'Description font size','giornale'),
				'description' => esc_html__( 'Insert a size, for logo description (For example, 14px) ','giornale'),
				'id' => 'giornale_logo_description_font_size',
				'type' => 'pixel_size',
				'section' => 'logo_section',
				'std' => '14px',

			),

			/**
			* Giornale Typography panel > Logo section > Description top margin option
			*/

			array(

				'label' => esc_html__( 'Description top margin','giornale'),
				'description' => esc_html__( 'Add a space between the logo and the description (For example, 15px) ','giornale'),
				'id' => 'giornale_logo_description_top_margin',
				'type' => 'pixel_size',
				'section' => 'logo_section',
				'std' => '10px',

			),

			/**
			* Giornale Typography panel > Logo section > Weight option
			*/

			array(

				'label' => esc_html__('Weight','giornale'),
				'description' => esc_html__('Choose a font weight for the logo.','giornale'),
				'id' => 'giornale_logo_font_weight',
				'type' => 'select',
				'section' => 'logo_section',
				'options' => array(
					'100' => esc_html__( '100','giornale'),
					'200' => esc_html__( '200','giornale'),
					'300' => esc_html__( '300','giornale'),
					'400' => esc_html__( '400','giornale'),
					'500' => esc_html__( '500','giornale'),
					'600' => esc_html__( '600','giornale'),
					'700' => esc_html__( '700','giornale'),
					'800' => esc_html__( '800','giornale'),
					'900' => esc_html__( '900','giornale'),
				),

				'std' => '500',

			),

			/**
			* Giornale Typography panel > Logo section > Text transform option
			*/

			array(

				'label' => esc_html__('Text transform','giornale'),
				'description' => esc_html__('Do you want to display an uppercase logo?.','giornale'),
				'id' => 'giornale_logo_text_transform',
				'type' => 'select',
				'section' => 'logo_section',
				'options' => array(
					'none' => esc_html__( 'None','giornale'),
					'uppercase' => esc_html__( 'Uppercase','giornale'),
				),

				'std' => 'none',

			),

			/* Giornale Typography panel > Menu section
			========================================================================== */

			array(

				'title' => esc_html__( 'Menu','giornale'),
				'description' => esc_html__( 'From this section you can manage the typography of the menu.','giornale'),
				'type' => 'section',
				'id' => 'menu_section',
				'panel' => 'typography_panel',
				'priority' => '11',

			),

			/**
			* Giornale Typography panel > Menu section > Font size option
			*/

			array(

				'label' => esc_html__( 'Font size','giornale'),
				'description' => esc_html__( 'Insert a size, for menu font (For example, 14px) ','giornale'),
				'id' => 'giornale_menu_font_size',
				'type' => 'pixel_size',
				'section' => 'menu_section',
				'std' => '16px',

			),

			/**
			* Giornale Typography panel > Menu section > Menu weight option
			*/

			array(

				'label' => esc_html__('Menu weight','giornale'),
				'description' => esc_html__('Choose a font weight for the menu.','giornale'),
				'id' => 'giornale_menu_font_weight',
				'type' => 'select',
				'section' => 'menu_section',
				'options' => array(
					'100' => esc_html__( '100','giornale'),
					'200' => esc_html__( '200','giornale'),
					'300' => esc_html__( '300','giornale'),
					'400' => esc_html__( '400','giornale'),
					'500' => esc_html__( '500','giornale'),
					'600' => esc_html__( '600','giornale'),
					'700' => esc_html__( '700','giornale'),
					'800' => esc_html__( '800','giornale'),
					'900' => esc_html__( '900','giornale'),
				),

				'std' => '400',

			),

			/**
			* Giornale Typography panel > Menu section > Text transform option
			*/

			array(

				'label' => esc_html__('Text transform','giornale'),
				'description' => esc_html__('Do you want to display an uppercase menu?.','giornale'),
				'id' => 'giornale_menu_text_transform',
				'type' => 'select',
				'section' => 'menu_section',
				'options' => array(
					'none' => esc_html__( 'None','giornale'),
					'uppercase' => esc_html__( 'Uppercase','giornale'),
				),

				'std' => 'uppercase',

			),

			/* Giornale Typography panel > Content section
			========================================================================== */

			array(

				'title' => esc_html__( 'Content','giornale'),
				'description' => esc_html__( 'From this section you can manage the typography of the content.','giornale'),
				'type' => 'section',
				'id' => 'content_section',
				'panel' => 'typography_panel',
				'priority' => '12',

			),

			/**
			* Giornale Typography panel > Content section > Font size option
			*/

			array(

				'label' => esc_html__( 'Font size','giornale'),
				'description' => esc_html__( 'Insert a size, for content font (For example, 14px) ','giornale'),
				'id' => 'giornale_content_font_size',
				'type' => 'pixel_size',
				'section' => 'content_section',
				'std' => '14px',

			),

			/* Giornale Typography panel > Headlines section
			========================================================================== */

			array(

				'title' => esc_html__( 'Headlines','giornale'),
				'description' => esc_html__( 'From this section you can manage the typography of the headlines.','giornale'),
				'type' => 'section',
				'id' => 'headlines_section',
				'panel' => 'typography_panel',
				'priority' => '13',

			),

			/**
			* Giornale Typography panel > Headlines section > H1 headline option
			*/

			array(

				'label' => esc_html__( 'H1 headline','giornale'),
				'description' => esc_html__( 'Insert a size, for for H1 elements (For example, 24px) ','giornale'),
				'id' => 'giornale_h1_font_size',
				'type' => 'pixel_size',
				'section' => 'headlines_section',
				'std' => '24px',

			),

			/**
			* Giornale Typography panel > Headlines section > H2 headline option
			*/

			array(

				'label' => esc_html__( 'H2 headline','giornale'),
				'description' => esc_html__( 'Insert a size, for for H2 elements (For example, 22px) ','giornale'),
				'id' => 'giornale_h2_font_size',
				'type' => 'pixel_size',
				'section' => 'headlines_section',
				'std' => '22px',

			),

			/**
			* Giornale Typography panel > Headlines section > H3 headline option
			*/

			array(

				'label' => esc_html__( 'H3 headline','giornale'),
				'description' => esc_html__( 'Insert a size, for for H3 elements (For example, 20px) ','giornale'),
				'id' => 'giornale_h3_font_size',
				'type' => 'pixel_size',
				'section' => 'headlines_section',
				'std' => '20px',

			),

			/**
			* Giornale Typography panel > Headlines section > H4 headline option
			*/

			array(

				'label' => esc_html__( 'H4 headline','giornale'),
				'description' => esc_html__( 'Insert a size, for for H4 elements (For example, 18px) ','giornale'),
				'id' => 'giornale_h4_font_size',
				'type' => 'pixel_size',
				'section' => 'headlines_section',
				'std' => '18px',

			),

			/**
			* Giornale Typography panel > Headlines section > H5 headline option
			*/

			array(

				'label' => esc_html__( 'H5 headline','giornale'),
				'description' => esc_html__( 'Insert a size, for for H5 elements (For example, 16px) ','giornale'),
				'id' => 'giornale_h5_font_size',
				'type' => 'pixel_size',
				'section' => 'headlines_section',
				'std' => '16px',

			),

			/**
			* Giornale Typography panel > Headlines section > H6 headline option
			*/

			array(

				'label' => esc_html__( 'H6 headline','giornale'),
				'description' => esc_html__( 'Insert a size, for for H6 elements (For example, 14px) ','giornale'),
				'id' => 'giornale_h6_font_size',
				'type' => 'pixel_size',
				'section' => 'headlines_section',
				'std' => '14px',

			),

			/**
			* Giornale Typography panel > Headlines section > Titles weight option
			*/

			array(

				'label' => esc_html__('Titles weight','giornale'),
				'description' => esc_html__('Choose a font weight for the titles.','giornale'),
				'id' => 'giornale_titles_font_weight',
				'type' => 'select',
				'section' => 'headlines_section',
				'options' => array(
					'100' => esc_html__( '100','giornale'),
					'200' => esc_html__( '200','giornale'),
					'300' => esc_html__( '300','giornale'),
					'400' => esc_html__( '400','giornale'),
					'500' => esc_html__( '500','giornale'),
					'600' => esc_html__( '600','giornale'),
					'700' => esc_html__( '700','giornale'),
					'800' => esc_html__( '800','giornale'),
					'900' => esc_html__( '900','giornale'),
				),

				'std' => '600',

			),

			/**
			* Giornale Typography panel > Headlines section > Text transform option
			*/

			array(

				'label' => esc_html__('Text transform','giornale'),
				'description' => esc_html__('Do you want to display an uppercase title?.','giornale'),
				'id' => 'giornale_titles_text_transform',
				'type' => 'select',
				'section' => 'headlines_section',
				'options' => array(
					'none' => esc_html__( 'None','giornale'),
					'uppercase' => esc_html__( 'Uppercase','giornale'),
				),

				'std' => 'none',

			),

			/* Giornale Typography panel > Post meta section
			========================================================================== */

			array(

				'title' => esc_html__( 'Post meta','giornale'),
				'description' => esc_html__( 'From this section, you can manage the typography of the post meta.','giornale'),
				'type' => 'section',
				'id' => 'postmeta_section',
				'panel' => 'typography_panel',
				'priority' => '13',

			),

			/**
			* Giornale Typography panel > Post meta section > Font size option
			*/

			array(

				'label' => esc_html__( 'Font size','giornale'),
				'description' => esc_html__( 'Insert a size for the post meta (e.g., 11px)','giornale'),
				'id' => 'giornale_postmeta_font_size',
				'type' => 'pixel_size',
				'section' => 'postmeta_section',
				'std' => '11px',

			),

			/**
			* Giornale Typography panel > Post meta section > Text transform option
			*/

			array(

				'label' => esc_html__('Text transform','giornale'),
				'description' => esc_html__('Do you want to display the post meta in uppercase?','giornale'),
				'id' => 'giornale_postmeta_text_transform',
				'type' => 'select',
				'section' => 'postmeta_section',
				'options' => array(
					'none' => esc_html__( 'None','giornale'),
					'uppercase' => esc_html__( 'Uppercase','giornale'),
				),

				'std' => 'uppercase',

			),

		);

		new giornale_customize($theme_panel);

	}

	add_action( 'giornale_customize_panel', 'giornale_customize_panel_function' );

}

do_action('giornale_customize_panel');

?>
