<?php
/**
 * Custom hooks functions are define about header section.
 *
 * @package AquariusThemes
 * @subpackage Ghumti
 * @since 1.0.0
 */

/*-----------------------------------------------------------------------------------------------------------------------*/
/**
 * header section start
 *
 * @since 1.0.0
 */
if( ! function_exists( 'ghumti_green_header_section_start' ) ) :
	function ghumti_green_header_section_start() {
		echo '<header id="masthead" class="site-header" role="banner">';
	}
endif;

/**
 * header logo and icons section start
 *
 * @since 1.0.0
 */
if( ! function_exists( 'ghumti_green_header_logo_icons_section_start' ) ) :
	function ghumti_green_header_logo_icons_section_start() {
		echo '<div class="ghumti-logo-section-wrapper">';
		echo '<div class="at-container">';
	}
endif;

/**
 * site branding section
 *
 * @since 1.0.0
 */
if( ! function_exists( 'ghumti_green_site_branding_section' ) ) :
	function ghumti_green_site_branding_section() {
		?>
		<div class="site-branding">
			<?php
			if ( has_custom_logo() ) { ?>
				<div class="site-logo">
					<?php the_custom_logo(); ?>
				</div><!-- .site-logo -->
				<?php
			}
			echo '<div class="titletag-wrap">';
			if ( is_front_page() && is_home() ) {
				?>
				<h1 class="site-title">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
				</h1>
				<?php 
			} else {
				?>
				<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php
			}
			$description = get_bloginfo( 'description', 'display' );
			if ( $description || is_customize_preview() ) : ?>
				<p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
				<?php
			endif;
			echo '</div>';
			?>
		</div>
		<!-- .site-branding -->
		<?php
	}
endif;


/**
 * header primary menu section
 *
 * @since 1.0.0
 */
if( ! function_exists( 'ghumti_green_primary_menu_section' ) ) :
	function ghumti_green_primary_menu_section() {
		?>
		<div id="ghumti-menu-wrap" class="ghumti-header-menu-wrapper">
			<div class="ghumti-header-menu-block-wrap">
				<nav id="site-navigation" class="main-navigation" role="navigation">
					<button type="button" class="toggle-btn">
						<span class="toggle-bar"></span>
						<span class="toggle-bar"></span>
						<span class="toggle-bar"></span>
					</button>
					<?php wp_nav_menu( array( 'theme_location' => 'ghumti_primary_menu', 'menu_id' => 'primary-menu' ) );
					?>
				</nav><!-- #site-navigation -->
			</div>
		</div><!-- .ghumti-header-menu-wrapper -->
		<?php
	}
endif;


/**
 * Logo header left section
 *
 * @since 1.0.0
 */
if( ! function_exists( 'ghumti_green_logo_left_section' ) ) :
	function ghumti_green_logo_left_section() {		
		$ghumti_green_top_social_option = get_theme_mod( 'ghumti_top_social_option', 'show' );
		if( $ghumti_green_top_social_option == 'show' ) {
			?>
			<div class="ghumti-logo-left-section-wrapper">
				<?php
				ghumti_social_media();
				?>
			</div><!-- .ghumti-top-right-section-wrapper -->
			<?php
		}		
	}
endif;

/**
 * Logo header right section
 *
 * @since 1.0.0
 */
if( ! function_exists( 'ghumti_green_logo_right_section' ) ) :
	function ghumti_green_logo_right_section() {
		$ghumti_green_top_icons_option = get_theme_mod( 'ghumti_top_icons_option', 'hide' );
		$ghumti_green_search_icon_option = get_theme_mod( 'ghumti_search_icon_option', 'show' );

		if( $ghumti_green_top_icons_option == 'show' || $ghumti_green_search_icon_option == 'show' ) {
			?>
			<div class="ghumti-logo-right-section-wrapper">
				<?php
				if( $ghumti_green_search_icon_option == 'show' ) {
					?>
					<div class="ghumti-header-search-wrapper">                    
						<button type="button" class="search-main"><i class="fa fa-search"></i></button>
						<div class="search-form-main">
							<?php get_search_form(); ?>
						</div>
					</div><!-- .ghumti-header-search-wrapper -->
				<?php }
				if( $ghumti_green_top_icons_option == 'show' ) {
					?>
					<div class="my-account">
						<button type="button"><i class="fa fa-unlock-alt"></i></button>
						<div class="welcome-user">
							<?php
							//if user is logged in
							if(is_user_logged_in()){
								global $current_user;
								wp_get_current_user();
								?>
								<?php esc_html_e('Welcome', 'ghumti-green')." ";?>
								<a href="<?php echo esc_url(get_permalink( get_option('woocommerce_myaccount_page_id') )); ?>">
									<span class="user-name">
										<?php echo esc_html($current_user->display_name); ?>
									</span>
								</a>
								<?php esc_html_e('!', 'ghumti-green');?>
								<a href="<?php echo esc_url(wp_logout_url()); ?>" class="logout">
									<?php esc_html_e('Logout','ghumti-green'); ?>
								</a>
								<?php
							} else{
								if(is_woocommerce_available()){
									woocommerce_login_form();
									?>
									<a href="<?php echo esc_url(get_permalink( get_option('woocommerce_myaccount_page_id') )); ?>" class="register">
										<?php esc_html_e('Register','ghumti-green'); ?>
									</a>
									<?php
								}else{
									?>
									<a href="<?php echo esc_url(get_permalink( get_option('woocommerce_myaccount_page_id') )); ?>" class="login">
										<?php esc_html_e('Login','ghumti-green'); ?>
									</a>
									<?php 
								}
							}
							?>
						</div>
					</div>
					<!-- Cart Link -->
					<?php 
					if(is_woocommerce_available()):
						?>
						<div class="cart-box">
							<a class="cart-contents" href="<?php echo esc_url( function_exists( 'wc_get_cart_url' ) ? wc_get_cart_url() : $woocommerce->cart->get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'ghumti-green' ); ?>">
								<div class="count">
									<i class="fa fa-shopping-cart"></i>
									<span class="cart-count"><?php echo esc_html(WC()->cart->get_cart_contents_count()); ?></span>
								</div>	               	
							</a>
							<?php the_widget( 'WC_Widget_Cart', 'title=' ); ?>
						</div>
						<?php
					endif;
					?>
					<?php if(class_exists('YITH_WCWL')): ?>
						<div class="wishlist-box">
							<?php $wishlist_count = YITH_WCWL()->count_products(); ?>
							<span class="your-counter-selector"><?php echo esc_html($wishlist_count); ?></span>
							<a title="<?php esc_attr_e('Wishlist','ghumti-green'); ?>" class="wishlist_view" href="<?php echo esc_url(YITH_WCWL()->get_wishlist_url()); ?>"><i class="fa fa-heart" aria-hidden="true"></i></a>
						</div>
					<?php endif;

				}
				?>
			</div><!-- .ghumti-top-right-section-wrapper -->
			<?php
		}
	}
endif;

/**
 * header logo and icons section end
 *
 * @since 1.0.0
 */
if( ! function_exists( 'ghumti_green_header_logo_icons_section_end' ) ) :
	function ghumti_green_header_logo_icons_section_end() {
		echo '</div><!-- .at-container -->';
		echo '</div><!-- .ghumti-logo-section-wrapper -->';
	}
endif;

/**
 * header section end
 *
 * @since 1.0.0
 */
if( ! function_exists( 'ghumti_green_header_section_end' ) ) :
	function ghumti_green_header_section_end() {
		echo '</header><!-- .site-header -->';
	}
endif;

/**
 * Managed functions for ticker section
 *
 * @since 1.0.0
 */
add_action( 'ghumti_green_header_section', 'ghumti_green_header_section_start', 5 );
add_action( 'ghumti_green_header_section', 'ghumti_green_header_logo_icons_section_start', 10 );
add_action( 'ghumti_green_header_section', 'ghumti_green_site_branding_section', 15 );
add_action( 'ghumti_green_header_section', 'ghumti_green_primary_menu_section', 20 );
add_action( 'ghumti_green_header_section', 'ghumti_green_logo_left_section', 25 );
add_action( 'ghumti_green_header_section', 'ghumti_green_logo_right_section', 30 );
add_action( 'ghumti_green_header_section', 'ghumti_green_header_logo_icons_section_end', 35 );
add_action( 'ghumti_green_header_section', 'ghumti_green_header_section_end', 40 );