<?php
/**
 * Describe child theme functions
 *
 * @package Ghumti
 * @subpackage Ghumti Green
 * 
 */

if ( ! function_exists( 'ghumti_green_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function ghumti_green_setup() {

    $ghumti_green_theme_info = wp_get_theme();
    $GLOBALS['ghumti_green_version'] = $ghumti_green_theme_info->get( 'Version' );
}
endif;

add_action( 'after_setup_theme', 'ghumti_green_setup' );

/**
 * Add the theme color
 */
function ghumti_green_customize_register( $wp_customize ) {
	global $wp_customize;

	//Theme Color Setups
    $wp_customize->add_section('ghumti_green_color_setups',array(
        'priority' => '01',
        'capability' => 'edit_theme_options',
        'theme_supports' => '',
        'title' => __('Theme Color Setups','ghumti-green'),
        'description' => __('Manage Theme Colors Setups for the site','ghumti-green')
    ));

    $wp_customize->add_setting('ghumti_green_theme_primary_color', array(
        'default' => '#03a57f',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

    $wp_customize->add_control( new WP_Customize_Color_Control($wp_customize , 'ghumti_green_theme_primary_color',array(
        'label' => __('Choose Theme Primary Color.','ghumti-green'),
        'description' => __('This will replace the default primary theme color of green(#03a57f).','ghumti-green'),
        'section' => 'ghumti_green_color_setups',
    )));

}

add_action( 'customize_register', 'ghumti_green_customize_register', 20 );

/**
 * Enqueue child theme styles and scripts
 */
add_action( 'wp_enqueue_scripts', 'ghumti_green_scripts', 20 );

function ghumti_green_scripts() {

    global $ghumti_green_version;
    
    wp_dequeue_style( 'ghumti-style' );
    wp_dequeue_style( 'ghumti-responsive' );
    wp_dequeue_style( 'ghumti-keyboard' );
    
    wp_enqueue_style( 'ghumti-green-style', get_template_directory_uri() . '/style.css', array(), esc_attr( $ghumti_green_version ) );
    
    wp_enqueue_style( 'ghumti-green-responsive', get_template_directory_uri() . '/assets/css/ghumti-responsive.css', array(), esc_attr( $ghumti_green_version ) );
    wp_enqueue_style( 'ghumti-green-keyboard', get_template_directory_uri() . '/assets/css/ghumti-keyboard.css', array(), esc_attr( $ghumti_green_version ) );

    wp_enqueue_style( 'ghumti-green', get_stylesheet_uri(), array(), esc_attr( $ghumti_green_version ) );


    $ghumti_green_theme_color = esc_attr( get_theme_mod( 'ghumti_green_theme_primary_color', '#03a57f' ) );
    

    $ghumti_green_output_css = '';
    $ghumti_green_output_css .= "table tr th,
    button,
    input[type='button'],
    input[type='reset'],
    input[type='submit'],
    .nav-links .pagination-btn:hover,
    .nav-links .pagination-btn.current,
    .post-edit-link,
    .ghumti-top-header-wrap,
#ghumti-scrollup:hover,
    .ghumti-ticker-wrapper .ticker-caption,
    .ticker-content-wrapper .owl-carousel .owl-nav [class*='owl-']:hover,
    .ghumti-social-icons-wrapper .social-link a:hover,
    .ghumti-logo-right-section-wrapper .my-account:hover, 
    .ghumti-logo-right-section-wrapper .cart-box:hover, 
    .ghumti-logo-right-section-wrapper .wishlist-box:hover,
    .cart-box .cart-count, 
    .wishlist-box .your-counter-selector,
    .mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
    .mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar, 
    .mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar, 
    .mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar,
    .main-navigation ul li ul,
    a.ghumti-read-more:hover, 
    .ghumti-main-slider li a.ghumti-read-more:hover,
    .comments-link a,
    .ghumti_cat_product .owl-nav button[class*='owl-'],
    .woocommerce #respond input#submit:hover, 
    .woocommerce a.button:hover, 
    .woocommerce button.button:hover, 
    .woocommerce input.button:hover, 
    .single-product .entry-summary .yith-wcwl-add-to-wishlist .add_to_wishlist:hover, 
    .product .button:hover, 
    .item-content-wrap .button:hover,
    span.onsale, 
    .woocommerce span.onsale, 
#yith-quick-view-content .onsale,
    .ghumti-product-slider.owl-carousel .owl-nav button[class*='owl-']:hover,
    .ghumti_product_carousel .title-price-wrap a:hover,
    .ghumti_product_carousel .title-price-wrap a + a,
    .ghumti_product_carousel .title-price-wrap a.button.yith-wcqv-button:hover,
    .single .site-main .post-cats-list span a:hover,
    .woocommerce #respond input#submit.loading, 
    .woocommerce a.button.loading, 
    .woocommerce button.button.loading, 
    .woocommerce input.button.loading,
    .woocommerce #respond input#submit.disabled, 
    .woocommerce #respond input#submit:disabled, 
    .woocommerce #respond input#submit:disabled[disabled], 
    .woocommerce a.button.disabled, 
    .woocommerce a.button:disabled, 
    .woocommerce a.button:disabled[disabled], 
    .woocommerce button.button.disabled, 
    .woocommerce button.button:disabled, 
    .woocommerce button.button:disabled[disabled], 
    .woocommerce input.button.disabled, 
    .woocommerce input.button:disabled, 
    .woocommerce input.button:disabled[disabled],
    .woocommerce #respond input#submit.disabled:hover, 
    .woocommerce #respond input#submit:disabled:hover, 
    .woocommerce #respond input#submit:disabled[disabled]:hover, 
    .woocommerce a.button.disabled:hover, 
    .woocommerce a.button:disabled:hover, 
    .woocommerce a.button:disabled[disabled]:hover, 
    .woocommerce button.button.disabled:hover, 
    .woocommerce button.button:disabled:hover, 
    .woocommerce button.button:disabled[disabled]:hover, 
    .woocommerce input.button.disabled:hover, 
    .woocommerce input.button:disabled:hover, 
    .woocommerce input.button:disabled[disabled]:hover,
    .main-navigation .toggle-btn:hover .toggle-bar,
    .main-navigation .nav-menu .close:hover::before, 
    .main-navigation .nav-menu .close:hover::after,
    .ghumti_special_product .item-content-wrap .fl-pcountdown-cnt ul li,
    .my-account .welcome-user,
    .ghumti_block_posts .ghumti-single-post .ghumti-post-thumb .posted-on
    { background: ". esc_attr( $ghumti_green_theme_color ) ."}\n";

    $ghumti_green_output_css .= ".woocommerce #respond input#submit.alt:hover, 
    .woocommerce a.button.alt:hover, 
    .woocommerce button.button.alt:hover, 
    .woocommerce input.button.alt:hover
    { background-color: ". esc_attr( $ghumti_green_theme_color ) ."}\n";

    $ghumti_green_output_css .= "a,
    .featured-posts-wrapper .ghumti-post-content a.ghumti-read-more,
    .ghumti-post-meta,
    .ghumti-single-post a.ghumti-read-more, 
    .ghumti-button,
    .product .price, 
    .woocommerce ul.products li.product .price,
    .woocommerce div.product p.price, 
    .woocommerce div.product span.price,
    .comments-area ol li article .comment-awaiting-moderation,
    .ghumti-sale-slide .item-content-wrap .price
    { color: ". esc_attr( $ghumti_green_theme_color ) ."}\n";

    $ghumti_green_output_css .= "a:hover,
    .post-navigation a:hover,
    .widget ul li a:hover,
    .entry-title a:hover,
    .entry-meta > span a:hover,
    .post-edit-link:hover,
    .nav-links a:hover,
    .woocommerce nav.woocommerce-pagination ul li a:focus, 
    .woocommerce nav.woocommerce-pagination ul li a:hover, 
    .woocommerce nav.woocommerce-pagination ul li span.current,
    .ticker-content-wrapper ul.owl-carousel li a:hover,
    .cart-box:hover .cart-count, 
    .wishlist-box:hover .your-counter-selector,
    .cart-box .widget_shopping_cart ul.product_list_widget li a:not(.remove):hover,
    .main-navigation ul.nav-menu > li:hover > a, 
    .main-navigation ul.nav-menu > li.current-menu-item > a, 
    .main-navigation ul.nav-menu > li.current_page_item > a,
    .ghumti-header-search-wrapper .search-main:hover,
    .featured-posts-wrapper .ghumti-post-content a.ghumti-read-more:hover,
    .ghumti-post-title a:hover,
    .product a:hover,
    .tagcloud a:hover,
    .main-footer .footer-navigation ul li a:hover, 
    .main-footer .footer-navigation ul li.current-menu-item > a, 
    .main-footer .footer-navigation ul li.current_page_item > a,
    .site-info a:hover,
    .ghumti-related-posts-wrap .ghumti-post-meta > span a:hover,
    .comments-area ol li .comment-author a:hover,
    .comments-area ol li .comment-metadata a:hover,
    .woocommerce table.shop_table td a:hover,
    .main-navigation ul ul li.current-menu-item > a, 
    .main-navigation ul ul li.current_page_item > a
    { color: ". esc_attr( $ghumti_green_theme_color ) ."}\n";

    $ghumti_green_output_css .= ".nav-links .pagination-btn:hover,
    .nav-links .pagination-btn.current,
    .post-edit-link,
    .woocommerce nav.woocommerce-pagination ul li a:focus, 
    .woocommerce nav.woocommerce-pagination ul li a:hover, 
    .woocommerce nav.woocommerce-pagination ul li span.current,
    .ghumti-ticker-wrapper,
    .ghumti-ticker-wrapper .ticker-caption::after,
    a.ghumti-read-more:hover, 
    .ghumti-main-slider li a.ghumti-read-more:hover,
    .woocommerce #respond input#submit:hover, 
    .woocommerce a.button:hover, 
    .woocommerce button.button:hover, 
    .woocommerce input.button:hover, 
    .single-product .entry-summary .yith-wcwl-add-to-wishlist .add_to_wishlist:hover, 
    .product .button:hover, 
    .item-content-wrap .button:hover,
    .ghumti-product-slider.owl-carousel .owl-nav button[class*='owl-']:hover,
    .tagcloud a:hover,
    .ghumti_product_carousel .title-price-wrap a:hover,
    .ghumti_product_carousel .title-price-wrap a + a,
    .comments-area ol li.bypostauthor > article,
    .woocommerce #respond input#submit.loading, 
    .woocommerce a.button.loading, 
    .woocommerce button.button.loading, 
    .woocommerce input.button.loading,
    .woocommerce #respond input#submit.disabled, 
    .woocommerce #respond input#submit:disabled, 
    .woocommerce #respond input#submit:disabled[disabled], 
    .woocommerce a.button.disabled, 
    .woocommerce a.button:disabled, 
    .woocommerce a.button:disabled[disabled], 
    .woocommerce button.button.disabled, 
    .woocommerce button.button:disabled, 
    .woocommerce button.button:disabled[disabled], 
    .woocommerce input.button.disabled, 
    .woocommerce input.button:disabled, 
    .woocommerce input.button:disabled[disabled]
    { border-color: ". esc_attr( $ghumti_green_theme_color ) ."}\n";

    $ghumti_green_output_css .= ".ghumti-header-menu-block-wrap
    { border-top-color: ". esc_attr( $ghumti_green_theme_color ) ."}\n";

    $ghumti_green_output_css .= ".nav-links a:hover,
    .posts-navigation .nav-links a:hover,
    .ghumti-header-menu-block-wrap
    { border-bottom-color: ". esc_attr( $ghumti_green_theme_color ) ."}\n";

    $header_bg_v = get_header_image();

    if(($header_bg_v)){
        $ghumti_green_output_css .=   '.site-header { background: url("'.esc_url($header_bg_v).'") no-repeat scroll left top rgba(0, 0, 0, 0); position: relative; background-size: cover; z-index: 2; }';
        $ghumti_green_output_css .= "\n";
        $ghumti_green_output_css .= '.site-header:before {
            content: "";
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(255,255,255,0.8);
            z-index: -1;
        }';
        $ghumti_green_output_css .= "\n";
    }

    $refine_ghumti_green_output_css = ghumti_green_clean( $ghumti_green_output_css );

    wp_add_inline_style( 'ghumti-green', $refine_ghumti_green_output_css );
    
}

if( ! function_exists( 'ghumti_green_clean' ) ) :

    /**
     * Get minified css and removed space
     *
     * @since 1.0.0
     */

    function ghumti_green_clean( $css ){
        $replace = array(
            "#/\*.*?\*/#s" => "",  // Strip C style comments.
            "#\s\s+#"      => " ", // Strip excess whitespace.
        );
        $search = array_keys( $replace );
        $css = preg_replace( $search, $replace, $css );

        $replace = array(
            ": "  => ":",
            "; "  => ";",
            " {"  => "{",
            " }"  => "}",
            ", "  => ",",
            "{ "  => "{",
            ";}"  => "}", // Strip optional semicolons.
            ",\n" => ",", // Don't wrap multiple selectors.
            "\n}" => "}", // Don't wrap closing braces.
            "} "  => "}\n", // Put each rule on it's own line.
        );
        $search = array_keys( $replace );
        $css = str_replace( $search, $replace, $css );

        return trim( $css );
    }

endif;


if ( class_exists( 'WooCommerce' ) ) {
    get_template_part('inc/widgets/ghumti','product-grid');  // Product grid widget
}
if ( class_exists( 'WooCommerce' ) ) {
    register_widget( 'ghumti_product_grid' );
}

require get_stylesheet_directory() . '/inc/ghumti-header-hooks.php';