<?php
/**
 * Displays all of the header section for main-home-page template
 *
 * @package Ghazale
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">
    <a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'ghazale' ); ?></a>

    <header id="masthead" class="site-header" role="banner">

        <div class="site-branding-main" style="background-image: url(<?php header_image(); ?>)">
            <nav id="site-navigation" class="main-navigation main-page-nav" role="navigation">
                <div id="search-container" class="search-box-wrapper clear">
                    <div class="search-box clear">
                        <?php get_search_form(); ?>
                    </div>
                </div>
                <div class="search-toggle">
                    <i class="fa fa-search"></i>
                    <a href="#search-container" class="screen-reader-text"><?php _e( 'Search', 'ghazale' ); ?></a>
                </div>
                <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php _e( 'Menu', 'ghazale' ); ?></button>
                <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>

            </nav><!-- #site-navigation -->
            <div class="site-social-top-mainpage">
                <div class="social-icon-box-mainpage">
                    <?php sh_ghazale_social_menu(); ?>
                </div>
            </div>
            <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
            <?php if (get_theme_mod('logo') !=''){ ?>
                <div class="logo-align">
                    <div class="logo-circle">
                        <?php echo '<img src="' . esc_html(get_theme_mod('logo', get_template_directory_uri() .'/images/logo.png')). '" class= "site-logo" >'; ?>
                    </div>
                </div>
            <?php } ?>
                <h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
            <div class="arrow-down">
                <nav>
                    <i class="fa fa-arrow-circle-o-down active" data-scroll-nav='0'></i>
                </nav>
            </div>

        </div><!-- .site-branding -->
    </header><!-- #masthead -->
    <div id="content" class="site-content-main">
    </div>
</div>
