<?php
/**
 * sh_ghazale functions and definitions
 *
 * @package Ghazale
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 900; /* pixels */
}

if ( ! function_exists( 'sh_ghazale_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function sh_ghazale_setup() {

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on sh_ghazale, use a find and replace
	 * to change 'ghazale' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'ghazale', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'ghazale' ),
        'social' => __('Social Menu' , 'ghazale'),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside', 'image', 'video', 'quote', 'link',
	) );
    $args = array(
        'default-color'          => '',
        'default-image'          => '',
        'default-repeat'         => '',
        'default-position-x'     => '',
        'default-attachment'     => '',
        'wp-head-callback'       => '_custom_background_cb',
        'admin-head-callback'    => '',
        'admin-preview-callback' => ''
    );
    add_theme_support( "custom-background" , $args);
}
endif; // sh_ghazale_setup
add_action( 'after_setup_theme', 'sh_ghazale_setup' );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function sh_ghazale_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'ghazale' ),
		'id'            => 'sidebar-1',
		'description'   => __('Widgets in this area appear on the right of the page or post','ghazale'),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );

    register_sidebar( array(
        'name'          => __( 'Footer Widgets', 'ghazale' ),
        'id'            => 'sidebar-2',
        'description'   => __('Widgets in this area appear in the footer of the site','ghazale'),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h1 class="widget-title">',
        'after_title'   => '</h1>',
    ) );

}
add_action( 'widgets_init', 'sh_ghazale_widgets_init' );

function sh_ghazale_fonts_url() {
    $fonts_url = '';

    /* Translators: If there are characters in your language that are not
    * supported by Lora, translate this to 'off'. Do not translate
    * into your own language.
    */
    $raleway = _x( 'on', 'Raleway font: on or off', 'ghazale' );

    if ( 'off' !== $raleway ) {
        $font_families = array();

        if ( 'off' !== $raleway ) {
            $font_families[] = 'Raleway:700,800,400,300';
        }

        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
        $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );

    }
    return esc_url_raw( $fonts_url );
}


function sh_ghazale_editor_styles() {
    add_editor_style( array( 'inc/editor-style.css', sh_ghazale_fonts_url() ) );
}
add_action( 'after_setup_theme', 'sh_ghazale_editor_styles' );
/**
 * Enqueue scripts and styles.
 */
function sh_ghazale_scripts() {
	wp_enqueue_style( 'sh_ghazale-style', get_stylesheet_uri() );

    wp_enqueue_style('sh_ghazale_fonts',sh_ghazale_fonts_url(), array(), null);

    wp_enqueue_style('font-awesome',get_template_directory_uri() .'/css/font-awesome.css');

    if (is_page_template('page-templates/page-no-sidebar.php')) {
        wp_enqueue_style( 'sh_ghazale-layout-style' , get_template_directory_uri() . '/layouts/no-sidebar.css');
    } else {
        wp_enqueue_style( 'sh_ghazale-layout-style' , get_template_directory_uri() . '/layouts/content-sidebar.css');
    }

	wp_enqueue_script( 'sh_ghazale-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );

    wp_enqueue_script( 'sh_ghazale-masonry', get_template_directory_uri() . '/js/masonry-footer-widgets.js', array('masonry'), '20150412', true );

    wp_enqueue_script( 'sh_ghazale-search-toggle', get_template_directory_uri() . '/js/search-toggle.js', array('jquery'), '20150412', true );

    wp_enqueue_script( 'scrollit', get_template_directory_uri() . '/js/scrollIt.js', array('jquery'), '20150412', true );

    wp_enqueue_script( 'sh_ghazale-scroll-content', get_template_directory_uri() . '/js/scroll-content.js', array('jquery'), '20150412', true );

	wp_enqueue_script( 'sh_ghazale-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'sh_ghazale_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Gets icons from font awesome
 */