<?php
/**
 * @package Ghazale
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="index-box">
        <div class="article-separator">
            <div class="article-separate-line">
            </div>
        </div>


	<header class="entry-header">
        <?php
        if (has_post_thumbnail()) {
            echo '<div class="small-index-thumbnail clear">';
            echo '<a href="' . esc_url(get_permalink()) . '" title="' . esc_attr__('Read ', 'ghazale') . esc_attr(get_the_title()) . '" rel="bookmark">';
            echo the_post_thumbnail('index-thumb');
            echo '</a>';
            echo '</div>';
        }
        ?>

		<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>

		<?php if ( 'post' == get_post_type() ) : ?>
		<div class="entry-meta">
			<?php sh_ghazale_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
        <?php
        if(is_sticky()){
            echo '<i class="fa fa-bookmark sticky-post"></i>';
        }
        ?>
		<?php
			/* translators: %s: Name of current post */
			the_excerpt();
		?>

		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'ghazale' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->


        <footer class="entry-footer continue-reading">
            <?php echo '<a href="' . esc_url(get_permalink()) . '" title="' . esc_attr__('Continue Reading ', 'ghazale') . esc_attr(get_the_title()) . '" rel="bookmark">'. __('Continue Reading', 'ghazale') .'<i class="fa fa-arrow-circle-o-right"></i></a>'; ?>
            <?php edit_post_link( __( 'Edit', 'ghazale' ), '<span class="edit-link">', '</span>' ); ?>
        </footer><!-- .entry-footer -->
    </div><!-- .index-box -->
</article><!-- #post-## -->
