<?php
    if ( is_home() ) {
        if ( has_post_thumbnail(get_option( 'page_for_posts' )) ) {
            $image_url = get_the_post_thumbnail_url(get_option( 'page_for_posts' ), 'gavel-hero');
        } else {
            $image_url = false;
        }
    } else {
        if ( has_post_thumbnail() ) {
            $image_url = get_the_post_thumbnail_url($post, 'gavel-hero');
        } else {
            $image_url = false;
        }
    }
?>

<div class="middle<?php echo (!$image_url) ? ' middle--no-image' : '' ?>">
    <div class="middle__image" style="background-image: url('<?php echo esc_url($image_url); ?>');"></div>
    <?php 
    	if (is_home()) {
    		$title = __('Blog', 'gavel');
    	} elseif (is_category()) {
    		$title = __('Archive for the', 'gavel') . ' &#8216;' . single_cat_title('', false) . '&#8217; ' . __('Category', 'gavel');
    	} elseif (is_tag()) {
    		$title = __('Posts Tagged', 'gavel') . ' &#8216;' . single_cat_title('', false) . '&#8217;';
    	} elseif (is_day()) {
    		$title = __('Archive for', 'gavel') . ' ' . get_the_time('F jS, Y');
    	} elseif (is_month()) {
    		$title = __('Archive for', 'gavel') . ' ' . get_the_time('F Y');
    	} elseif (is_year()) {
    		$title = __('Archive for', 'gavel') . ' ' . get_the_time('Y');
    	} elseif (is_author()) {
    		$title = __('Author Archive', 'gavel');
        } elseif (is_archive()) {
            $title = __('Archives', 'gavel');
        } elseif (is_search()) {
            $title = __('Search results for', 'gavel') . ' &#8216;' . get_search_query() . '&#8217;';
        } elseif (is_404()) {
            $title = __('Error 404: Page not found', 'gavel');
    	} else {
    		$title = get_the_title();
    	}
    ?>
    <h1 class="middle__title"><?php echo $title; ?></h1>
</div>
