<div <?php post_class('article article--excerpt') ?> id="post-<?php the_ID(); ?>">
    <?php 
        if (is_sticky()) { ?>
            <div class="button before-title">
                <span class="button__link">Sticky <i class="material-icons">flag</i></span>
            </div>
        <?php }
    ?>
	<h2 class="article__title"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
	<div class="article__thumbnail">
		<?php the_post_thumbnail( $size = 'gavel-post-thumbnail' ); ?>
	</div>
    <div class="article__entry">
        <?php //the_excerpt(); ?>
        <?php the_content(); //temporary for testing ?>
    </div>
    <div class="article__meta">
    	<div>
    		<span><i class="material-icons">access_time</i> <?php the_time(get_option('date_format')) ?></span>
    	    <span><i class="material-icons">person</i> <?php the_author() ?></span>
            <span><i class="material-icons">forum</i> <?php comments_popup_link(__('No Comments &#187;', 'gavel'), __('1 Comments &#187;', 'gavel'), __('% Comments &#187;', 'gavel')); ?></span>
            <?php if (has_category()) { ?>
                <span><i class="material-icons">work</i> <?php the_category(', ') ?></span>
            <?php } ?>
        	<?php the_tags('<span><i class="material-icons">label</i>', ', ', '</span>'); ?>
        </div>
        <div class="read-more">
        	<a title="<?php esc_attr_e( 'Read More', 'gavel' ); ?>" href="<?php the_permalink() ?>"><?php _e( 'Read More ', 'gavel' ); ?>&raquo;</a>
        </div>
    </div>
</div>