
(function(){
  const dropdowns = document.querySelectorAll('.dropdown ul');
  
  if (dropdowns) {
    for (let dropdown of dropdowns) {
      for (let listItem of dropdown.childNodes) {
        if (listItem.nodeName == 'LI') {        
          for (let listItemChild of listItem.childNodes) {
            if (listItemChild.nodeName == 'UL') {
              hoverintent(listItem, function() {
                this.classList.add('hover');
              }, function() {
                this.classList.remove('hover');
              });
            }   
          }        

          if (listItem.classList.contains('page_item_has_children') || listItem.classList.contains('menu-item-has-children')) {
            for (let listItemChild of listItem.childNodes) {
              if (listItemChild.nodeName == 'A') {
                listItemChild.innerHTML += '<i class="material-icons">keyboard_arrow_right</i>';
              }   
            }       
          }
        }
      }
    }
  }
})();
(function(){
  'use strict';

  // Config
  // -------------
  
  // the point at which the header should go back to being static
  const staticTriggerPoint = 40;
  // the point at which the header should become fixed
  const fixedTriggerPoint = 500;  
  // the delay after the user stops scrolling before the header animates
  const delay = 500;
  // from $header-breakpoint in scss
  const headerBreakpoint = 1000;
  
  // State
  // -------------
  
  // variables
  const doc = document.documentElement;
  const body = document.body;
  const headerHeight = document.querySelector('.header-wrapper').offsetHeight;
  const adminBarHeight = 32;
  let isScrolling;
  
  // doc.style.setProperty('--header-height', headerHeight);

  // place the styles in the head since css variables do not work in IE11
  const css = 
`@media screen and (min-width: ${headerBreakpoint}px) {
  body.fixed-header { 
    padding-top: ${headerHeight}px; 
  }
  body.fixed-header.admin-bar .header-wrapper {
    top: ${(headerHeight * -1) + adminBarHeight}px;
  }
  body.fixed-header.show-fixed-header.admin-bar .header-wrapper {
    top: ${adminBarHeight}px;
  }
}
`;
  const head = document.head || document.getElementsByTagName('head')[0];
  const style = document.createElement('style');
  style.appendChild(document.createTextNode(css));
  head.appendChild(style);

  // listen for scroll event
  window.addEventListener('scroll', function(){
    const y = (window.pageYOffset || doc.scrollTop) - (doc.clientTop || 0);
    
    // While the user is scrolling, check to see if they have scrolled up past
    // the trigger point to where the header was static, then remove the fixed header classes
    if (y <= staticTriggerPoint) {
      body.classList.remove('fixed-header', 'show-fixed-header');
    } else {
      // Wait until the user has finished scrolling
      window.clearTimeout(isScrolling);
      isScrolling = setTimeout(() => {
        if (y <= staticTriggerPoint) {
          body.classList.remove('fixed-header', 'show-fixed-header');
        }     
        // If the user scrolls below the trigger point, prepare the fixed
        // header animation and then perform the slide down animation
        if (!body.classList.contains('show-fixed-header') && y >= fixedTriggerPoint) {  
          promiseTimeout(0).then(() => {
            body.classList.add('fixed-header');
            return promiseTimeout(delay);
          }).then(() => {
            body.classList.add('show-fixed-header');
          });
          
        // If the header is fixed and the user scrolls back up above the trigger point,
        // animate the fixed header to slide up above the visible window
        } else if (body.classList.contains('show-fixed-header') && y < fixedTriggerPoint && y > staticTriggerPoint) {       
          promiseTimeout(delay).then(() => {
            body.classList.remove('show-fixed-header');
          })
        }
      }, 60);
    }
  });
  
  // Promise helper function
  function promiseTimeout(time) {
    return new Promise(resolve => {
      setTimeout(resolve, time)
    })
  }
})();
document.addEventListener('DOMContentLoaded', function(){
  var button = document.querySelector('.menu-toggle');
  
  button.addEventListener('click', function(){
    this.parentNode.classList.toggle('open');
  })
})
//silence