<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <div class="header-wrapper">
    	<div class="header grid">			
			<h1 class="header__logo">
			    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" 
			    	class="no-logo"
			    	title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"
			    	rel="home"><?php bloginfo( 'name' ); ?></a>
			</h1>
	        <nav class="header__nav dropdown">
	            <?php 
		            $menu = wp_nav_menu(array( 
		            	'echo'				=> false,
		            	'theme_location' 	=> 'primary', 
		            )); 
		            // check if wp_nav_menu actually contains a list item
		            if (!empty($menu) && strpos($menu, '<li') !== false) {
		            	echo gavel_get_mobile_nav_button();
		            	echo $menu;
		            } 
	            ?>
	        </nav>
	    </div>
    </div>