<?php

$gavel_ver = '1.0.9';

// Include all modules
function gavel_modules() {
	$path = get_template_directory() . '/modules/*';
	$dirs = array_filter(glob($path), 'is_dir');
	foreach ($dirs as $dir) {
		$dir_name = basename($dir);
		get_template_part( 'modules/' . $dir_name . '/' . $dir_name );
	}
} gavel_modules();

// Image sizes
add_image_size( 'gavel-logo', 400, 90, false );
add_image_size( 'gavel-hero', 1900, 450, true );
add_image_size( 'gavel-post-thumbnail', 900, 300, true );

// Enqueue WordPress theme styles within Gutenberg.
function gavel_editor_styles() {
	global $gavel_ver;
	wp_enqueue_style( 'gavel-editor', get_stylesheet_directory_uri() . '/css/editor.css', null, $gavel_ver );
}
add_action( 'enqueue_block_editor_assets', 'gavel_editor_styles' );

// Enqueue scripts
function gavel_theme_styles_and_scripts() {
	global $gavel_ver;
	wp_enqueue_style( 'gavel-theme-style', get_stylesheet_directory_uri() . '/css/main.min.css', null, $gavel_ver );
	wp_enqueue_style( 'gavel-google-fonts', '//fonts.googleapis.com/css?family=Open+Sans:400,400i,600,600i,700,700i');
	wp_enqueue_style( 'material-icons', '//fonts.googleapis.com/icon?family=Material+Icons' );
		
	wp_enqueue_script( 'gavel-theme-js', get_template_directory_uri() . '/js/all.min.js', null, $gavel_ver, true );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'gavel_theme_styles_and_scripts' );


// Register navigations
function gavel_navigations() {
	register_nav_menus( array(
		'primary' => __('Primary Menu', 'gavel'),
	));
}
add_action( 'after_setup_theme', 'gavel_navigations' );

// Register sidebars
function gavel_sidebars() {
    register_sidebar(array(
    	'name' 	=> __('Footer', 'gavel'),
    	'id'	=> 'footer',
    	'description'	=> __('Widgets for the footer on each page.', 'gavel'),
    	'before_widget'	=> '<div class="widget %2$s" id="%1$s">',
    	'after_widget'	=> '</div>',
    	'before_title'  => '<h3 class="widget__title">',
    	'after_title'   => '</h3>'
    ));
}
add_action( 'widgets_init', 'gavel_sidebars' );

// Modify the excerpt read more text
function gavel_excerpt_more($more) {
	if (!is_admin()) {
		global $post;
		return '...';
	}
}
add_filter('excerpt_more', 'gavel_excerpt_more');

// Viewport meta for the <head>
function gavel_mobile_viewport() {
	echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
}
add_action('wp_head', 'gavel_mobile_viewport');

// Add support for automatic feed links
// Let WordPress manage the document <title>
// Set the content width
function gavel_theme_setup() {
	// Theme support
	add_theme_support( 'post-thumbnails' ); 
	add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'title-tag' );
	$GLOBALS['content_width'] = apply_filters( 'gavel_content_width', 1100 );
}
add_action( 'after_setup_theme', 'gavel_theme_setup', 0 );

// check if blog page is set
// get home page url and title 
function gavel_get_home_page() {
	$home = Array();
	$home_id = get_option('page_for_posts');
	if ($home_id === '0') {
		$home['url'] = get_home_url();
		$home['title'] = __('Blog', 'gavel');
	} else {
		$home['url'] = get_permalink($home_id);
		$home['title'] = get_the_title($home_id);
	}
	return $home;
}