<?php

add_action( 'admin_menu', 'garden_lawn_care_gettingstarted' );
function garden_lawn_care_gettingstarted() {
	add_theme_page( esc_html__('Begin Installation', 'garden-lawn-care'), esc_html__('Begin Installation', 'garden-lawn-care'), 'edit_theme_options', 'garden-lawn-care-guide-page', 'garden_lawn_care_guide');
}

if ( ! defined( 'GARDEN_LAWN_CARE_SUPPORT' ) ) {
define('GARDEN_LAWN_CARE_SUPPORT',__('https://wordpress.org/support/theme/garden-lawn-care/','garden-lawn-care'));
}
if ( ! defined( 'GARDEN_LAWN_CARE_REVIEW' ) ) {
define('GARDEN_LAWN_CARE_REVIEW',__('https://wordpress.org/support/theme/garden-lawn-care/reviews/','garden-lawn-care'));
}
if ( ! defined( 'GARDEN_LAWN_CARE_LIVE_DEMO' ) ) {
define('GARDEN_LAWN_CARE_LIVE_DEMO',__('https://trial.ovationthemes.com/garden-lawn-care-pro/','garden-lawn-care'));
}
if ( ! defined( 'GARDEN_LAWN_CARE_BUY_PRO' ) ) {
define('GARDEN_LAWN_CARE_BUY_PRO',__('https://www.ovationthemes.com/products/lawn-care-wordpress-theme','garden-lawn-care'));
}
if ( ! defined( 'GARDEN_LAWN_CARE_PRO_DOC' ) ) {
define('GARDEN_LAWN_CARE_PRO_DOC',__('https://trial.ovationthemes.com/docs/ot-garden-lawn-care-pro-doc/','garden-lawn-care'));
}
if ( ! defined( 'GARDEN_LAWN_CARE_FREE_DOC' ) ) {
define('GARDEN_LAWN_CARE_FREE_DOC',__('https://trial.ovationthemes.com/docs/ot-garden-lawn-care-free-doc/','garden-lawn-care'));
}
if ( ! defined( 'GARDEN_LAWN_CARE_THEME_NAME' ) ) {
define('GARDEN_LAWN_CARE_THEME_NAME',__('Premium Garden Lawn Care Theme','garden-lawn-care'));
}
if ( ! defined( 'GARDEN_LAWN_CARE_BUNDLE_LINK' ) ) {
define('GARDEN_LAWN_CARE_BUNDLE_LINK',__('https://www.ovationthemes.com/products/wordpress-bundle','garden-lawn-care'));
}
/**
 * Theme Info Page
 */
function garden_lawn_care_guide() {

	// Theme info
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( '' ); ?>

	<div class="getting-started__header">
		<div class="header-box-left">
			<h2><?php echo esc_html( $theme ); ?></h2>
			<p><?php esc_html_e('Version: ', 'garden-lawn-care'); ?><?php echo esc_html($theme['Version']);?></p>
		</div>
		<div class="header-box-right">
			<div class="btn_box">
				<a class="button-primary" href="<?php echo esc_url( GARDEN_LAWN_CARE_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'garden-lawn-care'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( GARDEN_LAWN_CARE_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support', 'garden-lawn-care'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( GARDEN_LAWN_CARE_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'garden-lawn-care'); ?></a>
			</div>
		</div>
	</div>

	<div class="wrap getting-started">
		<div class="box-container">
			<div class="box-left-main">
				<div class="leftbox">
					<h3><?php esc_html_e('Documentation','garden-lawn-care'); ?></h3>
					<p><?php $theme = wp_get_theme(); 
						echo wp_kses_post( apply_filters( 'description', esc_html( $theme->get( 'Description' ) ) ) );
					?></p>

					<h4><?php esc_html_e('Edit Your Site','garden-lawn-care'); ?></h4>
					<p><?php esc_html_e('Now create your website with easy drag and drop powered by gutenburg.','garden-lawn-care'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( admin_url() . 'site-editor.php' ); ?>" target="_blank"><?php esc_html_e('Edit Your Site','garden-lawn-care'); ?></a>

					<h4><?php esc_html_e('Visit Your Site','garden-lawn-care'); ?></h4>
					<p><?php esc_html_e('To check your website click here','garden-lawn-care'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( home_url() ); ?>" target="_blank"><?php esc_html_e('Visit Your Site','garden-lawn-care'); ?></a>

					<h4><?php esc_html_e('Theme Documentation','garden-lawn-care'); ?></h4>
					<p><?php esc_html_e('Check the theme documentation to easily set up your website.','garden-lawn-care'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( GARDEN_LAWN_CARE_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation','garden-lawn-care'); ?></a>
				</div>
       	</div>
			<div class="box-right-main">
				<h3><?php echo esc_html(GARDEN_LAWN_CARE_THEME_NAME); ?></h3>
				<img class="garden_lawn_care_img_responsive" style="width: 100%;" src="<?php echo esc_url( $theme->get_screenshot() ); ?>" />
				<div class="pro-links">
					<div class="pro-links-inner">
						<a class="button-primary livedemo" href="<?php echo esc_url( GARDEN_LAWN_CARE_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'garden-lawn-care'); ?></a>
						<a class="button-primary buynow" href="<?php echo esc_url( GARDEN_LAWN_CARE_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Now', 'garden-lawn-care'); ?></a>
						<a class="button-primary docs" href="<?php echo esc_url( GARDEN_LAWN_CARE_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'garden-lawn-care'); ?></a>
					</div>
						<a class="button-primary bundle-btn" href="<?php echo esc_url( GARDEN_LAWN_CARE_BUNDLE_LINK ); ?>" target="_blank"><?php esc_html_e('WordPress Theme Bundle (125+ Themes at Just $99)', 'garden-lawn-care'); ?></a>
				</div>
				<ul style="padding-top:10px">
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'garden-lawn-care');?> </li>                 
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'garden-lawn-care');?> </li>
					<li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'garden-lawn-care');?> </li>
               <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'garden-lawn-care');?> </li>
            </ul>
        	</div>
		</div>
	</div>

<?php }?>