<?php
/**
 * Garden Lawn Care: Customizer
 *
 * @subpackage Garden Lawn Care
 * @since 1.0
 */

function garden_lawn_care_customize_register( $wp_customize ) {

	wp_enqueue_style('customizercustom_css', esc_url( get_template_directory_uri() ). '/inc/customizer/customizer.css');

	// Pro Section
 	$wp_customize->add_section('garden_lawn_care_pro', array(
        'title'    => __('LAWN CARE PREMIUM', 'garden-lawn-care'),
        'priority' => 1,
    ));
    $wp_customize->add_setting('garden_lawn_care_pro', array(
        'default'           => null,
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control(new Garden_Lawn_Care_Pro_Control($wp_customize, 'garden_lawn_care_pro', array(
        'label'    => __('LAWN CARE PREMIUM', 'garden-lawn-care'),
        'section'  => 'garden_lawn_care_pro',
        'settings' => 'garden_lawn_care_pro',
        'priority' => 1,
    )));
}
add_action( 'customize_register', 'garden_lawn_care_customize_register' );


define('GARDEN_LAWN_CARE_PRO_LINK',__('https://www.ovationthemes.com/products/lawn-care-wordpress-theme','garden-lawn-care'));

define('GARDEN_LAWN_CARE_BUNDLE_BTN',__('https://www.ovationthemes.com/products/wordpress-bundle','garden-lawn-care'));

/* Pro control */
if (class_exists('WP_Customize_Control') && !class_exists('Garden_Lawn_Care_Pro_Control')):
    class Garden_Lawn_Care_Pro_Control extends WP_Customize_Control{

    public function render_content(){?>
        <label style="overflow: hidden; zoom: 1;">
	        <div class="col-md upsell-btn">
                <a href="<?php echo esc_url( GARDEN_LAWN_CARE_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE LAWN CARE PREMIUM','garden-lawn-care');?> </a>
	        </div>
            <div class="col-md">
                <img class="garden_lawn_care_img_responsive " src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png">
            </div>
	        <div class="col-md">
                <ul style="padding-top:10px">
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'garden-lawn-care');?> </li>                 
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'garden-lawn-care');?> </li>
                    <li class="upsell-garden_lawn_care"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'garden-lawn-care');?> </li>
                </ul>
        	</div>
            <div class="col-md upsell-btn upsell-btn-bottom">
                <a href="<?php echo esc_url( GARDEN_LAWN_CARE_BUNDLE_BTN ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('WP Theme Bundle (125+ Themes)','garden-lawn-care');?> </a>
            </div>
        </label>
    <?php } }
endif;