<?php
/**
 * Garden Lawn Care functions and definitions
 *
 * @package Garden Lawn Care
 */

if ( ! function_exists( 'garden_lawn_care_setup' ) ) :
function garden_lawn_care_setup() {
	
	if ( ! isset( $content_width ) )
		$content_width = 640; /* pixels */

    load_theme_textdomain( 'garden-lawn-care', get_template_directory() . '/languages' );

	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-logo', array(
		'height'      => 240,
		'width'       => 240,
		'flex-height' => true,
	) );
	
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );
	
	// Add support for Block Styles.
	add_theme_support( 'wp-block-styles' );

	// Add support for full and wide align images.
	add_theme_support( 'align-wide' );
			
	// Add support for responsive embedded content.
	add_theme_support( 'responsive-embeds' );

    add_theme_support('woocommerce');

	// Enqueue editor styles.
	add_editor_style( array( 'assets/css/editor-style.css' ) );

	if (! defined('GARDEN_LAWN_CARE_VERSION')) {
		// Replace the version number of the theme on each release.
		define('GARDEN_LAWN_CARE_VERSION', wp_get_theme()->get('Version'));
	}

    require get_parent_theme_file_path( '/inc/dashboard/dashboard.php' );

    require get_parent_theme_file_path( '/inc/customizer/customizer.php' );
	
}
endif; // garden_lawn_care_setup
add_action( 'after_setup_theme', 'garden_lawn_care_setup' );

function garden_lawn_care_scripts() {
	wp_enqueue_style( 'garden-lawn-care-basic-style', get_stylesheet_uri() );

	$garden_lawn_care_enable_animations = get_option( 'garden_lawn_care_enable_animations', true );

    if ( $garden_lawn_care_enable_animations ) {
        //animation
		wp_enqueue_script( 'wow-js', get_theme_file_uri( '/assets/js/wow.js' ), array( 'jquery' ), true );

		wp_enqueue_style( 'animate-css', get_template_directory_uri().'/assets/css/animate.css' );
    }

	//font-awesome
	wp_enqueue_style( 'garden-lawn-care-fontawesome', get_template_directory_uri() . '/assets/font-awesome/css/all.css', array(), '5.15.3' );

	//homepage slider
	wp_enqueue_style('garden-lawn-care-swiper-bundle-css', get_template_directory_uri() . '/assets/css/swiper-bundle.css', array(), GARDEN_LAWN_CARE_VERSION);

	wp_enqueue_script('garden-lawn-care-swiper-bundle-js', get_template_directory_uri() . '/assets/js/swiper-bundle.js', array('jquery'), GARDEN_LAWN_CARE_VERSION, true);

	// script.js
	wp_enqueue_script('garden-lawn-care-main-script', get_template_directory_uri() . '/assets/js/script.js', array('jquery'), GARDEN_LAWN_CARE_VERSION, true);
	
    wp_style_add_data( 'garden-lawn-care-basic-style', 'rtl', 'replace' );
}
add_action( 'wp_enqueue_scripts', 'garden_lawn_care_scripts' );


function garden_lawn_care_enqueue_admin_script($hook) {
    // Enqueue admin JS for notices
    wp_enqueue_script('garden-lawn-care-welcome-notice', get_template_directory_uri() . '/inc/dashboard/garden-lawn-care-welcome-notice.js', array('jquery'), '', true);
    
    // Localize script to pass data to JavaScript
    wp_localize_script('garden-lawn-care-welcome-notice', 'garden_lawn_care_localize', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('garden_lawn_care_welcome_nonce'),
        'dismiss_nonce' => wp_create_nonce('garden_lawn_care_welcome_nonce'), // Nonce for dismissal
        'redirect_url' => admin_url('themes.php?page=garden-lawn-care-guide-page')
    ));
}
add_action('admin_enqueue_scripts', 'garden_lawn_care_enqueue_admin_script');

function garden_lawn_care_admin_theme_style() {
   wp_enqueue_style('garden-lawn-care-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/dashboard/dashboard.css');
}
add_action('admin_enqueue_scripts', 'garden_lawn_care_admin_theme_style');

// Block Patterns.
require get_template_directory() . '/block-patterns.php';
require get_template_directory() .'/inc/TGM/tgm.php';
require get_template_directory() . '/custom-setting.php';
require_once get_template_directory() . '/inc/dashboard/welcome-notice.php';

//woocommerce plugin skip 
add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );