<?php 

function garden_lawn_care_add_admin_menu() {
    add_menu_page(
        'Theme Settings', // Page title
        'Theme Settings', // Menu title
        'manage_options', // Capability
        'garden-lawn-care-theme-settings', // Menu slug
        'garden_lawn_care_settings_page' // Function to display the page
    );
}
add_action( 'admin_menu', 'garden_lawn_care_add_admin_menu' );

function garden_lawn_care_settings_page() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'Theme Settings', 'garden-lawn-care' ); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields( 'garden_lawn_care_settings_group' );
            do_settings_sections( 'garden-lawn-care-theme-settings' );
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

function garden_lawn_care_register_settings() {
    register_setting( 'garden_lawn_care_settings_group', 'garden_lawn_care_enable_animations' );

    add_settings_section(
        'garden_lawn_care_settings_section',
        __( 'Animation Settings', 'garden-lawn-care' ),
        null,
        'garden-lawn-care-theme-settings'
    );

    add_settings_field(
        'garden_lawn_care_enable_animations',
        __( 'Enable Animations', 'garden-lawn-care' ),
        'garden_lawn_care_enable_animations_callback',
        'garden-lawn-care-theme-settings',
        'garden_lawn_care_settings_section'
    );
}
add_action( 'admin_init', 'garden_lawn_care_register_settings' );

function garden_lawn_care_enable_animations_callback() {
    $checked = get_option( 'garden_lawn_care_enable_animations', true );
    ?>
    <input type="checkbox" name="garden_lawn_care_enable_animations" value="1" <?php checked( 1, $checked ); ?> />
    <?php
}

