<?php
/**
 * Garden Lawn Care: Block Patterns
 *
 * @since Garden Lawn Care 1.0
 */

/**
 * Registers block patterns and categories.
 *
 * @since Garden Lawn Care 1.0
 *
 * @return void
 */
function garden_lawn_care_register_block_patterns() {
	$garden_lawn_care_block_pattern_categories = array(
		'garden-lawn-care'    => array( 'label' => __( 'Garden Lawn Care', 'garden-lawn-care' ) ),
	);

	$garden_lawn_care_block_pattern_categories = apply_filters( 'garden_lawn_care_block_pattern_categories', $garden_lawn_care_block_pattern_categories );

	foreach ( $garden_lawn_care_block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'garden_lawn_care_register_block_patterns', 9 );
