<?php 

add_action( 'bizberg_before_homepage_blog', 'fully_green_homepage_services' );
function fully_green_homepage_services(){ 

	$services_status = bizberg_get_theme_mod( 'fully_green_services_status' );

	if( $services_status == false ){
		return;
	}

	$services_repeater = bizberg_get_theme_mod( 'fully_green_services_repeater' );
	$services_repeater = json_decode( $services_repeater , true );

	if( empty( $services_repeater ) ){
		return;
	} ?>

	<div class="green_services">
		
		<div class="container">
			
			<div class="services_wrapper">

				<?php 

				foreach( $services_repeater as $value ){

					$icon          = !empty( $value['icon'] ) ? $value['icon'] : '';
					$post_id       = !empty( $value['serices_id'] ) ? $value['serices_id'] : '';
					$services_post = get_post( $post_id ); ?>
				
					<div class="item"> 

						<span class="icon_wrap">
							<i class="<?php echo esc_attr( $icon ); ?>"></i>
						</span>  

	                    <h3><?php echo esc_html( sanitize_text_field( $services_post->post_title ) ); ?></h3>

	                   	<p><?php echo esc_html( sanitize_text_field( $services_post->post_content ) ); ?></p>

	                </div>

                	<?php 

            	} ?>

			</div>

		</div>

	</div>

	<?php 
}